/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model;

import com.supermartijn642.fusion.api.model.DefaultModelTypes;
import com.supermartijn642.fusion.api.model.ModelInstance;
import com.supermartijn642.fusion.extensions.BlockModelExtension;
import com.supermartijn642.fusion.model.BlockModelBakingContextImpl;
import com.supermartijn642.fusion.model.ItemModelBakingContextImpl;
import com.supermartijn642.fusion.model.ModelInstanceImpl;
import com.supermartijn642.fusion.model.ModelTypeRegistryImpl;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.resources.model.MissingBlockModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.context.ContextMap;
import org.jetbrains.annotations.Nullable;

public class FusionBlockModel
implements UnbakedModel {
    public static final ThreadLocal<Identifier> CURRENT_MODEL = new ThreadLocal();
    private final Identifier name;
    private final ModelInstance<?> model;
    private final UnbakedModel vanillaModel;
    private Collection<Identifier> dependencies;
    private Map<Identifier, UnbakedModel> resolvedDependencies;

    public FusionBlockModel(ModelInstance<?> model) {
        Identifier name = CURRENT_MODEL.get();
        this.name = name == null ? IdentifierUtil.withFusionNamespace("unknown") : name;
        this.model = model;
        this.vanillaModel = model.getAsVanillaModel();
    }

    public BlockStateModel bakeBlockModel(ResolvedModel wrapper, ModelBaker modelBakery, ModelState modelState) {
        this.resolveDependencies(modelBakery);
        BlockModelBakingContextImpl context = new BlockModelBakingContextImpl(modelBakery, material -> modelBakery.sprites().get(material, (ModelDebugName)wrapper), modelState, this.name, this.resolvedDependencies, wrapper.getTopTextureSlots().resolvedValues, wrapper.getTopAmbientOcclusion(), wrapper.getTopGuiLight().lightLikeBlock(), wrapper.getTopTransforms(), wrapper.getTopGeometry(), wrapper.getTopAdditionalProperties());
        try {
            return this.model.bakeBlockModel(context);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception while baking block model of type '" + String.valueOf(ModelTypeRegistryImpl.getIdentifier(this.model.getModelType())) + "' for  '" + String.valueOf(this.name) + "'!", e);
        }
    }

    public ItemModel bakeItemModel(ResolvedModel wrapper, ModelBaker modelBakery, List<ItemTintSource> tintSources, EntityModelSet entityModelSet) {
        this.resolveDependencies(modelBakery);
        ItemModelBakingContextImpl context = new ItemModelBakingContextImpl(modelBakery, material -> modelBakery.sprites().get(material, (ModelDebugName)wrapper), this.name, this.resolvedDependencies, wrapper.getTopTextureSlots().resolvedValues, wrapper.getTopAmbientOcclusion(), wrapper.getTopGuiLight().lightLikeBlock(), wrapper.getTopTransforms(), wrapper.getTopGeometry(), wrapper.getTopAdditionalProperties(), tintSources, entityModelSet);
        try {
            return this.model.bakeItemModel(context);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception while baking item model of type '" + String.valueOf(ModelTypeRegistryImpl.getIdentifier(this.model.getModelType())) + "' for  '" + String.valueOf(this.name) + "'!", e);
        }
    }

    private Map<Identifier, UnbakedModel> resolveDependencies(ModelBaker modelBaker) {
        if (this.resolvedDependencies != null) {
            return this.resolvedDependencies;
        }
        if (this.dependencies == null) {
            try {
                this.dependencies = this.model.getModelDependencies();
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst requesting dependencies from model type '" + String.valueOf(ModelTypeRegistryImpl.getIdentifier(this.model.getModelType())) + "' for  '" + String.valueOf(this.name) + "'!", e);
            }
            if (this.dependencies == null) {
                throw new RuntimeException("Model type '" + String.valueOf(ModelTypeRegistryImpl.getIdentifier(this.model.getModelType())) + "' returned null when requesting dependencies '" + String.valueOf(this.name) + "'!");
            }
        }
        this.resolvedDependencies = new HashMap<Identifier, UnbakedModel>(this.dependencies.size());
        for (Identifier location : this.dependencies) {
            this.resolvedDependencies.put(location, modelBaker.getModel(location).wrapped());
        }
        LinkedList<Identifier> unresolved = new LinkedList<Identifier>(this.dependencies);
        while (!unresolved.isEmpty()) {
            Identifier location;
            location = (Identifier)unresolved.removeFirst();
            UnbakedModel unbakedModel = this.resolvedDependencies.get(location);
            if (unbakedModel instanceof FusionBlockModel) {
                FusionBlockModel fusionBlockModel = (FusionBlockModel)unbakedModel;
                this.resolvedDependencies.putAll(fusionBlockModel.resolveDependencies(modelBaker));
                continue;
            }
            Identifier parent = unbakedModel.parent();
            if (parent == null) continue;
            this.resolvedDependencies.put(parent, modelBaker.getModel(parent).wrapped());
            unresolved.add(parent);
        }
        this.resolvedDependencies.put(MissingBlockModel.LOCATION, modelBaker.getModel(MissingBlockModel.LOCATION).wrapped());
        return this.resolvedDependencies;
    }

    public boolean hasVanillaModel() {
        return this.vanillaModel != null;
    }

    public UnbakedModel getVanillaModel() {
        return this.vanillaModel;
    }

    @Nullable
    public UnbakedGeometry geometry() {
        return this.vanillaModel == null ? null : this.vanillaModel.geometry();
    }

    @Nullable
    public UnbakedModel.GuiLight guiLight() {
        return this.vanillaModel == null ? null : this.vanillaModel.guiLight();
    }

    @Nullable
    public Boolean ambientOcclusion() {
        return this.vanillaModel == null ? null : this.vanillaModel.ambientOcclusion();
    }

    @Nullable
    public ItemTransforms transforms() {
        return this.vanillaModel == null ? null : this.vanillaModel.transforms();
    }

    public TextureSlots.Data textureSlots() {
        return this.vanillaModel == null ? new TextureSlots.Data(Map.of()) : this.vanillaModel.textureSlots();
    }

    @Nullable
    public Identifier parent() {
        return this.vanillaModel == null ? null : this.vanillaModel.parent();
    }

    public void fillAdditionalProperties(ContextMap.Builder builder) {
        if (this.vanillaModel != null) {
            this.vanillaModel.fillAdditionalProperties(builder);
        }
    }

    public static ModelInstance<?> getModelInstance(UnbakedModel model) {
        if (model instanceof FusionBlockModel) {
            return ((FusionBlockModel)model).model;
        }
        if (model instanceof BlockModel) {
            ModelInstance<?> modelInstance = ((BlockModelExtension)model).getFusionModel();
            if (modelInstance == null) {
                modelInstance = new ModelInstanceImpl<BlockModel>(DefaultModelTypes.VANILLA, (BlockModel)model);
                ((BlockModelExtension)model).setFusionModel(modelInstance);
            }
            return modelInstance;
        }
        return new ModelInstanceImpl<UnbakedModel>(DefaultModelTypes.UNKNOWN, model);
    }
}

