/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin.sodium;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.texture.QuadTintingHelper;
import com.supermartijn642.fusion.texture.types.base.BaseTextureSprite;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.item.ItemDisplayContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemRenderer.class})
public class ItemRendererMixinSodium {
    @Unique
    private static final ThreadLocal<Iterator<BakedQuad>> lastSubmittedQuads = new ThreadLocal();

    @Inject(method={"renderItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;renderQuadList(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Ljava/util/List;[III)V", shift=At.Shift.BEFORE)})
    private static void captureQuads(ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, int[] colors, List<BakedQuad> quads, RenderType renderType, ItemStackRenderState.FoilType foilType, CallbackInfo ci) {
        for (BakedQuad quad : quads) {
            if (quad.tintIndex() != 39216 || !(quad.sprite() instanceof BaseTextureSprite)) continue;
            lastSubmittedQuads.set(quads.iterator());
            break;
        }
    }

    @Inject(method={"getLayerColorSafe"}, at={@At(value="HEAD")}, cancellable=true)
    private static void overwriteTinting(int[] colors, int tintIndex, CallbackInfoReturnable<Integer> ci) {
        if (tintIndex != 39216) {
            return;
        }
        Iterator<BakedQuad> quads = lastSubmittedQuads.get();
        if (quads == null) {
            return;
        }
        BaseTextureSprite sprite = null;
        while (quads.hasNext()) {
            BaseTextureSprite s;
            TextureAtlasSprite textureAtlasSprite;
            BakedQuad quad = quads.next();
            if (quad.tintIndex() != 39216 || !((textureAtlasSprite = quad.sprite()) instanceof BaseTextureSprite)) continue;
            sprite = s = (BaseTextureSprite)textureAtlasSprite;
            break;
        }
        if (sprite == null) {
            return;
        }
        BaseTextureData.QuadTinting tinting = sprite.data().getTinting();
        if (tinting != null) {
            ci.setReturnValue((Object)QuadTintingHelper.getColor(tinting, null, null, null));
        }
    }

    @Inject(method={"renderItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/entity/ItemRenderer;renderQuadList(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Ljava/util/List;[III)V", shift=At.Shift.AFTER)})
    private static void clearQuads(CallbackInfo ci) {
        lastSubmittedQuads.remove();
    }
}

