/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Sets;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.neoforge.resource.JarContentsPackResources;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={JarContentsPackResources.class})
public class JarContentsPackResourcesMixin
implements PackResourcesExtension {
    @Final
    @Shadow
    private static Logger LOGGER;
    @Unique
    private String overridesFolder;
    @Final
    @Shadow
    private JarContents contents;

    @Override
    public void setFusionOverridesFolder(@NotNull String folder) {
        this.overridesFolder = folder;
    }

    @Shadow
    private String addPrefix(String string) {
        throw new AssertionError();
    }

    @Inject(method={"getResource(Ljava/lang/String;)Lnet/minecraft/server/packs/resources/IoSupplier;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getResource(String path, CallbackInfoReturnable<IoSupplier<InputStream>> ci) {
        if (this.overridesFolder == null) {
            return;
        }
        JarResource resource = this.contents.get(this.addPrefix((String)(path = this.overridesFolder + (String)path)));
        if (resource != null) {
            ci.setReturnValue(() -> ((JarResource)resource).open());
        }
    }

    @ModifyReturnValue(method={"getNamespaces"}, at={@At(value="RETURN")})
    private Set<String> getNamespaces(Set<String> initialNamespaces, PackType type) {
        if (this.overridesFolder == null) {
            return initialNamespaces;
        }
        HashSet namespaces = Sets.newHashSet(initialNamespaces);
        String prefix = this.addPrefix(this.overridesFolder + type.getDirectory() + "/");
        this.contents.visitContent(prefix, (relativePath, resource) -> {
            if (!relativePath.startsWith(prefix)) {
                throw new IllegalStateException("Path received from visitContent doesn't start with prefix '" + prefix + "': " + relativePath);
            }
            int prefixLength = prefix.length();
            int directoryIndex = relativePath.indexOf(47, prefixLength);
            if (directoryIndex == -1) {
                return;
            }
            String namespace = relativePath.substring(prefixLength, directoryIndex);
            if (Identifier.isValidNamespace((String)namespace)) {
                namespaces.add(namespace);
            } else {
                LOGGER.warn("Non [a-z0-9_.-] character in namespace {} in Fusion overrides in pack {}, ignoring", (Object)namespace, (Object)this.contents);
            }
        });
        return namespaces;
    }

    @ModifyVariable(method={"listResources"}, at=@At(value="HEAD"), ordinal=0)
    private PackResources.ResourceOutput modifyListResources(PackResources.ResourceOutput output, PackType type, String namespace, String path) {
        if (this.overridesFolder == null) {
            return output;
        }
        HashSet overriddenLocations = new HashSet();
        String namespaceDirectory = this.addPrefix(this.overridesFolder + type.getDirectory() + "/" + namespace + "/");
        String pathDirectory = namespaceDirectory + path + "/";
        this.contents.visitContent(pathDirectory, (relativePath, resource) -> {
            String identifier = relativePath.substring(namespaceDirectory.length());
            Identifier location = Identifier.tryBuild((String)namespace, (String)identifier);
            if (location != null) {
                overriddenLocations.add(location);
                output.accept((Object)location, () -> ((JarResource)resource.retain()).open());
            } else {
                LOGGER.warn("Invalid path in Fusion overrides in datapack: {}:{}, ignoring", (Object)namespace, (Object)identifier);
            }
        });
        return (location, streamSupplier) -> {
            if (!overriddenLocations.contains(location)) {
                output.accept(location, streamSupplier);
            }
        };
    }
}

