/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model.predicates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicate;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class BiomeEntityModelPredicate
implements EntityModelPredicate {
    public static final Serializer<BiomeEntityModelPredicate> SERIALIZER = new Serializer<BiomeEntityModelPredicate>(){

        @Override
        public BiomeEntityModelPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!json.has("biomes") || !json.get("biomes").isJsonArray()) {
                throw new JsonParseException("Biome-predicate must have array property 'biomes'!");
            }
            HashSet<Identifier> biomes = new HashSet<Identifier>();
            for (JsonElement element : json.getAsJsonArray("biomes")) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array property 'biomes' must only contain strings!");
                }
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Biome entries must be a valid identifier, not '" + element.getAsString() + "'!");
                }
                biomes.add(Identifier.parse((String)element.getAsString()));
            }
            return new BiomeEntityModelPredicate(biomes);
        }

        @Override
        public JsonObject serialize(BiomeEntityModelPredicate value) {
            JsonObject json = new JsonObject();
            JsonArray biomes = new JsonArray(value.biomes.size());
            value.biomes.stream().map(Identifier::toString).sorted().forEach(arg_0 -> ((JsonArray)biomes).add(arg_0));
            json.add("biomes", (JsonElement)biomes);
            return json;
        }
    };
    private final Set<Identifier> biomes;

    public BiomeEntityModelPredicate(Set<Identifier> biomes) {
        this.biomes = Set.copyOf(biomes);
    }

    @Override
    public boolean test(Entity entity) {
        if (this.biomes.isEmpty()) {
            return false;
        }
        Level level = entity.level();
        if (level == null) {
            return false;
        }
        Holder biome = level.getBiome(entity.blockPosition());
        return biome != null && biome.isBound() && this.biomes.contains(((ResourceKey)biome.unwrapKey().get()).identifier());
    }

    @Override
    public Serializer<? extends EntityModelPredicate> getSerializer() {
        return SERIALIZER;
    }
}

