/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.supermartijn642.fusion.entity.EntityRenderTypeHelper;
import com.supermartijn642.fusion.entity.VanillaModelLayerProperties;
import com.supermartijn642.fusion.entity.model.EntityLayerProperties;
import com.supermartijn642.fusion.entity.model.SubModelPart;
import com.supermartijn642.fusion.extensions.BufferSourceExtension;
import com.supermartijn642.fusion.extensions.EntityExtension;
import com.supermartijn642.fusion.extensions.EntityRenderStateExtension;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;

public class FusionModelPart
extends SubModelPart {
    public static final ThreadLocal<MultiBufferSource.BufferSource> BUFFER_SOURCE_CONTEXT = new ThreadLocal();
    public static final ThreadLocal<EntityRenderStateExtension> RENDER_STATE_CONTEXT = new ThreadLocal();
    private final int layerIndex;
    private final ModelPart original;
    private VanillaModelLayerProperties vanillaProperties;
    private EntityLayerProperties properties;
    private boolean ready;
    private Identifier currentTexture;
    private Float currentScaling;
    private RenderType adjustedRenderType;

    public FusionModelPart(int layerIndex, ModelPart original) {
        super(null);
        this.mainPart = this;
        this.layerIndex = layerIndex;
        this.original = original;
    }

    public void setProperties(EntityLayerProperties properties, VanillaModelLayerProperties vanillaProperties) {
        this.properties = properties;
        this.vanillaProperties = vanillaProperties;
        if (properties == null) {
            this.mirror(this.original);
        }
    }

    public void extractState(Entity entity, EntityRenderStateExtension state) {
        EntityLayerProperties.ModelChoice model;
        if (this.properties == null) {
            return;
        }
        if (((EntityExtension)entity).shouldFusionRecomputeModel(this.layerIndex)) {
            model = this.properties.chooseModel(entity);
            ((EntityExtension)entity).setFusionModel(this.layerIndex, model);
        } else {
            model = ((EntityExtension)entity).getFusionModel(this.layerIndex);
        }
        state.setFusionModel(this.layerIndex, model);
    }

    public void setup() {
        if (this.properties == null) {
            return;
        }
        EntityRenderStateExtension state = RENDER_STATE_CONTEXT.get();
        if (state == null) {
            return;
        }
        EntityLayerProperties.ModelChoice modelChoice = state.getFusionModel(this.layerIndex);
        if (modelChoice == null) {
            return;
        }
        ModelPart currentModel = modelChoice.model();
        this.currentTexture = modelChoice.texture();
        this.currentScaling = modelChoice.scaling();
        FusionModelPart.resetPose(currentModel);
        this.mirror(currentModel);
        this.ready = true;
    }

    public void clear() {
        if (this.properties == null) {
            return;
        }
        this.currentTexture = null;
        this.currentScaling = null;
        this.adjustedRenderType = null;
        this.ready = false;
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, int k) {
        this.renderPart(this, poseStack, vertexConsumer, i, j, k);
    }

    public void renderPart(SubModelPart part, PoseStack poseStack, VertexConsumer vertexConsumer, int i, int j, int k) {
        MultiBufferSource.BufferSource bufferSource;
        if (!this.visible) {
            return;
        }
        this.setup();
        if (!this.ready) {
            if (part == this) {
                this.original.render(poseStack, vertexConsumer, i, j, k);
            }
            return;
        }
        if (this.currentTexture != null && (bufferSource = BUFFER_SOURCE_CONTEXT.get()) != null) {
            vertexConsumer = this.adjustTexture(vertexConsumer, (MultiBufferSource)bufferSource);
        }
        poseStack.pushPose();
        this.vanillaProperties.transform(poseStack);
        if (this.currentScaling != null) {
            poseStack.scale(this.currentScaling.floatValue(), this.currentScaling.floatValue(), this.currentScaling.floatValue());
        }
        part.renderInternal(poseStack, vertexConsumer, i, j, k);
        poseStack.popPose();
        this.clear();
    }

    private static void resetPose(ModelPart part) {
        part.resetPose();
        part.children.values().forEach(FusionModelPart::resetPose);
    }

    private VertexConsumer adjustTexture(VertexConsumer buffer, MultiBufferSource bufferSource) {
        if (!(bufferSource instanceof BufferSourceExtension)) {
            return buffer;
        }
        RenderType renderType = ((BufferSourceExtension)bufferSource).fusionGetLastRenderType();
        if (this.adjustedRenderType != null && this.adjustedRenderType == renderType) {
            return bufferSource.getBuffer(renderType);
        }
        RenderSetup.TextureBinding sampler0 = (RenderSetup.TextureBinding)renderType.state.textures.get("Sampler0");
        if (sampler0 == null) {
            return buffer;
        }
        Identifier texture = sampler0.location();
        if (this.currentTexture.equals((Object)texture)) {
            return buffer;
        }
        if ((renderType = EntityRenderTypeHelper.getRenderTypeWithTexture(renderType, this.currentTexture)) == null) {
            return buffer;
        }
        this.adjustedRenderType = renderType;
        return bufferSource.getBuffer(renderType);
    }
}

