/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.resources.Identifier;

public class EntityRenderTypeHelper {
    private static final Map<String, Function<Identifier, RenderType>> RENDER_TYPES_BY_NAME;
    private static final Map<String, BiFunction<Identifier, Boolean, RenderType>> VAR_OUTLINE_RENDER_TYPES_BY_NAME;

    public static RenderType getRenderTypeWithTexture(RenderType renderType, Identifier texture) {
        BiFunction<Identifier, Boolean, RenderType> varOutlineSupplier = VAR_OUTLINE_RENDER_TYPES_BY_NAME.get(renderType.name);
        if (varOutlineSupplier != null) {
            RenderSetup.OutlineProperty outlineProperty = renderType.state.outlineProperty;
            return varOutlineSupplier.apply(texture, outlineProperty == RenderSetup.OutlineProperty.AFFECTS_OUTLINE);
        }
        Function<Identifier, RenderType> supplier = RENDER_TYPES_BY_NAME.get(renderType.name);
        if (supplier != null) {
            return supplier.apply(texture);
        }
        return null;
    }

    static {
        ImmutableMap.Builder renderTypes = ImmutableMap.builder();
        renderTypes.put((Object)"armor_cutout_no_cull", RenderTypes::armorCutoutNoCull);
        renderTypes.put((Object)"armor_translucent", RenderTypes::armorTranslucent);
        renderTypes.put((Object)"entity_solid", RenderTypes::entitySolid);
        renderTypes.put((Object)"entity_solid_z_offset_forward", RenderTypes::entitySolidZOffsetForward);
        renderTypes.put((Object)"entity_cutout", RenderTypes::entityCutout);
        renderTypes.put((Object)"item_entity_translucent_cull", RenderTypes::itemEntityTranslucentCull);
        renderTypes.put((Object)"entity_smooth_cutout", RenderTypes::entitySmoothCutout);
        renderTypes.put((Object)"entity_decal", RenderTypes::entityDecal);
        renderTypes.put((Object)"entity_no_outline", RenderTypes::entityNoOutline);
        renderTypes.put((Object)"entity_shadow", RenderTypes::entityShadow);
        renderTypes.put((Object)"entity_alpha", RenderTypes::dragonExplosionAlpha);
        renderTypes.put((Object)"eyes", RenderTypes::eyes);
        RENDER_TYPES_BY_NAME = renderTypes.build();
        ImmutableMap.Builder outlineRenderTypes = ImmutableMap.builder();
        outlineRenderTypes.put((Object)"entity_cutout_no_cull", RenderTypes::entityCutoutNoCull);
        outlineRenderTypes.put((Object)"entity_cutout_no_cull_z_offset", RenderTypes::entityCutoutNoCullZOffset);
        outlineRenderTypes.put((Object)"entity_translucent", RenderTypes::entityTranslucent);
        outlineRenderTypes.put((Object)"entity_translucent_emissive", RenderTypes::entityTranslucentEmissive);
        VAR_OUTLINE_RENDER_TYPES_BY_NAME = outlineRenderTypes.build();
    }
}

