/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.util.Either;
import com.supermartijn642.fusion.entity.model.predicates.AndEntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicate;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicateRegistry;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.world.entity.EntityType;

public class EntityModelModifierReloadListener {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final String LOCATION = "fusion/model_modifiers/entities";
    private static final FileToIdConverter ID_CONVERTER = FileToIdConverter.json((String)"fusion/model_modifiers/entities");
    private static final Map<EntityType<?>, Modifier> MODIFIERS = new HashMap();

    public static Map<EntityType<?>, Modifier> getModifiers() {
        return MODIFIERS;
    }

    public static void getModelLocations(Consumer<Identifier> output) {
        for (Modifier modifier : MODIFIERS.values()) {
            modifier.gatherModelLocations(output);
        }
    }

    public static void reload(ResourceManager resourceManager) {
        MODIFIERS.clear();
        HashMap resources = new HashMap();
        SimpleJsonResourceReloadListener.scanDirectory((ResourceManager)resourceManager, (FileToIdConverter)ID_CONVERTER, (DynamicOps)JsonOps.INSTANCE, (Codec)new Codec<JsonElement>(){

            public <T> DataResult<Pair<JsonElement, T>> decode(DynamicOps<T> ops, T input) {
                return DataResult.success((Object)Pair.of((Object)((JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input)), input));
            }

            public <T> DataResult<T> encode(JsonElement input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)JsonOps.INSTANCE.convertTo(ops, input));
            }
        }, resources);
        for (Map.Entry entry : resources.entrySet()) {
            Identifier location = (Identifier)entry.getKey();
            if (!((JsonElement)entry.getValue()).isJsonObject()) {
                throw new IllegalArgumentException("Entity model modifier '" + String.valueOf(location) + "' must contain a json object!");
            }
            JsonObject json = ((JsonElement)entry.getValue()).getAsJsonObject();
            try {
                EntityModelModifierReloadListener.parseResource(json);
            }
            catch (JsonParseException e) {
                FusionClient.LOGGER.error("Failed to parse entity model modifier '{}': {}", (Object)location, (Object)e.getMessage());
                while (e.getCause() instanceof JsonParseException) {
                    e = (JsonParseException)e.getCause();
                    FusionClient.LOGGER.error("   {}", (Object)e.getMessage());
                }
            }
        }
    }

    private static void parseResource(JsonObject json) {
        if (!json.has("targets") || !json.get("targets").isJsonArray()) {
            throw new JsonParseException("Entity model modifier must have array property 'targets'!");
        }
        JsonArray targetsJson = json.getAsJsonArray("targets");
        HashSet<EntityType> targets = new HashSet<EntityType>();
        for (JsonElement element : targetsJson) {
            if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                throw new JsonParseException("Property 'targets' array must only contain strings!");
            }
            if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                throw new JsonParseException("Target must be a valid identifier, not '" + element.getAsString() + "'!!");
            }
            Identifier identifier = Identifier.parse((String)element.getAsString());
            Optional entityType = BuiltInRegistries.ENTITY_TYPE.getOptional(identifier);
            if (entityType.isEmpty()) {
                throw new JsonParseException("Could not find an entity type for '" + String.valueOf(identifier) + "'!");
            }
            targets.add((EntityType)entityType.get());
        }
        if (!json.has("layers") || !json.get("layers").isJsonObject()) {
            throw new JsonParseException("Entity model modifier must contain layer objects!");
        }
        JsonObject layersJson = json.get("layers").getAsJsonObject();
        HashMap<String, Layer> layers = new HashMap<String, Layer>();
        for (String name : layersJson.keySet()) {
            if (!IdentifierUtil.isValidIdentifier(name)) {
                throw new JsonParseException("Layer name must be a valid identifier, not '" + name + "'!");
            }
            if (!layersJson.get(name).isJsonObject()) {
                throw new JsonParseException("Property 'layers' object must only contain objects, layer '" + name + "' is not an object!");
            }
            Layer layer = EntityModelModifierReloadListener.parseLayer(layersJson.getAsJsonObject(name), name);
            layers.put(name, layer);
        }
        for (EntityType target : targets) {
            Modifier modifier = MODIFIERS.computeIfAbsent(target, Modifier::new);
            Identifier entityIdentifier = BuiltInRegistries.ENTITY_TYPE.getKey((Object)target);
            for (Map.Entry entry : layers.entrySet()) {
                ModelLayerLocation location = new ModelLayerLocation(entityIdentifier, (String)entry.getKey());
                modifier.layers.put(location, (Layer)entry.getValue());
            }
        }
    }

    private static Layer parseLayer(JsonObject json, String layerName) {
        ModelOption defaultProperties = EntityModelModifierReloadListener.parseModelOption((JsonElement)json, layerName);
        ArrayList<com.supermartijn642.fusion.api.util.Pair<EntityModelPredicate, ModelOption>> conditionals = new ArrayList<com.supermartijn642.fusion.api.util.Pair<EntityModelPredicate, ModelOption>>();
        if (json.has("conditionals")) {
            if (!json.get("conditionals").isJsonArray()) {
                throw new JsonParseException("Property 'conditionals' for layer '" + layerName + "' must be an array!");
            }
            for (JsonElement element : json.getAsJsonArray("conditionals")) {
                if (!element.isJsonObject()) {
                    throw new JsonParseException("Array property 'conditionals' for layer '" + layerName + "' must only contain objects!");
                }
                conditionals.add(EntityModelModifierReloadListener.parseConditional(element.getAsJsonObject()));
            }
        }
        return new Layer(defaultProperties, conditionals);
    }

    private static com.supermartijn642.fusion.api.util.Pair<EntityModelPredicate, ModelOption> parseConditional(JsonObject json) {
        if (!json.has("model") && !json.has("texture")) {
            throw new JsonParseException("Conditional model entry must have at least one of 'model' or 'texture'!");
        }
        ModelOption options = EntityModelModifierReloadListener.parseModelOption((JsonElement)json, "model");
        if (!json.has("conditions") || !json.get("conditions").isJsonArray()) {
            throw new JsonParseException("Conditional model entry must array property 'conditions'!");
        }
        JsonArray conditionsJson = json.getAsJsonArray("conditions");
        if (conditionsJson.isEmpty()) {
            throw new JsonParseException("Property 'conditions' must not be empty!");
        }
        ArrayList<EntityModelPredicate> conditions = new ArrayList<EntityModelPredicate>();
        for (JsonElement element : conditionsJson) {
            if (!element.isJsonObject()) {
                throw new JsonParseException("Array property 'conditions' must only contain objects!");
            }
            EntityModelPredicate predicate = EntityModelPredicateRegistry.deserializeEntityModelPredicate(element.getAsJsonObject());
            conditions.add(predicate);
        }
        EntityModelPredicate combined = conditions.size() == 1 ? (EntityModelPredicate)conditions.get(0) : new AndEntityModelPredicate(conditions);
        return com.supermartijn642.fusion.api.util.Pair.of(combined, options);
    }

    private static List<ModelOption> parseModelOptions(JsonElement json, String propertyName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString() || json.isJsonObject()) {
            return List.of(EntityModelModifierReloadListener.parseModelOption(json, propertyName));
        }
        if (!json.isJsonArray()) {
            throw new JsonParseException("Property '" + propertyName + "' must be a string, object, or array!");
        }
        ArrayList<ModelOption> options = new ArrayList<ModelOption>(json.getAsJsonArray().size());
        for (JsonElement element : json.getAsJsonArray()) {
            options.add(EntityModelModifierReloadListener.parseModelOption(element, propertyName));
        }
        return options;
    }

    private static ModelOption parseModelOption(JsonElement element, String propertyName) {
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                throw new JsonParseException("Property '" + propertyName + "' must be a valid identifier, not '" + element.getAsString() + "'!");
            }
            return new ModelOption(Either.left(Identifier.parse((String)element.getAsString())), null, null, null, null, null, null, null, null, 1.0f);
        }
        if (element.isJsonObject()) {
            JsonObject json = element.getAsJsonObject();
            Either<Identifier, List<ModelOption>> model = null;
            if (json.has("model")) {
                model = Either.right(EntityModelModifierReloadListener.parseModelOptions(json.get("model"), propertyName));
            }
            List<Identifier> textures = json.has("texture") ? EntityModelModifierReloadListener.parseTextures(json.get("texture"), propertyName) : null;
            Boolean flipX = null;
            if (json.has("flip_x")) {
                if (!json.get("flip_x").isJsonPrimitive() || !json.getAsJsonPrimitive("flip_x").isBoolean()) {
                    throw new JsonParseException("Property 'flip_x' must be a boolean!");
                }
                flipX = json.get("flip_x").getAsBoolean();
            }
            Boolean flipY = null;
            if (json.has("flip_y")) {
                if (!json.get("flip_y").isJsonPrimitive() || !json.getAsJsonPrimitive("flip_y").isBoolean()) {
                    throw new JsonParseException("Property 'flip_y' must be a boolean!");
                }
                flipY = json.get("flip_y").getAsBoolean();
            }
            Boolean flipZ = null;
            if (json.has("flip_z")) {
                if (!json.get("flip_z").isJsonPrimitive() || !json.getAsJsonPrimitive("flip_z").isBoolean()) {
                    throw new JsonParseException("Property 'flip_z' must be a boolean!");
                }
                flipZ = json.get("flip_z").getAsBoolean();
            }
            Float offsetX = null;
            if (json.has("offset_x")) {
                if (!json.get("offset_x").isJsonPrimitive() || !json.getAsJsonPrimitive("offset_x").isNumber()) {
                    throw new JsonParseException("Property 'offset_x' must be a number!");
                }
                offsetX = Float.valueOf(json.get("offset_x").getAsFloat());
            }
            Float offsetY = null;
            if (json.has("offset_y")) {
                if (!json.get("offset_y").isJsonPrimitive() || !json.getAsJsonPrimitive("offset_y").isNumber()) {
                    throw new JsonParseException("Property 'offset_y' must be a number!");
                }
                offsetY = Float.valueOf(json.get("offset_y").getAsFloat());
            }
            Float offsetZ = null;
            if (json.has("offset_z")) {
                if (!json.get("offset_z").isJsonPrimitive() || !json.getAsJsonPrimitive("offset_z").isNumber()) {
                    throw new JsonParseException("Property 'offset_z' must be a number!");
                }
                offsetZ = Float.valueOf(json.get("offset_z").getAsFloat());
            }
            Float scale = null;
            if (json.has("scale")) {
                if (!json.get("scale").isJsonPrimitive() || !json.getAsJsonPrimitive("scale").isNumber()) {
                    throw new JsonParseException("Property 'scale' must be a number!");
                }
                scale = Float.valueOf(json.get("scale").getAsFloat());
                if (scale.floatValue() <= 0.0f) {
                    throw new JsonParseException("Property 'scale' must be greater than zero!");
                }
            }
            float weight = 1.0f;
            if (json.has("weight")) {
                if (!json.get("weight").isJsonPrimitive() || !json.getAsJsonPrimitive("weight").isNumber()) {
                    throw new JsonParseException("Property 'weight' must be a number!");
                }
                weight = json.get("weight").getAsFloat();
                if (weight <= 0.0f) {
                    throw new JsonParseException("Property 'weight' must be greater than zero!");
                }
            }
            return new ModelOption(model, textures, flipX, flipY, flipZ, offsetX, offsetY, offsetZ, scale, weight);
        }
        throw new JsonParseException("Property '" + propertyName + "' must be a string or an object!");
    }

    private static List<Identifier> parseTextures(JsonElement json, String propertyName) {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            if (!IdentifierUtil.isValidIdentifier(json.getAsString())) {
                throw new JsonParseException("Texture must be a valid location, not '" + json.getAsString() + "'!");
            }
            return List.of(Identifier.parse((String)("textures/" + json.getAsString() + ".png")));
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            ArrayList<Identifier> textures = new ArrayList<Identifier>(array.size());
            for (JsonElement element : array) {
                if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
                    throw new JsonParseException("Array property '" + propertyName + "' must only contain strings!");
                }
                if (!IdentifierUtil.isValidIdentifier(element.getAsString())) {
                    throw new JsonParseException("Texture must be a valid identifier, not '" + element.getAsString() + "'!!");
                }
                textures.add(Identifier.parse((String)("textures/" + element.getAsString() + ".png")));
            }
            return textures;
        }
        throw new JsonParseException("Property '" + propertyName + "' must be either a string or an array of strings!");
    }

    public static class Modifier {
        public final EntityType<?> entityType;
        public final Map<ModelLayerLocation, Layer> layers = new LinkedHashMap<ModelLayerLocation, Layer>();

        private Modifier(EntityType<?> entityType) {
            this.entityType = entityType;
        }

        void gatherModelLocations(Consumer<Identifier> output) {
            this.layers.values().forEach(layer -> layer.gatherModelLocations(output));
        }
    }

    public static class Layer {
        public final ModelOption defaultModel;
        public final List<com.supermartijn642.fusion.api.util.Pair<EntityModelPredicate, ModelOption>> conditionals;

        private Layer(ModelOption defaultModel, List<com.supermartijn642.fusion.api.util.Pair<EntityModelPredicate, ModelOption>> conditionals) {
            this.defaultModel = defaultModel;
            this.conditionals = conditionals;
        }

        void gatherModelLocations(Consumer<Identifier> output) {
            this.defaultModel.gatherModelLocations(output);
            for (com.supermartijn642.fusion.api.util.Pair<EntityModelPredicate, ModelOption> conditional : this.conditionals) {
                conditional.right().gatherModelLocations(output);
            }
        }
    }

    public static class ModelOption {
        public final Either<Identifier, List<ModelOption>> model;
        public final List<Identifier> textures;
        public final Boolean flipX;
        public final Boolean flipY;
        public final Boolean flipZ;
        public final Float offsetX;
        public final Float offsetY;
        public final Float offsetZ;
        public final Float scale;
        public final double weight;

        public ModelOption(Either<Identifier, List<ModelOption>> model, List<Identifier> textures, Boolean flipX, Boolean flipY, Boolean flipZ, Float offsetX, Float offsetY, Float offsetZ, Float scale, float weight) {
            this.model = model;
            this.textures = textures;
            this.flipX = flipX;
            this.flipY = flipY;
            this.flipZ = flipZ;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.scale = scale;
            this.weight = weight;
        }

        void gatherModelLocations(Consumer<Identifier> output) {
            if (this.model != null) {
                if (this.model.isLeft()) {
                    output.accept(this.model.left());
                } else {
                    this.model.right().forEach(o -> o.gatherModelLocations(output));
                }
            }
        }
    }
}

