/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.util.Either;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.entity.EntityModelModifier;
import com.supermartijn642.fusion.entity.EntityModelModifierReloadListener;
import com.supermartijn642.fusion.entity.VanillaModelLayerProperties;
import com.supermartijn642.fusion.entity.model.EntityLayerProperties;
import com.supermartijn642.fusion.entity.model.FusionModelPart;
import com.supermartijn642.fusion.entity.model.ModelTransformer;
import com.supermartijn642.fusion.entity.model.loader.FusionEntityModelLoader;
import com.supermartijn642.fusion.entity.model.predicates.EntityModelPredicate;
import com.supermartijn642.fusion.extensions.EntityRendererExtension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.EntityType;

public class EntityModelModifierManager {
    private static final ThreadLocal<Boolean> trackingBakedModels = ThreadLocal.withInitial(() -> false);
    private static final Set<ModelLayerLocation> currentModifierLayers = new HashSet<ModelLayerLocation>();
    private static final Map<ModelLayerLocation, FusionModelPart> overwrittenModelParts = new HashMap<ModelLayerLocation, FusionModelPart>();
    private static int currentLayerIndex = 0;
    private static final Map<EntityType<?>, EntityModelModifier> MODEL_PROPERTIES = new HashMap();
    public static int reloadCounter = 0;

    public static void bakeModels(Map<ModelLayerLocation, LayerDefinition> originalModels) {
        MODEL_PROPERTIES.clear();
        ++reloadCounter;
        HashMap<Identifier, Supplier<ModelPart>> vanillaModels = new HashMap<Identifier, Supplier<ModelPart>>();
        originalModels.forEach((layer, layerDefinition) -> vanillaModels.put(FusionEntityModelLoader.locationForLayer(layer), () -> ((LayerDefinition)layerDefinition).bakeRoot()));
        Map<EntityType<?>, EntityModelModifierReloadListener.Modifier> modifiers = EntityModelModifierReloadListener.getModifiers();
        for (Map.Entry<EntityType<?>, EntityModelModifierReloadListener.Modifier> entry : modifiers.entrySet()) {
            EntityType<?> entity = entry.getKey();
            EntityModelModifierReloadListener.Modifier modifier = entry.getValue();
            ImmutableMap.Builder layers = ImmutableMap.builder();
            for (Map.Entry<ModelLayerLocation, EntityModelModifierReloadListener.Layer> layerEntry : modifier.layers.entrySet()) {
                List<EntityLayerProperties.ModelOption> defaultModels;
                ModelLayerLocation layerIdentifier = layerEntry.getKey();
                EntityModelModifierReloadListener.Layer rawLayer = layerEntry.getValue();
                HashSet<Identifier> missingModels = new HashSet<Identifier>();
                List<EntityLayerProperties.ModelOption> list = defaultModels = rawLayer.defaultModel.model == null ? EntityModelModifierManager.bakeModelOptions(layerIdentifier, List.of(new EntityModelModifierReloadListener.ModelOption(Either.left(FusionEntityModelLoader.locationForLayer(layerIdentifier)), null, null, null, null, null, null, null, null, 1.0f)), null, rawLayer.defaultModel, vanillaModels, missingModels) : EntityModelModifierManager.bakeModelOptions(layerIdentifier, List.of(rawLayer.defaultModel), null, rawLayer.defaultModel, vanillaModels, missingModels);
                if (defaultModels == null) continue;
                ArrayList<Pair<EntityModelPredicate, List<EntityLayerProperties.ModelOption>>> conditionals = new ArrayList<Pair<EntityModelPredicate, List<EntityLayerProperties.ModelOption>>>();
                for (Pair<EntityModelPredicate, EntityModelModifierReloadListener.ModelOption> conditional : rawLayer.conditionals) {
                    EntityModelPredicate predicate = conditional.left();
                    EntityModelModifierReloadListener.ModelOption rawModel = conditional.right();
                    List<EntityLayerProperties.ModelOption> options = EntityModelModifierManager.bakeModelOptions(layerIdentifier, List.of(rawModel), defaultModels, rawLayer.defaultModel, vanillaModels, missingModels);
                    if (options == null) {
                        return;
                    }
                    conditionals.add(Pair.of(predicate, options));
                }
                layers.put((Object)layerIdentifier, (Object)new EntityLayerProperties(layerIdentifier, defaultModels, conditionals));
            }
            MODEL_PROPERTIES.put(entity, new EntityModelModifier((Map<ModelLayerLocation, EntityLayerProperties>)layers.build()));
        }
    }

    private static List<EntityLayerProperties.ModelOption> bakeModelOptions(ModelLayerLocation layer, List<EntityModelModifierReloadListener.ModelOption> rawOptions, List<EntityLayerProperties.ModelOption> defaultModels, EntityModelModifierReloadListener.ModelOption defaults, Map<Identifier, Supplier<ModelPart>> vanillaModels, Set<Identifier> missingModels) {
        ArrayList<EntityLayerProperties.ModelOption> options = new ArrayList<EntityLayerProperties.ModelOption>(rawOptions.size());
        for (EntityModelModifierReloadListener.ModelOption option : rawOptions) {
            float offset;
            if (option.model == null || option.model.isRight()) {
                List<EntityLayerProperties.ModelOption> models;
                if (option.model == null) {
                    models = defaultModels;
                } else {
                    models = EntityModelModifierManager.bakeModelOptions(layer, option.model.right(), defaultModels, defaults, vanillaModels, missingModels);
                    if (models == null) {
                        return null;
                    }
                }
                if (models == null) {
                    FusionClient.LOGGER.error("No model defined for an entry in layer '{}'", (Object)layer);
                    return null;
                }
                double totalWeight = models.stream().mapToDouble(EntityLayerProperties.ModelOption::weight).sum();
                for (EntityLayerProperties.ModelOption defaultModel : models) {
                    List<Identifier> textures;
                    List<Identifier> list = option.textures == null ? (defaultModel.textures() == null ? defaults.textures : defaultModel.textures()) : (textures = option.textures);
                    Float scale = option.scale == null ? (defaultModel.scaling() == null ? defaults.scale : defaultModel.scaling()) : option.scale;
                    options.add(new EntityLayerProperties.ModelOption(defaultModel.model(), defaultModel.isVanillaModel(), textures, defaultModel.weight() / totalWeight * option.weight, scale));
                }
                continue;
            }
            Pair<ModelPart, Boolean> baked = EntityModelModifierManager.bakeModel(layer, option.model.left(), vanillaModels, missingModels);
            if (baked == null) {
                return null;
            }
            ModelPart model = baked.left();
            float f = option.offsetX == null ? (defaults.offsetX == null ? 0.0f : defaults.offsetX.floatValue()) : (offset = option.offsetX.floatValue());
            if (offset != 0.0f) {
                model = ModelTransformer.translateX(model, offset);
            }
            float f2 = option.offsetY == null ? (defaults.offsetY == null ? 0.0f : defaults.offsetY.floatValue()) : (offset = option.offsetY.floatValue());
            if (offset != 0.0f) {
                model = ModelTransformer.translateY(model, offset);
            }
            float f3 = option.offsetZ == null ? (defaults.offsetZ == null ? 0.0f : defaults.offsetZ.floatValue()) : (offset = option.offsetZ.floatValue());
            if (offset != 0.0f) {
                model = ModelTransformer.translateZ(model, offset);
            }
            if (option.flipX == null ? defaults.flipX == Boolean.TRUE : option.flipX != false) {
                model = ModelTransformer.flipX(model);
            }
            if (option.flipY == null ? defaults.flipY == Boolean.TRUE : option.flipY != false) {
                model = ModelTransformer.flipY(model);
            }
            if (option.flipZ == null ? defaults.flipZ == Boolean.TRUE : option.flipZ != false) {
                model = ModelTransformer.flipZ(model);
            }
            List<Identifier> textures = option.textures == null ? defaults.textures : option.textures;
            Float scale = option.scale == null ? defaults.scale : option.scale;
            options.add(new EntityLayerProperties.ModelOption(model, baked.right(), textures, option.weight, scale));
        }
        double totalWeight = options.stream().mapToDouble(EntityLayerProperties.ModelOption::weight).sum();
        if (totalWeight != 1.0) {
            for (int i = 0; i < options.size(); ++i) {
                EntityLayerProperties.ModelOption option = (EntityLayerProperties.ModelOption)options.get(i);
                options.set(i, new EntityLayerProperties.ModelOption(option.model(), option.isVanillaModel(), option.textures(), option.weight() / totalWeight, option.scaling()));
            }
        }
        options.sort(Comparator.comparingDouble(EntityLayerProperties.ModelOption::weight).reversed());
        return options;
    }

    private static Pair<ModelPart, Boolean> bakeModel(ModelLayerLocation layer, Identifier modelLocation, Map<Identifier, Supplier<ModelPart>> vanillaModels, Set<Identifier> missingModels) {
        Supplier<ModelPart> vanillaSupplier;
        ModelPart model = FusionEntityModelLoader.MODELS.get(modelLocation);
        boolean isVanillaModel = false;
        if (model == null && (vanillaSupplier = vanillaModels.get(modelLocation)) != null) {
            model = vanillaSupplier.get();
            isVanillaModel = true;
        }
        if (model == null) {
            if (!missingModels.add(modelLocation)) {
                FusionClient.LOGGER.error("Missing model '{}' for layer '{}'!", (Object)modelLocation, (Object)layer);
            }
            return null;
        }
        return Pair.of(model, isVanillaModel);
    }

    public static FusionModelPart handleModelBake(ModelLayerLocation location, ModelPart original) {
        if (!trackingBakedModels.get().booleanValue()) {
            return null;
        }
        if (!currentModifierLayers.contains(location) && !FusionEntityModelLoader.MODELS.containsKey(FusionEntityModelLoader.locationForLayer(location))) {
            return null;
        }
        FusionModelPart fusionModelPart = new FusionModelPart(currentLayerIndex++, original);
        overwrittenModelParts.put(location, fusionModelPart);
        return fusionModelPart;
    }

    public static EntityRenderer<?, ?> handleRendererCreation(EntityType<?> entityType, EntityRendererProvider<?> rendererProvider, EntityRendererProvider.Context context) {
        EntityRenderer renderer;
        EntityModelModifier properties = MODEL_PROPERTIES.get(entityType);
        if (properties != null) {
            currentModifierLayers.addAll(properties.getLayers().keySet());
        }
        trackingBakedModels.set(true);
        try {
            renderer = rendererProvider.create(context);
        }
        catch (Exception e) {
            overwrittenModelParts.clear();
            throw e;
        }
        finally {
            trackingBakedModels.set(false);
            currentModifierLayers.clear();
            currentLayerIndex = 0;
        }
        if (properties != null) {
            for (ModelLayerLocation modelLayerLocation : properties.getLayers().keySet()) {
                if (overwrittenModelParts.containsKey(modelLayerLocation)) continue;
                FusionClient.LOGGER.warn("An entity model modifier for entity '{}' overwrites layer '{}', but no such layer was found!", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(entityType), (Object)modelLayerLocation);
            }
        }
        if (!overwrittenModelParts.isEmpty()) {
            for (Map.Entry entry : overwrittenModelParts.entrySet()) {
                EntityLayerProperties layerProperties;
                ModelLayerLocation layer = (ModelLayerLocation)entry.getKey();
                FusionModelPart fusionModelPart = (FusionModelPart)((Object)entry.getValue());
                fusionModelPart.finish();
                if (properties != null && properties.getLayers().containsKey(layer)) {
                    layerProperties = properties.getLayers().get(layer);
                } else {
                    ModelPart model = FusionEntityModelLoader.MODELS.get(FusionEntityModelLoader.locationForLayer(layer));
                    layerProperties = new EntityLayerProperties(layer, List.of(new EntityLayerProperties.ModelOption(model, false, null, 1.0, null)), List.of());
                }
                HashSet models = new HashSet();
                layerProperties.gatherModels(models::add);
                HashSet missingParts = new HashSet();
                boolean hasMissingParts = false;
                for (ModelPart model : models) {
                    fusionModelPart.validateModelHasImportantChildren(model, missingParts::add);
                    if (missingParts.isEmpty()) continue;
                    FusionClient.LOGGER.error("A model for layer '{}' on entity '{}' is missing required parts: {}!", new Object[]{layer, BuiltInRegistries.ENTITY_TYPE.getKey(entityType), missingParts.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","))});
                    missingParts.clear();
                    hasMissingParts = true;
                }
                if (hasMissingParts) {
                    fusionModelPart.setProperties(null, null);
                }
                VanillaModelLayerProperties vanillaProperties = VanillaModelLayerProperties.get(layer, renderer);
                layerProperties = layerProperties.transformed(vanillaProperties);
                fusionModelPart.setProperties(layerProperties, vanillaProperties);
            }
            ((EntityRendererExtension)renderer).setFusionModelParts(new ArrayList<FusionModelPart>(overwrittenModelParts.values()));
            overwrittenModelParts.clear();
        }
        return renderer;
    }
}

