/*
 * Decompiled with CFR 0.152.
 */
package net.choicetheorem.ctov;

import java.util.List;
import net.choicetheorem.ctov.platform.CTOVConfigHelper;
import net.choicetheorem.ctov.utils.CTOVStructureHelper;
import net.choicetheorem.ctov.utils.TextUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public class CTOV {
    public static final String MOD_ID = "ctov";

    public static void init() {
    }

    public static void registerstructure(MinecraftServer server) {
        RegistryAccess.Frozen registryProvider = server.registryAccess();
        HolderLookup.RegistryLookup StructureSetRegistry = registryProvider.lookupOrThrow(Registries.STRUCTURE_SET);
        HolderLookup.RegistryLookup StructureRegistry = registryProvider.lookupOrThrow(Registries.STRUCTURE);
        String[] enabledpillageroutpost = new String[]{"beach", "dark_forest", "desert", "jungle", "badlands", "mountain", "plains", "savanna", "snowy", "swamp", "taiga"};
        List<String> enabledvillage = List.of("beach", "christmas", "desert", "desert_oasis", "dark_forest", "jungle", "jungle_tree", "mesa", "mesa_fortified", "mountain", "mountain_alpine", "mushroom", "plains", "plains_fortified", "savanna", "savanna_na", "snowy_igloo", "swamp", "swamp_fortified", "taiga", "taiga_fortified");
        Identifier villagesetLocation = Identifier.fromNamespaceAndPath((String)"minecraft", (String)"villages");
        Identifier outpostsetLocation = Identifier.fromNamespaceAndPath((String)"minecraft", (String)"pillager_outposts");
        if (CTOVConfigHelper.generatePillagerOutpost()) {
            for (String outpost : enabledpillageroutpost) {
                Identifier pillagerlocation = TextUtils.res("pillager_outpost_" + (String)outpost);
                new CTOVStructureHelper(server, (HolderLookup<StructureSet>)StructureSetRegistry, (HolderLookup<Structure>)StructureRegistry, outpostsetLocation, pillagerlocation, CTOVConfigHelper.OutpostWeight());
            }
        }
        if (CTOVConfigHelper.generatesmallVillage()) {
            for (String string : CTOVConfigHelper.enabledvillage()) {
                Identifier villagelocation = TextUtils.res("small/village_" + string);
                new CTOVStructureHelper(server, (HolderLookup<StructureSet>)StructureSetRegistry, (HolderLookup<Structure>)StructureRegistry, villagesetLocation, villagelocation, CTOVConfigHelper.smallVillageWeight());
            }
        }
        if (CTOVConfigHelper.generatemediumVillage()) {
            for (String string : CTOVConfigHelper.enabledvillage()) {
                Identifier villagelocation = TextUtils.res("medium/village_" + string);
                new CTOVStructureHelper(server, (HolderLookup<StructureSet>)StructureSetRegistry, (HolderLookup<Structure>)StructureRegistry, villagesetLocation, villagelocation, CTOVConfigHelper.mediumVillageWeight());
            }
        }
        if (CTOVConfigHelper.generatelargeVillage()) {
            for (String string : CTOVConfigHelper.enabledvillage()) {
                Identifier villagelocation = TextUtils.res("large/village_" + string);
                new CTOVStructureHelper(server, (HolderLookup<StructureSet>)StructureSetRegistry, (HolderLookup<Structure>)StructureRegistry, villagesetLocation, villagelocation, CTOVConfigHelper.largeVillageWeight());
            }
        }
    }
}

