/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.datagen.providers;

import com.autovw.advancednetherite.AdvancedNetherite;
import com.autovw.advancednetherite.core.ModBlocks;
import com.autovw.advancednetherite.core.ModItems;
import com.autovw.advancednetherite.core.util.ModTags;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput recipeOutput) {
        super(lookupProvider, recipeOutput);
    }

    protected void buildRecipes() {
        HolderLookup.RegistryLookup registryLookup = this.registries.lookupOrThrow(Registries.ITEM);
        this.baseBlockRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, (ItemLike)ModItems.NETHERITE_IRON_INGOT, ModBlocks.NETHERITE_IRON_BLOCK);
        this.baseBlockRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, (ItemLike)ModItems.NETHERITE_GOLD_INGOT, ModBlocks.NETHERITE_GOLD_BLOCK);
        this.baseBlockRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, (ItemLike)ModItems.NETHERITE_EMERALD_INGOT, ModBlocks.NETHERITE_EMERALD_BLOCK);
        this.baseBlockRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, (ItemLike)ModItems.NETHERITE_DIAMOND_INGOT, ModBlocks.NETHERITE_DIAMOND_BLOCK);
        this.baseIngotRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.INGOTS_UPGRADE_TO_NETHERITE_IRON, (TagKey<Item>)Tags.Items.INGOTS_IRON, ModItems.NETHERITE_IRON_INGOT);
        this.baseIngotRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.INGOTS_UPGRADE_TO_NETHERITE_GOLD, (TagKey<Item>)Tags.Items.INGOTS_GOLD, ModItems.NETHERITE_GOLD_INGOT);
        this.baseIngotRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.INGOTS_UPGRADE_TO_NETHERITE_EMERALD, (TagKey<Item>)Tags.Items.GEMS_EMERALD, ModItems.NETHERITE_EMERALD_INGOT);
        this.baseIngotRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.INGOTS_UPGRADE_TO_NETHERITE_DIAMOND, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, ModItems.NETHERITE_DIAMOND_INGOT);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.AXE_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_AXE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.AXE_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_AXE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.AXE_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_AXE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.AXE_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_AXE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.BOOTS_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, ModItems.NETHERITE_IRON_BOOTS);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.BOOTS_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, ModItems.NETHERITE_GOLD_BOOTS);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.BOOTS_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, ModItems.NETHERITE_EMERALD_BOOTS);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.BOOTS_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, ModItems.NETHERITE_DIAMOND_BOOTS);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.CHESTPLATE_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, ModItems.NETHERITE_IRON_CHESTPLATE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.CHESTPLATE_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, ModItems.NETHERITE_GOLD_CHESTPLATE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.CHESTPLATE_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, ModItems.NETHERITE_EMERALD_CHESTPLATE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.CHESTPLATE_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, ModItems.NETHERITE_DIAMOND_CHESTPLATE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.HELMET_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, ModItems.NETHERITE_IRON_HELMET);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.HELMET_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, ModItems.NETHERITE_GOLD_HELMET);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.HELMET_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, ModItems.NETHERITE_EMERALD_HELMET);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.HELMET_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, ModItems.NETHERITE_DIAMOND_HELMET);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.HOE_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_HOE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.HOE_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_HOE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.HOE_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_HOE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.HOE_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_HOE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.LEGGINGS_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, ModItems.NETHERITE_IRON_LEGGINGS);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.LEGGINGS_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, ModItems.NETHERITE_GOLD_LEGGINGS);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.LEGGINGS_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, ModItems.NETHERITE_EMERALD_LEGGINGS);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.LEGGINGS_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, ModItems.NETHERITE_DIAMOND_LEGGINGS);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.PICKAXE_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, ModItems.NETHERITE_IRON_PICKAXE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.PICKAXE_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, ModItems.NETHERITE_GOLD_PICKAXE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.PICKAXE_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, ModItems.NETHERITE_EMERALD_PICKAXE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.PICKAXE_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, ModItems.NETHERITE_DIAMOND_PICKAXE);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.SHOVEL_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, (Item)ModItems.NETHERITE_IRON_SHOVEL);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.SHOVEL_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, (Item)ModItems.NETHERITE_GOLD_SHOVEL);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.SHOVEL_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, (Item)ModItems.NETHERITE_EMERALD_SHOVEL);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.SHOVEL_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, (Item)ModItems.NETHERITE_DIAMOND_SHOVEL);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.SWORD_UPGRADE_TO_NETHERITE_IRON, ModTags.UPGRADE_TO_NETHERITE_IRON, ModItems.NETHERITE_IRON_SWORD);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.SWORD_UPGRADE_TO_NETHERITE_GOLD, ModTags.UPGRADE_TO_NETHERITE_GOLD, ModItems.NETHERITE_GOLD_SWORD);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.SWORD_UPGRADE_TO_NETHERITE_EMERALD, ModTags.UPGRADE_TO_NETHERITE_EMERALD, ModItems.NETHERITE_EMERALD_SWORD);
        this.baseSmithingRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output, ModTags.SWORD_UPGRADE_TO_NETHERITE_DIAMOND, ModTags.UPGRADE_TO_NETHERITE_DIAMOND, ModItems.NETHERITE_DIAMOND_SWORD);
        this.lodestoneRecipe((HolderLookup.RegistryLookup<Item>)registryLookup, this.output);
    }

    public void baseSmithingRecipe(HolderLookup.RegistryLookup<Item> registryLookup, RecipeOutput output, TagKey<Item> ingredient, TagKey<Item> upgradeIngredient, Item result) {
        Identifier resultId = AdvancedNetherite.getRegistryHelper().getItemById(result);
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike)Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE), (Ingredient)this.tag(ingredient), (Ingredient)this.tag(upgradeIngredient), (RecipeCategory)RecipeCategory.MISC, (Item)result).unlocks("has_ingredients", this.has(upgradeIngredient)).save(output, Identifier.fromNamespaceAndPath((String)resultId.getNamespace(), (String)(resultId.getPath() + "_smithing")).toString());
    }

    public void baseIngotRecipe(HolderLookup.RegistryLookup<Item> registryLookup, RecipeOutput output, TagKey<Item> ingotIngredient, TagKey<Item> upgradeIngredient, Item result) {
        ShapelessRecipeBuilder.shapeless(registryLookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)result).requires(ingotIngredient).requires(upgradeIngredient).requires(upgradeIngredient).requires(upgradeIngredient).requires(upgradeIngredient).unlockedBy("has_" + upgradeIngredient.toString(), this.has(upgradeIngredient)).save(output);
    }

    public void baseBlockRecipe(HolderLookup.RegistryLookup<Item> registryLookup, RecipeOutput output, ItemLike ingredient, Block result) {
        ShapedRecipeBuilder.shaped(registryLookup, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).define(Character.valueOf('#'), ingredient).pattern("###").pattern("###").pattern("###").unlockedBy("has_" + ingredient.toString(), this.has(ingredient)).save(output);
        ShapelessRecipeBuilder.shapeless(registryLookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)ingredient, (int)9).requires((ItemLike)result).unlockedBy("has_" + result.toString(), this.has((ItemLike)result)).save(output, Identifier.parse((String)(ingredient.toString() + "_from_block")).toString());
    }

    private void lodestoneRecipe(HolderLookup.RegistryLookup<Item> registryLookup, RecipeOutput output) {
        Identifier lodestoneId = AdvancedNetherite.getRegistryHelper().getItemById(Items.LODESTONE);
        ShapedRecipeBuilder.shaped(registryLookup, (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LODESTONE).define(Character.valueOf('S'), (ItemLike)Items.CHISELED_STONE_BRICKS).define(Character.valueOf('#'), ModTags.NETHERITE_INGOTS).pattern("SSS").pattern("S#S").pattern("SSS").unlockedBy("has_chiseled_stone_bricks", this.has((ItemLike)Items.CHISELED_STONE_BRICKS)).unlockedBy("has_netherite_ingots", this.has(ModTags.NETHERITE_INGOTS)).save(output, Identifier.fromNamespaceAndPath((String)"advancednetherite", (String)lodestoneId.getPath()).toString());
    }

    public static final class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider lookupProvider, RecipeOutput output) {
            return new ModRecipeProvider(lookupProvider, output);
        }

        public String getName() {
            return "Advanced Netherite recipes";
        }
    }
}

