/*
 * Decompiled with CFR 0.152.
 */
package com.autovw.advancednetherite.datagen;

import com.autovw.advancednetherite.api.annotation.Internal;
import com.autovw.advancednetherite.datagen.providers.ModAdvancementProvider;
import com.autovw.advancednetherite.datagen.providers.ModBlockTagsProvider;
import com.autovw.advancednetherite.datagen.providers.ModEnchantmentTagsProvider;
import com.autovw.advancednetherite.datagen.providers.ModEquipmentAssetProvider;
import com.autovw.advancednetherite.datagen.providers.ModItemTagsProvider;
import com.autovw.advancednetherite.datagen.providers.ModLootModifierProvider;
import com.autovw.advancednetherite.datagen.providers.ModLootTableProvider;
import com.autovw.advancednetherite.datagen.providers.ModModelProvider;
import com.autovw.advancednetherite.datagen.providers.ModRecipeProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="advancednetherite", value={Dist.CLIENT})
@Internal
public class ModDataGenerator {
    private ModDataGenerator() {
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent.Client event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        event.addProvider((DataProvider)new ModBlockTagsProvider(packOutput, lookupProvider, "advancednetherite"));
        event.addProvider((DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, "advancednetherite"));
        event.addProvider((DataProvider)new ModEnchantmentTagsProvider(packOutput, lookupProvider, "advancednetherite"));
        event.addProvider((DataProvider)new ModRecipeProvider.Runner(packOutput, lookupProvider));
        event.addProvider((DataProvider)new ModLootTableProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new ModAdvancementProvider(packOutput, lookupProvider));
        event.addProvider((DataProvider)new ModLootModifierProvider(packOutput, lookupProvider, "advancednetherite"));
        event.addProvider((DataProvider)new ModEquipmentAssetProvider(packOutput));
        event.addProvider((DataProvider)new ModModelProvider(packOutput, "advancednetherite"));
    }
}

