/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.maxhenkel.corpse.net.MessageRequestDeathHistory;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.Permissions;

public class HistoryCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)Commands.literal((String)"deathhistory").requires(source -> source.permissions().hasPermission(Permissions.COMMANDS_MODERATOR));
        ((LiteralArgumentBuilder)literalBuilder.then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(commandSource -> {
            ServerPlayer player = EntityArgument.getPlayer((CommandContext)commandSource, (String)"player");
            boolean success = MessageRequestDeathHistory.sendDeathHistory(((CommandSourceStack)commandSource.getSource()).getPlayerOrException(), player.getUUID());
            return success ? 1 : 0;
        }))).then(Commands.argument((String)"player_uuid", (ArgumentType)UuidArgument.uuid()).executes(commandSource -> {
            UUID player = UuidArgument.getUuid((CommandContext)commandSource, (String)"player_uuid");
            boolean success = MessageRequestDeathHistory.sendDeathHistory(((CommandSourceStack)commandSource.getSource()).getPlayerOrException(), player);
            return success ? 1 : 0;
        }));
        dispatcher.register(literalBuilder);
    }
}

