/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.VerticalFacing;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.BlockSide;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeItem;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.TargetContentsFilterLogic;
import org.jspecify.annotations.Nullable;

public class HopperUpgradeWrapper
extends UpgradeWrapperBase<HopperUpgradeWrapper, HopperUpgradeItem>
implements ITickableUpgrade,
INeighborChangeListenerUpgrade {
    private final Set<Direction> pullDirections = new LinkedHashSet<Direction>();
    private final Set<Direction> pushDirections = new LinkedHashSet<Direction>();
    private final Map<Direction, ItemHandlerHolder> handlerCache = new EnumMap<Direction, ItemHandlerHolder>(Direction.class);
    private final ContentsFilterLogic inputFilterLogic;
    private final TargetContentsFilterLogic outputFilterLogic;
    private long coolDownTime = 0L;

    protected HopperUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.inputFilterLogic = new ContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getInputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), ModCoreDataComponents.INPUT_FILTER_ATTRIBUTES);
        this.outputFilterLogic = new TargetContentsFilterLogic(upgrade, upgradeSaveHandler, ((HopperUpgradeItem)this.upgradeItem).getOutputFilterSlotCount(), () -> ((IStorageWrapper)storageWrapper).getInventoryHandler(), (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), ModDataComponents.OUTPUT_FILTER_ATTRIBUTES);
        this.deserialize();
    }

    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        this.initDirections(level, pos);
        if (this.coolDownTime > level.getGameTime()) {
            return;
        }
        for (Direction pushDirection : this.pushDirections) {
            if (this.runOnItemHandlers(level, pos, pushDirection, this::pushItems, entity)) break;
        }
        for (Direction pullDirection : this.pullDirections) {
            if (this.runOnItemHandlers(level, pos, pullDirection, this::pullItems, entity)) break;
        }
        this.coolDownTime = level.getGameTime() + ((HopperUpgradeItem)this.upgradeItem).getTransferSpeedTicks();
    }

    private void initDirections(Level level, BlockPos pos) {
        if (this.upgrade.has(ModDataComponents.PUSH_DIRECTIONS) || this.upgrade.has(ModDataComponents.PULL_DIRECTIONS)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            Direction horizontalDirection = storageBlock.getHorizontalDirection(state);
            VerticalFacing verticalFacing = storageBlock.getVerticalFacing(state);
            this.pullDirections.clear();
            this.pushDirections.clear();
            this.initDirections(BlockSide.BOTTOM.toDirection(horizontalDirection, verticalFacing), BlockSide.TOP.toDirection(horizontalDirection, verticalFacing));
        } else {
            this.initDirections(Direction.DOWN, Direction.UP);
        }
    }

    private boolean pullItems(List<ResourceHandler<ItemResource>> fromHandlers) {
        for (ResourceHandler<ItemResource> fromHandler : fromHandlers) {
            if (!this.moveItems(fromHandler, (ResourceHandler<ItemResource>)this.storageWrapper.getInventoryForUpgradeProcessing(), (FilterLogic)this.inputFilterLogic)) continue;
            return true;
        }
        return false;
    }

    private boolean pushItems(List<ResourceHandler<ItemResource>> toHandlers) {
        for (ResourceHandler<ItemResource> toHandler : toHandlers) {
            this.outputFilterLogic.setInventory(toHandler);
            if (!this.moveItems((ResourceHandler<ItemResource>)this.storageWrapper.getInventoryForUpgradeProcessing(), toHandler, (FilterLogic)this.outputFilterLogic)) continue;
            return true;
        }
        return false;
    }

    private boolean moveItems(ResourceHandler<ItemResource> fromHandler, ResourceHandler<ItemResource> toHandler, FilterLogic filterLogic) {
        for (int slot = 0; slot < fromHandler.size(); ++slot) {
            ItemResource slotResource = (ItemResource)fromHandler.getResource(slot);
            if (slotResource.isEmpty() || !filterLogic.matchesFilter(slotResource) || slotResource.isEmpty()) continue;
            try (Transaction tx = Transaction.openRoot();){
                int extracted;
                int inserted = toHandler.insert((Resource)slotResource, fromHandler.getAmountAsInt(slot), (TransactionContext)tx);
                if (inserted <= 0 || (extracted = fromHandler.extract(slot, (Resource)slotResource, inserted, (TransactionContext)tx)) <= 0) continue;
                tx.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void onNeighborChange(Level level, BlockPos pos, Direction direction) {
        if (!level.isClientSide() && (this.pushDirections.contains(direction) || this.pullDirections.contains(direction)) && this.needsCacheUpdate(level, pos, direction)) {
            this.handlerCache.remove(direction);
        }
    }

    private boolean needsCacheUpdate(Level level, BlockPos pos, Direction direction) {
        ItemHandlerHolder holder = this.handlerCache.get(direction);
        if (holder == null || holder.handlers().isEmpty()) {
            return !level.getBlockState(pos).isAir();
        }
        if (holder.refreshOnEveryNeighborChange()) {
            return true;
        }
        for (BlockCapabilityCache<ResourceHandler<ItemResource>, Direction> handler : holder.handlers()) {
            if (handler.getCapability() != null) continue;
            return true;
        }
        return false;
    }

    public void updateCacheOnSide(Level level, BlockPos pos, Direction direction) {
        if (!(level.isLoaded(pos) && level.isLoaded(pos.relative(direction)) && level instanceof ServerLevel)) {
            this.handlerCache.remove(direction);
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemHandlerHolder itemHandlers = this.getItemHandlerHolder(level, pos, direction, serverLevel);
        this.handlerCache.put(direction, itemHandlers);
    }

    private ItemHandlerHolder getItemHandlerHolder(Level level, BlockPos pos, Direction direction, ServerLevel serverLevel) {
        List<BlockPos> list;
        WeakReference<IStorageWrapper> storageWrapperRef = new WeakReference<IStorageWrapper>(this.storageWrapper);
        BooleanSupplier validityCheck = () -> {
            IStorageWrapper sw = (IStorageWrapper)storageWrapperRef.get();
            if (sw != null) {
                return sw.getUpgradeHandler().getSlotWrappers().containsValue(this);
            }
            return false;
        };
        BlockState storageState = level.getBlockState(pos);
        Block block = storageState.getBlock();
        if (block instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            list = storageBlock.getNeighborPos(storageState, pos, direction);
        } else {
            list = List.of(pos.relative(direction));
        }
        List<BlockPos> offsetPositions = list;
        ArrayList<BlockCapabilityCache<ResourceHandler<ItemResource>, Direction>> caches = new ArrayList<BlockCapabilityCache<ResourceHandler<ItemResource>, Direction>>();
        AtomicBoolean refreshOnEveryNeighborChange = new AtomicBoolean(false);
        offsetPositions.forEach(offsetPos -> {
            offsetPos = level.getBlockEntity(offsetPos, ModBlocks.STORAGE_INPUT_BLOCK_ENTITY_TYPE.get()).flatMap(storageInputBlockEntity -> {
                refreshOnEveryNeighborChange.set(true);
                return storageInputBlockEntity.getControllerPos();
            }).orElse(offsetPos);
            caches.add(BlockCapabilityCache.create((BlockCapability)Capabilities.Item.BLOCK, (ServerLevel)serverLevel, (BlockPos)offsetPos, (Object)direction.getOpposite(), (BooleanSupplier)validityCheck, () -> this.handlerCache.remove(direction)));
        });
        return new ItemHandlerHolder(caches, refreshOnEveryNeighborChange.get());
    }

    private boolean runOnItemHandlers(Level level, BlockPos pos, Direction direction, Predicate<List<ResourceHandler<ItemResource>>> run, @Nullable Entity entity) {
        ItemHandlerHolder holder = this.getItemHandlerHolder(level, pos, direction, entity == null);
        if (holder == null) {
            return this.runOnAutomationEntityItemHandlers(level, pos, direction, run, entity);
        }
        List<ResourceHandler> handler = holder.handlers().stream().map(BlockCapabilityCache::getCapability).filter(Objects::nonNull).toList();
        return handler.isEmpty() ? this.runOnAutomationEntityItemHandlers(level, pos, direction, run, entity) : run.test(handler);
    }

    private boolean runOnAutomationEntityItemHandlers(Level level, BlockPos pos, Direction direction, Predicate<List<ResourceHandler<ItemResource>>> run, @Nullable Entity entity) {
        List<BlockPos> list;
        Object object;
        BlockState storageState = level.getBlockState(pos);
        if (entity == null && (object = storageState.getBlock()) instanceof StorageBlockBase) {
            StorageBlockBase storageBlock = (StorageBlockBase)object;
            list = storageBlock.getNeighborPos(storageState, pos, direction);
        } else {
            list = List.of(pos.relative(direction));
        }
        List<BlockPos> offsetPositions = list;
        ArrayList entities = new ArrayList();
        for (BlockPos offsetPosition : offsetPositions) {
            entities.addAll(level.getEntities((Entity)null, new AABB(offsetPosition), e -> e != entity && EntitySelector.ENTITY_STILL_ALIVE.test(e)));
        }
        if (!entities.isEmpty()) {
            Collections.shuffle(entities);
            for (Entity e2 : entities) {
                ResourceHandler entityCap = (ResourceHandler)e2.getCapability(Capabilities.Item.ENTITY_AUTOMATION, (Object)direction.getOpposite());
                if (entityCap == null) continue;
                return run.test(List.of(entityCap));
            }
        }
        return false;
    }

    private @Nullable ItemHandlerHolder getItemHandlerHolder(Level level, BlockPos pos, Direction direction, boolean useCache) {
        if (useCache) {
            if (!this.handlerCache.containsKey(direction)) {
                this.updateCacheOnSide(level, pos, direction);
            }
            return this.handlerCache.get(direction);
        }
        return this.getItemHandlerHolder(level, pos, direction, (ServerLevel)level);
    }

    public ContentsFilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public ContentsFilterLogic getOutputFilterLogic() {
        return this.outputFilterLogic;
    }

    public boolean isPullingFrom(Direction direction) {
        return this.pullDirections.contains(direction);
    }

    public boolean isPushingTo(Direction direction) {
        return this.pushDirections.contains(direction);
    }

    public void setPullingFrom(Direction direction, boolean shouldPull) {
        if (shouldPull) {
            this.pullDirections.add(direction);
        } else {
            this.pullDirections.remove(direction);
        }
        this.serializePullDirections();
    }

    public void setPushingTo(Direction direction, boolean isPushing) {
        if (isPushing) {
            this.pushDirections.add(direction);
        } else {
            this.pushDirections.remove(direction);
        }
        this.serializePushDirections();
    }

    private void serializePullDirections() {
        this.upgrade.set(ModDataComponents.PULL_DIRECTIONS, Set.copyOf(this.pullDirections));
        this.save();
    }

    private void serializePushDirections() {
        this.upgrade.set(ModDataComponents.PUSH_DIRECTIONS, Set.copyOf(this.pushDirections));
        this.save();
    }

    public void deserialize() {
        this.pullDirections.clear();
        this.pushDirections.clear();
        Set directions = (Set)this.upgrade.get(ModDataComponents.PULL_DIRECTIONS);
        if (directions != null) {
            this.pullDirections.addAll(directions);
        }
        if ((directions = (Set)this.upgrade.get(ModDataComponents.PUSH_DIRECTIONS)) != null) {
            this.pushDirections.addAll(directions);
        }
    }

    public void initDirections(Direction pushDirection, Direction pullDirection) {
        this.setPushingTo(pushDirection, true);
        this.setPullingFrom(pullDirection, true);
    }

    private record ItemHandlerHolder(List<BlockCapabilityCache<ResourceHandler<ItemResource>, Direction>> handlers, boolean refreshOnEveryNeighborChange) {
    }
}

