/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.data;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import net.neoforged.neoforge.common.conditions.RegisteredCondition;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.crafting.ShapeBasedRecipeBuilder;
import net.p3pp3rf1y.sophisticatedcore.crafting.ShapelessBasedRecipeBuilder;
import net.p3pp3rf1y.sophisticatedcore.crafting.UpgradeNextTierRecipe;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.crafting.BarrelMaterialRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.BaseTierWoodenStorageIngredient;
import net.p3pp3rf1y.sophisticatedstorage.crafting.DoubleChestTierUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.DoubleChestTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.DropPackedDisabledCondition;
import net.p3pp3rf1y.sophisticatedstorage.crafting.FlatTopBarrelToggleRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.GenericWoodStorageRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromChestRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.ShulkerBoxFromVanillaShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.StorageDyeRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeRecipe;
import net.p3pp3rf1y.sophisticatedstorage.crafting.StorageTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class StorageRecipeProvider
extends RecipeProvider {
    private static final String HAS_UPGRADE_BASE_CRITERION_NAME = "has_upgrade_base";
    private static final String HAS_REDSTONE_TORCH_CRITERION_NAME = "has_redstone_torch";
    private static final String HAS_SMELTING_UPGRADE_CRITERION_NAME = "has_smelting_upgrade";
    public static final String HAS_BASE_TIER_WOODEN_STORAGE_CRITERION_NAME = "has_base_tier_wooden_storage";
    private static final String PLANK_SUFFIX = "_plank";
    private final HolderGetter<Item> items;

    public StorageRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
        super(provider, recipeOutput);
        this.items = provider.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        SpecialRecipeBuilder.special(StorageDyeRecipe::new).save(this.output, SophisticatedStorage.getRegistryName("storage_dye"));
        SpecialRecipeBuilder.special(FlatTopBarrelToggleRecipe::new).save(this.output, SophisticatedStorage.getRegistryName("flat_top_barrel_toggle"));
        SpecialRecipeBuilder.special(BarrelMaterialRecipe::new).save(this.output, SophisticatedStorage.getRegistryName("barrel_material"));
        this.addBarrelRecipes(this.output);
        this.addLimitedBarrelRecipes(this.output);
        this.addChestRecipes(this.output);
        this.addShulkerBoxRecipes(this.output);
        this.addControllerRelatedRecipes(this.output);
        this.addUpgradeRecipes(this.output);
        this.addTierUpgradeItemRecipes(this.output);
        this.addBackpackUpgradeConversionRecipes(this.output);
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PACKING_TAPE.get())).requires(Tags.Items.SLIME_BALLS).requires((ItemLike)Items.PAPER).unlockedBy("has_slime", this.has(Tags.Items.SLIME_BALLS)).save(this.output.withConditions(new ICondition[]{new DropPackedDisabledCondition()}));
        ShapelessRecipeBuilder.shapeless(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SUPER_PACKING_TAPE.get())).requires((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PACKING_TAPE.get()).requires((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PACKING_TAPE.get()).requires((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PACKING_TAPE.get()).requires((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PACKING_TAPE.get()).unlockedBy("has_packing_tape", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PACKING_TAPE.get())).save(this.output.withConditions(new ICondition[]{new DropPackedDisabledCondition()}));
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.DECORATION_TABLE_ITEM.get())).pattern("LLL").pattern("PBP").pattern("P P").define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(this.output);
        ShapedRecipeBuilder.shaped(this.items, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PAINTBRUSH.get())).pattern(" W ").pattern(" SW").pattern("S  ").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('W'), ItemTags.WOOL).unlockedBy(HAS_BASE_TIER_WOODEN_STORAGE_CRITERION_NAME, this.has(ModBlocks.BASE_TIER_WOODEN_STORAGE_TAG)).save(this.output);
    }

    private void addBackpackUpgradeConversionRecipes(RecipeOutput recipeOutput) {
        RecipeOutput sbConditionalRecipeOutput = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("sophisticatedbackpacks")});
        this.addStorageStackUpgradeFromBackpackStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_1_PLUS.get(), (StackUpgradeItem)ModItems.STACK_UPGRADE_STARTER_TIER.get());
        this.addStorageStackUpgradeFromBackpackStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_2.get(), (StackUpgradeItem)ModItems.STACK_UPGRADE_TIER_1.get());
        this.addStorageStackUpgradeFromBackpackStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_3.get(), (StackUpgradeItem)ModItems.STACK_UPGRADE_TIER_2.get());
        this.addStorageStackUpgradeFromBackpackStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_4.get(), (StackUpgradeItem)ModItems.STACK_UPGRADE_TIER_3.get());
        this.addStorageStackUpgradeFromBackpackStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_5.get(), (StackUpgradeItem)ModItems.STACK_UPGRADE_TIER_4.get());
        this.addStorageStackUpgradeFromBackpackStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_OMEGA_TIER.get(), (StackUpgradeItem)ModItems.STACK_UPGRADE_OMEGA_TIER.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_DOWNGRADE_TIER_1.get(), (UpgradeItemBase)ModItems.STACK_DOWNGRADE_TIER_1.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_DOWNGRADE_TIER_2.get(), (UpgradeItemBase)ModItems.STACK_DOWNGRADE_TIER_2.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_DOWNGRADE_TIER_3.get(), (UpgradeItemBase)ModItems.STACK_DOWNGRADE_TIER_3.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PICKUP_UPGRADE.get(), (UpgradeItemBase)ModItems.PICKUP_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_PICKUP_UPGRADE.get(), (UpgradeItemBase)ModItems.ADVANCED_PICKUP_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.MAGNET_UPGRADE.get(), (UpgradeItemBase)ModItems.MAGNET_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_MAGNET_UPGRADE.get(), (UpgradeItemBase)ModItems.ADVANCED_MAGNET_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.FILTER_UPGRADE.get(), (UpgradeItemBase)ModItems.FILTER_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_FILTER_UPGRADE.get(), (UpgradeItemBase)ModItems.ADVANCED_FILTER_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.CRAFTING_UPGRADE.get(), (UpgradeItemBase)ModItems.CRAFTING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.FEEDING_UPGRADE.get(), (UpgradeItemBase)ModItems.FEEDING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_FEEDING_UPGRADE.get(), (UpgradeItemBase)ModItems.ADVANCED_FEEDING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COMPACTING_UPGRADE.get(), (UpgradeItemBase)ModItems.COMPACTING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_COMPACTING_UPGRADE.get(), (UpgradeItemBase)ModItems.ADVANCED_COMPACTING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.VOID_UPGRADE.get(), (UpgradeItemBase)ModItems.VOID_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_VOID_UPGRADE.get(), (UpgradeItemBase)ModItems.ADVANCED_VOID_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMELTING_UPGRADE.get(), (UpgradeItemBase)ModItems.SMELTING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMELTING_UPGRADE.get(), (UpgradeItemBase)ModItems.AUTO_SMELTING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMOKING_UPGRADE.get(), (UpgradeItemBase)ModItems.SMOKING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMOKING_UPGRADE.get(), (UpgradeItemBase)ModItems.AUTO_SMOKING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BLASTING_UPGRADE.get(), (UpgradeItemBase)ModItems.BLASTING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_BLASTING_UPGRADE.get(), (UpgradeItemBase)ModItems.AUTO_BLASTING_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STONECUTTER_UPGRADE.get(), (UpgradeItemBase)ModItems.STONECUTTER_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.JUKEBOX_UPGRADE.get(), (UpgradeItemBase)ModItems.JUKEBOX_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_JUKEBOX_UPGRADE.get(), (UpgradeItemBase)ModItems.ADVANCED_JUKEBOX_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_ALCHEMY_UPGRADE.get(), (UpgradeItemBase)ModItems.ADVANCED_ALCHEMY_UPGRADE.get());
        this.addStorageUpgradeFromBackpackUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ALCHEMY_UPGRADE.get(), (UpgradeItemBase)ModItems.ALCHEMY_UPGRADE.get());
        this.addBackpackStackUpgradeFromStorageStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)ModItems.STACK_UPGRADE_STARTER_TIER.get(), (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_1_PLUS.get());
        this.addBackpackStackUpgradeFromStorageStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)ModItems.STACK_UPGRADE_TIER_1.get(), (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_2.get());
        this.addBackpackStackUpgradeFromStorageStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)ModItems.STACK_UPGRADE_TIER_2.get(), (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_3.get());
        this.addBackpackStackUpgradeFromStorageStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)ModItems.STACK_UPGRADE_TIER_3.get(), (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_4.get());
        this.addBackpackStackUpgradeFromStorageStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)ModItems.STACK_UPGRADE_TIER_4.get(), (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_5.get());
        this.addBackpackStackUpgradeFromStorageStackUpgradeRecipe(sbConditionalRecipeOutput, (StackUpgradeItem)ModItems.STACK_UPGRADE_OMEGA_TIER.get(), (StackUpgradeItem)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_OMEGA_TIER.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.STACK_DOWNGRADE_TIER_1.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_DOWNGRADE_TIER_1.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.STACK_DOWNGRADE_TIER_2.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_DOWNGRADE_TIER_2.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.STACK_DOWNGRADE_TIER_3.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_DOWNGRADE_TIER_3.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.PICKUP_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PICKUP_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.ADVANCED_PICKUP_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_PICKUP_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.MAGNET_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.MAGNET_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.ADVANCED_MAGNET_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_MAGNET_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.FILTER_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.FILTER_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.ADVANCED_FILTER_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_FILTER_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.CRAFTING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.CRAFTING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.FEEDING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.FEEDING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.ADVANCED_FEEDING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_FEEDING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.COMPACTING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COMPACTING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.ADVANCED_COMPACTING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_COMPACTING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.VOID_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.VOID_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.ADVANCED_VOID_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_VOID_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.SMELTING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMELTING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.AUTO_SMELTING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMELTING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.SMOKING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMOKING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.AUTO_SMOKING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMOKING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.BLASTING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BLASTING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.AUTO_BLASTING_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_BLASTING_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.STONECUTTER_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STONECUTTER_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.JUKEBOX_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.JUKEBOX_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.ADVANCED_JUKEBOX_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_JUKEBOX_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.ADVANCED_ALCHEMY_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_ALCHEMY_UPGRADE.get());
        this.addBackpackUpgradeFromStorageUpgradeRecipe(sbConditionalRecipeOutput, (UpgradeItemBase)ModItems.ALCHEMY_UPGRADE.get(), (UpgradeItemBase)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ALCHEMY_UPGRADE.get());
    }

    private void addBackpackStackUpgradeFromStorageStackUpgradeRecipe(RecipeOutput recipeOutput, StackUpgradeItem backpackStackUpgrade, StackUpgradeItem storageStackUpgrade) {
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)backpackStackUpgrade).pattern("TST").pattern("SLS").pattern("T T").define(Character.valueOf('T'), Tags.Items.STRINGS).define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('S'), (ItemLike)storageStackUpgrade).unlockedBy("has_storage_stack_upgrade", this.has((ItemLike)storageStackUpgrade)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("backpack_" + RegistryHelper.getItemKey((Item)backpackStackUpgrade).getPath() + "_from_storage_" + RegistryHelper.getItemKey((Item)storageStackUpgrade).getPath())));
    }

    private void addBackpackUpgradeFromStorageUpgradeRecipe(RecipeOutput recipeOutput, UpgradeItemBase<?> backpackUpgrade, UpgradeItemBase<?> storageUpgrade) {
        ShapeBasedRecipeBuilder.shaped(this.items, backpackUpgrade).pattern("TUT").pattern(" L ").pattern("T T").define(Character.valueOf('T'), Tags.Items.STRINGS).define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('U'), storageUpgrade).unlockedBy("has_storage_upgrade", this.has((ItemLike)storageUpgrade)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("backpack_" + RegistryHelper.getItemKey(backpackUpgrade).getPath() + "_from_storage_" + RegistryHelper.getItemKey(storageUpgrade).getPath())));
    }

    private void addStorageUpgradeFromBackpackUpgradeRecipe(RecipeOutput recipeOutput, UpgradeItemBase<?> storageUpgrade, UpgradeItemBase<?> backpackUpgrade) {
        ShapeBasedRecipeBuilder.shaped(this.items, storageUpgrade).pattern("PUP").pattern(" P ").pattern("P P").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('U'), backpackUpgrade).unlockedBy("has_backpack_upgrade", this.has((ItemLike)backpackUpgrade)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("storage_" + RegistryHelper.getItemKey(storageUpgrade).getPath() + "_from_backpack_" + RegistryHelper.getItemKey(backpackUpgrade).getPath())));
    }

    private void addStorageStackUpgradeFromBackpackStackUpgradeRecipe(RecipeOutput recipeOutput, StackUpgradeItem storageStackUpgrade, StackUpgradeItem backpackStackUpgrade) {
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)new ItemStack((ItemLike)storageStackUpgrade, 3)).pattern("PSP").pattern(" P ").pattern("P P").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('S'), (ItemLike)backpackStackUpgrade).unlockedBy("has_backpack_stack_upgrade", this.has((ItemLike)backpackStackUpgrade)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("storage_" + RegistryHelper.getItemKey((Item)storageStackUpgrade).getPath() + "_from_backpack_" + RegistryHelper.getItemKey((Item)backpackStackUpgrade).getPath())));
    }

    private void addLimitedBarrelRecipes(RecipeOutput recipeOutput) {
        WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.forEach((woodType, blockFamily) -> {
            this.limitedWoodBarrel1Recipe(recipeOutput, (WoodType)woodType, blockFamily.getBaseBlock(), blockFamily.get(BlockFamily.Variant.SLAB));
            this.limitedWoodBarrel2Recipe(recipeOutput, (WoodType)woodType, blockFamily.getBaseBlock(), blockFamily.get(BlockFamily.Variant.SLAB));
            this.limitedWoodBarrel3Recipe(recipeOutput, (WoodType)woodType, blockFamily.getBaseBlock(), blockFamily.get(BlockFamily.Variant.SLAB));
            this.limitedWoodBarrel4Recipe(recipeOutput, (WoodType)woodType, blockFamily.getBaseBlock(), blockFamily.get(BlockFamily.Variant.SLAB));
        });
        this.addStorageTierUpgradeRecipes(recipeOutput, ModBlocks.LIMITED_BARREL_1_ITEM.get(), ModBlocks.LIMITED_COPPER_BARREL_1_ITEM.get(), ModBlocks.LIMITED_IRON_BARREL_1_ITEM.get(), ModBlocks.LIMITED_GOLD_BARREL_1_ITEM.get(), ModBlocks.LIMITED_DIAMOND_BARREL_1_ITEM.get(), ModBlocks.LIMITED_NETHERITE_BARREL_1_ITEM.get());
        this.addStorageTierUpgradeRecipes(recipeOutput, ModBlocks.LIMITED_BARREL_2_ITEM.get(), ModBlocks.LIMITED_COPPER_BARREL_2_ITEM.get(), ModBlocks.LIMITED_IRON_BARREL_2_ITEM.get(), ModBlocks.LIMITED_GOLD_BARREL_2_ITEM.get(), ModBlocks.LIMITED_DIAMOND_BARREL_2_ITEM.get(), ModBlocks.LIMITED_NETHERITE_BARREL_2_ITEM.get());
        this.addStorageTierUpgradeRecipes(recipeOutput, ModBlocks.LIMITED_BARREL_3_ITEM.get(), ModBlocks.LIMITED_COPPER_BARREL_3_ITEM.get(), ModBlocks.LIMITED_IRON_BARREL_3_ITEM.get(), ModBlocks.LIMITED_GOLD_BARREL_3_ITEM.get(), ModBlocks.LIMITED_DIAMOND_BARREL_3_ITEM.get(), ModBlocks.LIMITED_NETHERITE_BARREL_3_ITEM.get());
        this.addStorageTierUpgradeRecipes(recipeOutput, ModBlocks.LIMITED_BARREL_4_ITEM.get(), ModBlocks.LIMITED_COPPER_BARREL_4_ITEM.get(), ModBlocks.LIMITED_IRON_BARREL_4_ITEM.get(), ModBlocks.LIMITED_GOLD_BARREL_4_ITEM.get(), ModBlocks.LIMITED_DIAMOND_BARREL_4_ITEM.get(), ModBlocks.LIMITED_NETHERITE_BARREL_4_ITEM.get());
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.LIMITED_BARREL_1_ITEM.get()), WoodType.SPRUCE), GenericWoodStorageRecipe::new).pattern("PSP").pattern("PRP").pattern("PPP").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has _plank", this.has(ItemTags.PLANKS)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("generic_limited_barrel_1")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.LIMITED_BARREL_2_ITEM.get()), WoodType.SPRUCE), GenericWoodStorageRecipe::new).pattern("PPP").pattern("SRS").pattern("PPP").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has _plank", this.has(ItemTags.PLANKS)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("generic_limited_barrel_2")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.LIMITED_BARREL_3_ITEM.get()), WoodType.SPRUCE), GenericWoodStorageRecipe::new).pattern("PSP").pattern("PRP").pattern("SPS").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has _plank", this.has(ItemTags.PLANKS)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("generic_limited_barrel_3")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.LIMITED_BARREL_4_ITEM.get()), WoodType.SPRUCE), GenericWoodStorageRecipe::new).pattern("SPS").pattern("PRP").pattern("SPS").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has _plank", this.has(ItemTags.PLANKS)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("generic_limited_barrel_4")));
    }

    private void addStorageTierUpgradeRecipes(RecipeOutput recipeOutput, BlockItem baseTierItem, BlockItem copperTierItem, BlockItem ironTierItem, BlockItem goldTierItem, BlockItem diamondTierItem, BlockItem netheriteTierItem) {
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)copperTierItem, StorageTierUpgradeRecipe::new).pattern("CCC").pattern("CSC").pattern("CCC").define(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('S'), (ItemLike)baseTierItem).unlockedBy("has_" + RegistryHelper.getItemKey((Item)baseTierItem).getPath(), this.has((ItemLike)baseTierItem)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)ironTierItem, StorageTierUpgradeRecipe::new).pattern(" I ").pattern("ISI").pattern(" I ").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)copperTierItem).unlockedBy("has_" + RegistryHelper.getItemKey((Item)copperTierItem).getPath(), this.has((ItemLike)copperTierItem)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier(RegistryHelper.getItemKey((Item)ironTierItem).getPath() + "_from_" + RegistryHelper.getItemKey((Item)copperTierItem).getPath())));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)ironTierItem, StorageTierUpgradeRecipe::new).pattern("III").pattern("ISI").pattern("III").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)baseTierItem).unlockedBy("has_" + RegistryHelper.getItemKey((Item)baseTierItem).getPath(), this.has((ItemLike)baseTierItem)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)goldTierItem, StorageTierUpgradeRecipe::new).pattern("GGG").pattern("GSG").pattern("GGG").define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('S'), (ItemLike)ironTierItem).unlockedBy("has_" + RegistryHelper.getItemKey((Item)ironTierItem).getPath(), this.has((ItemLike)ironTierItem)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)diamondTierItem, StorageTierUpgradeRecipe::new).pattern("DDD").pattern("DSD").pattern("DDD").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('S'), (ItemLike)goldTierItem).unlockedBy("has_" + RegistryHelper.getItemKey((Item)goldTierItem).getPath(), this.has((ItemLike)goldTierItem)).save(recipeOutput);
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)netheriteTierItem, StorageTierUpgradeShapelessRecipe::new).requires(Ingredient.of((ItemLike)diamondTierItem)).requires(Tags.Items.INGOTS_NETHERITE).unlockedBy("has_" + RegistryHelper.getItemKey((Item)diamondTierItem).getPath(), this.has((ItemLike)diamondTierItem)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)RegistryHelper.getItemKey((Item)netheriteTierItem)));
    }

    private void addDoubleChestTierUpgradeRecipes(RecipeOutput recipeOutput, BlockItem baseTierItem, BlockItem copperTierItem, BlockItem ironTierItem, BlockItem goldTierItem, BlockItem diamondTierItem, BlockItem netheriteTierItem) {
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)copperTierItem, DoubleChestTierUpgradeRecipe::new).pattern("CCC").pattern("CSC").pattern("CBC").define(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_COPPER).define(Character.valueOf('S'), (ItemLike)baseTierItem).unlockedBy("has_" + RegistryHelper.getItemKey((Item)baseTierItem).getPath(), this.has((ItemLike)baseTierItem)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("double_" + RegistryHelper.getItemKey((Item)copperTierItem).getPath())));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)ironTierItem, DoubleChestTierUpgradeRecipe::new).pattern("III").pattern("ISI").pattern("III").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)copperTierItem).unlockedBy("has_" + RegistryHelper.getItemKey((Item)copperTierItem).getPath(), this.has((ItemLike)copperTierItem)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("double_" + RegistryHelper.getItemKey((Item)ironTierItem).getPath() + "_from_" + RegistryHelper.getItemKey((Item)copperTierItem).getPath())));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)ironTierItem, DoubleChestTierUpgradeRecipe::new).pattern("III").pattern("ISI").pattern("IBI").define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)baseTierItem).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_IRON).unlockedBy("has_" + RegistryHelper.getItemKey((Item)baseTierItem).getPath(), this.has((ItemLike)baseTierItem)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("double_" + RegistryHelper.getItemKey((Item)ironTierItem).getPath())));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)goldTierItem, DoubleChestTierUpgradeRecipe::new).pattern("GGG").pattern("GSG").pattern("GBG").define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('S'), (ItemLike)ironTierItem).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_GOLD).unlockedBy("has_" + RegistryHelper.getItemKey((Item)ironTierItem).getPath(), this.has((ItemLike)ironTierItem)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("double_" + RegistryHelper.getItemKey((Item)goldTierItem).getPath())));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)diamondTierItem, DoubleChestTierUpgradeRecipe::new).pattern("DDD").pattern("DSD").pattern("DBD").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('S'), (ItemLike)goldTierItem).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_DIAMOND).unlockedBy("has_" + RegistryHelper.getItemKey((Item)goldTierItem).getPath(), this.has((ItemLike)goldTierItem)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("double_" + RegistryHelper.getItemKey((Item)diamondTierItem).getPath())));
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)netheriteTierItem, DoubleChestTierUpgradeShapelessRecipe::new).requires(Ingredient.of((ItemLike)diamondTierItem)).requires(Tags.Items.INGOTS_NETHERITE).requires(Tags.Items.INGOTS_NETHERITE).unlockedBy("has_" + RegistryHelper.getItemKey((Item)diamondTierItem).getPath(), this.has((ItemLike)diamondTierItem)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("double_" + RegistryHelper.getItemKey((Item)netheriteTierItem).getPath())));
    }

    private void addControllerRelatedRecipes(RecipeOutput recipeOutput) {
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.CONTROLLER_ITEM.get())).pattern("SCS").pattern("PBP").pattern("SCS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('B'), new BaseTierWoodenStorageIngredient().toVanilla()).unlockedBy(HAS_BASE_TIER_WOODEN_STORAGE_CRITERION_NAME, this.has(ModBlocks.BASE_TIER_WOODEN_STORAGE_TAG)).save(recipeOutput);
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)ModBlocks.STORAGE_LINK_ITEM.get()), (int)3).requires((ItemLike)ModBlocks.CONTROLLER_ITEM.get()).requires(Tags.Items.ENDER_PEARLS).unlockedBy("has_controller", this.has((ItemLike)ModBlocks.CONTROLLER_ITEM.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("storage_link_from_controller")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.STORAGE_LINK_ITEM.get())).pattern("EP").pattern("RS").define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('S'), Tags.Items.STONES).unlockedBy("has_repeater", this.has((ItemLike)Items.REPEATER)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STORAGE_TOOL.get())).pattern(" EI").pattern(" SR").pattern("S  ").define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_TORCH).unlockedBy(HAS_REDSTONE_TORCH_CRITERION_NAME, this.has((ItemLike)Items.REDSTONE_TORCH)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.STORAGE_IO_ITEM.get())).pattern("SPS").pattern("RBG").pattern("SPS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('B'), new BaseTierWoodenStorageIngredient().toVanilla()).unlockedBy(HAS_BASE_TIER_WOODEN_STORAGE_CRITERION_NAME, this.has(ModBlocks.BASE_TIER_WOODEN_STORAGE_TAG)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.STORAGE_OUTPUT_ITEM.get())).pattern("SGS").pattern("PBP").pattern("SRS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('B'), new BaseTierWoodenStorageIngredient().toVanilla()).unlockedBy(HAS_BASE_TIER_WOODEN_STORAGE_CRITERION_NAME, this.has(ModBlocks.BASE_TIER_WOODEN_STORAGE_TAG)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.STORAGE_INPUT_ITEM.get())).pattern("SRS").pattern("PBP").pattern("SGS").define(Character.valueOf('S'), Tags.Items.STONES).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('B'), new BaseTierWoodenStorageIngredient().toVanilla()).unlockedBy(HAS_BASE_TIER_WOODEN_STORAGE_CRITERION_NAME, this.has(ModBlocks.BASE_TIER_WOODEN_STORAGE_TAG)).save(recipeOutput);
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)ModBlocks.STORAGE_INPUT_ITEM.get())).requires((ItemLike)ModBlocks.STORAGE_IO_ITEM.get()).unlockedBy("has_storage_io", this.has((ItemLike)ModBlocks.STORAGE_IO_ITEM.get())).save(recipeOutput, "storage_input_from_io");
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)ModBlocks.STORAGE_OUTPUT_ITEM.get())).requires((ItemLike)ModBlocks.STORAGE_INPUT_ITEM.get()).unlockedBy("has_storage_input", this.has((ItemLike)ModBlocks.STORAGE_INPUT_ITEM.get())).save(recipeOutput, "storage_output_from_input");
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)ModBlocks.STORAGE_IO_ITEM.get())).requires((ItemLike)ModBlocks.STORAGE_OUTPUT_ITEM.get()).unlockedBy("has_storage_output", this.has((ItemLike)ModBlocks.STORAGE_OUTPUT_ITEM.get())).save(recipeOutput, "storage_io_from_output");
        WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.forEach((woodType, blockSupplier) -> {
            Block plankBlock = blockSupplier.getBaseBlock();
            ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)new ItemStack((ItemLike)ModBlocks.STORAGE_CONNECTOR_BLOCKS.get(woodType).get())).pattern("SPS").pattern("PSP").pattern("SPS").define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('P'), (ItemLike)plankBlock).unlockedBy("has_" + RegistryHelper.getBlockKey((Block)plankBlock).getPath(), this.has((ItemLike)plankBlock)).save(recipeOutput);
        });
    }

    private void addShulkerBoxRecipes(RecipeOutput recipeOutput) {
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.SHULKER_BOX_ITEM.get())).pattern(" S").pattern("RC").pattern(" S").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('S'), (ItemLike)Items.SHULKER_SHELL).define(Character.valueOf('C'), Tags.Items.CHESTS).unlockedBy("has_shulker_shell", this.has((ItemLike)Items.SHULKER_SHELL)).save(recipeOutput);
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)ModBlocks.SHULKER_BOX_ITEM.get()), ShulkerBoxFromVanillaShapelessRecipe::new).requires((ItemLike)Items.SHULKER_BOX).requires((ItemLike)Items.REDSTONE_TORCH).unlockedBy("has_shulker_box", this.has((ItemLike)Items.SHULKER_BOX)).save(recipeOutput, "shulker_box_from_vanilla_shulker_box");
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.BLACK_SHULKER_BOX, DyeColor.BLACK);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.BLUE_SHULKER_BOX, DyeColor.BLUE);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.BROWN_SHULKER_BOX, DyeColor.BROWN);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.CYAN_SHULKER_BOX, DyeColor.CYAN);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.GRAY_SHULKER_BOX, DyeColor.GRAY);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.GREEN_SHULKER_BOX, DyeColor.GREEN);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.LIGHT_BLUE_SHULKER_BOX, DyeColor.LIGHT_BLUE);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.LIGHT_GRAY_SHULKER_BOX, DyeColor.LIGHT_GRAY);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.LIME_SHULKER_BOX, DyeColor.LIME);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.MAGENTA_SHULKER_BOX, DyeColor.MAGENTA);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.ORANGE_SHULKER_BOX, DyeColor.ORANGE);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.PINK_SHULKER_BOX, DyeColor.PINK);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.PURPLE_SHULKER_BOX, DyeColor.PURPLE);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.RED_SHULKER_BOX, DyeColor.RED);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.WHITE_SHULKER_BOX, DyeColor.WHITE);
        this.tintedShulkerBoxRecipe(recipeOutput, Blocks.YELLOW_SHULKER_BOX, DyeColor.YELLOW);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.SHULKER_BOX_ITEM.get()), ShulkerBoxFromChestRecipe::new).pattern("S").pattern("C").pattern("S").define(Character.valueOf('C'), (ItemLike)ModBlocks.CHEST_ITEM.get()).define(Character.valueOf('S'), (ItemLike)Items.SHULKER_SHELL).unlockedBy("has_chest", this.has((ItemLike)ModBlocks.CHEST_ITEM.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("shulker_from_chest")));
        this.addStorageTierUpgradeRecipes(recipeOutput, (BlockItem)ModBlocks.SHULKER_BOX_ITEM.get(), ModBlocks.COPPER_SHULKER_BOX_ITEM.get(), ModBlocks.IRON_SHULKER_BOX_ITEM.get(), ModBlocks.GOLD_SHULKER_BOX_ITEM.get(), ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get(), ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get());
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.COPPER_SHULKER_BOX_ITEM.get()), ShulkerBoxFromChestRecipe::new).pattern("S").pattern("C").pattern("S").define(Character.valueOf('C'), (ItemLike)ModBlocks.COPPER_CHEST_ITEM.get()).define(Character.valueOf('S'), (ItemLike)Items.SHULKER_SHELL).unlockedBy("has_copper_chest", this.has((ItemLike)ModBlocks.COPPER_CHEST_ITEM.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("copper_shulker_from_copper_chest")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.IRON_SHULKER_BOX_ITEM.get()), ShulkerBoxFromChestRecipe::new).pattern("S").pattern("C").pattern("S").define(Character.valueOf('C'), (ItemLike)ModBlocks.IRON_CHEST_ITEM.get()).define(Character.valueOf('S'), (ItemLike)Items.SHULKER_SHELL).unlockedBy("has_iron_chest", this.has((ItemLike)ModBlocks.IRON_CHEST_ITEM.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("iron_shulker_from_iron_chest")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.GOLD_SHULKER_BOX_ITEM.get()), ShulkerBoxFromChestRecipe::new).pattern("S").pattern("C").pattern("S").define(Character.valueOf('C'), (ItemLike)ModBlocks.GOLD_CHEST_ITEM.get()).define(Character.valueOf('S'), (ItemLike)Items.SHULKER_SHELL).unlockedBy("has_gold_chest", this.has((ItemLike)ModBlocks.GOLD_CHEST_ITEM.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("gold_shulker_from_gold_chest")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.DIAMOND_SHULKER_BOX_ITEM.get()), ShulkerBoxFromChestRecipe::new).pattern("S").pattern("C").pattern("S").define(Character.valueOf('C'), (ItemLike)ModBlocks.DIAMOND_CHEST_ITEM.get()).define(Character.valueOf('S'), (ItemLike)Items.SHULKER_SHELL).unlockedBy("has_diamond_chest", this.has((ItemLike)ModBlocks.DIAMOND_CHEST_ITEM.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("diamond_shulker_from_diamond_chest")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)ModBlocks.NETHERITE_SHULKER_BOX_ITEM.get()), ShulkerBoxFromChestRecipe::new).pattern("S").pattern("C").pattern("S").define(Character.valueOf('C'), (ItemLike)ModBlocks.NETHERITE_CHEST_ITEM.get()).define(Character.valueOf('S'), (ItemLike)Items.SHULKER_SHELL).unlockedBy("has_netherite_chest", this.has((ItemLike)ModBlocks.NETHERITE_CHEST_ITEM.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("netherite_shulker_from_netherite_chest")));
    }

    private void addTierUpgradeItemRecipes(RecipeOutput recipeOutput) {
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TIER_UPGRADE.get())).pattern(" S ").pattern("SRS").pattern(" S ").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).unlockedBy(HAS_REDSTONE_TORCH_CRITERION_NAME, this.has((ItemLike)Items.REDSTONE_TORCH)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_COPPER_TIER_UPGRADE.get())).pattern("CCC").pattern("CRC").pattern("CCC").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).unlockedBy(HAS_REDSTONE_TORCH_CRITERION_NAME, this.has((ItemLike)Items.REDSTONE_TORCH)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_IRON_TIER_UPGRADE.get())).pattern("III").pattern("IRI").pattern("III").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy(HAS_REDSTONE_TORCH_CRITERION_NAME, this.has((ItemLike)Items.REDSTONE_TORCH)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_IRON_TIER_UPGRADE.get())).pattern(" I ").pattern("IRI").pattern(" I ").define(Character.valueOf('R'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_COPPER_TIER_UPGRADE.get()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy(HAS_REDSTONE_TORCH_CRITERION_NAME, this.has((ItemLike)Items.REDSTONE_TORCH)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("basic_to_iron_tier_from_basic_to_copper_tier")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_GOLD_TIER_UPGRADE.get())).pattern("GGG").pattern("GTG").pattern("GGG").define(Character.valueOf('T'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_IRON_TIER_UPGRADE.get()).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_basic_to_iron_tier_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_IRON_TIER_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_DIAMOND_TIER_UPGRADE.get())).pattern("DDD").pattern("DTD").pattern("DDD").define(Character.valueOf('T'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_GOLD_TIER_UPGRADE.get()).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).unlockedBy("has_basic_to_gold_tier_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_GOLD_TIER_UPGRADE.get())).save(recipeOutput);
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_NETHERITE_TIER_UPGRADE.get())).requires((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_DIAMOND_TIER_UPGRADE.get()).requires(Tags.Items.INGOTS_NETHERITE).unlockedBy("has_basic_to_diamond_tier_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BASIC_TO_DIAMOND_TIER_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COPPER_TO_IRON_TIER_UPGRADE.get())).pattern(" I ").pattern("IRI").pattern(" I ").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy(HAS_REDSTONE_TORCH_CRITERION_NAME, this.has((ItemLike)Items.REDSTONE_TORCH)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COPPER_TO_GOLD_TIER_UPGRADE.get())).pattern("GGG").pattern("GTG").pattern("GGG").define(Character.valueOf('T'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COPPER_TO_IRON_TIER_UPGRADE.get()).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy("has_copper_to_iron_tier_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COPPER_TO_IRON_TIER_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COPPER_TO_DIAMOND_TIER_UPGRADE.get())).pattern("DDD").pattern("DTD").pattern("DDD").define(Character.valueOf('T'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COPPER_TO_GOLD_TIER_UPGRADE.get()).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).unlockedBy("has_copper_to_gold_tier_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COPPER_TO_GOLD_TIER_UPGRADE.get())).save(recipeOutput);
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COPPER_TO_NETHERITE_TIER_UPGRADE.get())).requires((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COPPER_TO_DIAMOND_TIER_UPGRADE.get()).requires(Tags.Items.INGOTS_NETHERITE).unlockedBy("has_copper_to_diamond_tier_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COPPER_TO_DIAMOND_TIER_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.IRON_TO_GOLD_TIER_UPGRADE.get())).pattern("GGG").pattern("GRG").pattern("GGG").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).unlockedBy(HAS_REDSTONE_TORCH_CRITERION_NAME, this.has((ItemLike)Items.REDSTONE_TORCH)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.IRON_TO_DIAMOND_TIER_UPGRADE.get())).pattern("DDD").pattern("DTD").pattern("DDD").define(Character.valueOf('T'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.IRON_TO_GOLD_TIER_UPGRADE.get()).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).unlockedBy("has_iron_to_gold_tier_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.IRON_TO_GOLD_TIER_UPGRADE.get())).save(recipeOutput);
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.IRON_TO_NETHERITE_TIER_UPGRADE.get())).requires((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.IRON_TO_DIAMOND_TIER_UPGRADE.get()).requires(Tags.Items.INGOTS_NETHERITE).unlockedBy("has_iron_to_diamond_tier_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.IRON_TO_DIAMOND_TIER_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.GOLD_TO_DIAMOND_TIER_UPGRADE.get())).pattern("DDD").pattern("DRD").pattern("DDD").define(Character.valueOf('R'), (ItemLike)Items.REDSTONE_TORCH).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).unlockedBy(HAS_REDSTONE_TORCH_CRITERION_NAME, this.has((ItemLike)Items.REDSTONE_TORCH)).save(recipeOutput);
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.GOLD_TO_NETHERITE_TIER_UPGRADE.get())).requires((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.GOLD_TO_DIAMOND_TIER_UPGRADE.get()).requires(Tags.Items.INGOTS_NETHERITE).unlockedBy("has_gold_to_diamond_tier_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.GOLD_TO_DIAMOND_TIER_UPGRADE.get())).save(recipeOutput);
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.DIAMOND_TO_NETHERITE_TIER_UPGRADE.get())).requires((ItemLike)Items.REDSTONE_TORCH).requires(Tags.Items.INGOTS_NETHERITE).unlockedBy(HAS_REDSTONE_TORCH_CRITERION_NAME, this.has((ItemLike)Items.REDSTONE_TORCH)).save(recipeOutput);
    }

    private void addUpgradeRecipes(RecipeOutput recipeOutput) {
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).pattern("PIP").pattern("IPI").pattern("PIP").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).unlockedBy("has_iron_ingot", this.has(Tags.Items.INGOTS_IRON)).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PICKUP_UPGRADE.get())).pattern(" P ").pattern("LBL").pattern("RRR").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('L'), ItemTags.PLANKS).define(Character.valueOf('P'), (ItemLike)Blocks.STICKY_PISTON).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_PICKUP_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern(" D ").pattern("GPG").pattern("RRR").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('P'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PICKUP_UPGRADE.get()).unlockedBy("has_pickup_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PICKUP_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.FILTER_UPGRADE.get())).pattern("RSR").pattern("SBS").pattern("RSR").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('S'), Tags.Items.STRINGS).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_FILTER_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern("GPG").pattern("RRR").define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('P'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.FILTER_UPGRADE.get()).unlockedBy("has_filter_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.FILTER_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.MAGNET_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern("EIE").pattern("IPI").pattern("R L").define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('L'), Tags.Items.GEMS_LAPIS).define(Character.valueOf('P'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PICKUP_UPGRADE.get()).unlockedBy("has_pickup_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.PICKUP_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_MAGNET_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern("EIE").pattern("IPI").pattern("R L").define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('L'), Tags.Items.GEMS_LAPIS).define(Character.valueOf('P'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_PICKUP_UPGRADE.get()).unlockedBy("has_advanced_pickup_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_PICKUP_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_MAGNET_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern(" D ").pattern("GMG").pattern("RRR").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('M'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.MAGNET_UPGRADE.get()).unlockedBy("has_magnet_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.MAGNET_UPGRADE.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("advanced_magnet_upgrade_from_basic")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.FEEDING_UPGRADE.get())).pattern(" C ").pattern("ABM").pattern(" E ").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('C'), (ItemLike)Items.GOLDEN_CARROT).define(Character.valueOf('A'), (ItemLike)Items.GOLDEN_APPLE).define(Character.valueOf('M'), (ItemLike)Items.GLISTERING_MELON_SLICE).define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COMPACTING_UPGRADE.get())).pattern("IPI").pattern("PBP").pattern("RPR").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_COMPACTING_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern(" D ").pattern("GCG").pattern("RRR").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('C'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COMPACTING_UPGRADE.get()).unlockedBy("has_compacting_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COMPACTING_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.VOID_UPGRADE.get())).pattern(" E ").pattern("OBO").pattern("ROR").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('E'), Tags.Items.ENDER_PEARLS).define(Character.valueOf('O'), Tags.Items.OBSIDIANS).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_VOID_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern(" D ").pattern("GVG").pattern("RRR").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('V'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.VOID_UPGRADE.get()).unlockedBy("has_void_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.VOID_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMELTING_UPGRADE.get())).pattern("RIR").pattern("IBI").pattern("RFR").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('F'), (ItemLike)Items.FURNACE).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMELTING_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern("DHD").pattern("RSH").pattern("GHG").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('H'), (ItemLike)Items.HOPPER).define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMELTING_UPGRADE.get()).unlockedBy(HAS_SMELTING_UPGRADE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMELTING_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.CRAFTING_UPGRADE.get())).pattern(" T ").pattern("IBI").pattern(" C ").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('C'), Tags.Items.CHESTS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('T'), (ItemLike)Items.CRAFTING_TABLE).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STONECUTTER_UPGRADE.get())).pattern(" S ").pattern("IBI").pattern(" R ").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)Items.STONECUTTER).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_1.get())).pattern("LLL").pattern("LBL").pattern("LLL").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('L'), ItemTags.LOGS).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_1_PLUS.get())).pattern("CCC").pattern("CSC").pattern("BCB").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_1.get()).define(Character.valueOf('C'), Tags.Items.INGOTS_COPPER).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_COPPER).unlockedBy("has_stack_upgrade_tier_1", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_1.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_2.get())).pattern(" I ").pattern("ISI").pattern(" B ").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_1_PLUS.get()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_IRON).unlockedBy("has_stack_upgrade_tier_1_plus", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_1_PLUS.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("stack_upgrade_tier_2_from_tier_1_plus")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_2.get())).pattern("III").pattern("ISI").pattern("BIB").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_1.get()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_IRON).unlockedBy("has_stack_upgrade_tier_1", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_1.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_3.get())).pattern("GGG").pattern("GSG").pattern("BGB").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_2.get()).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_GOLD).unlockedBy("has_stack_upgrade_tier_2", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_2.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_4.get())).pattern("DDD").pattern("DSD").pattern("BDB").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_3.get()).define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_DIAMOND).unlockedBy("has_stack_upgrade_tier_3", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_3.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_5.get())).pattern("NNN").pattern("NSN").pattern("BNB").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_4.get()).define(Character.valueOf('N'), Tags.Items.INGOTS_NETHERITE).define(Character.valueOf('B'), Tags.Items.STORAGE_BLOCKS_NETHERITE).unlockedBy("has_stack_upgrade_tier_4", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_4.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_OMEGA_TIER.get())).pattern("SSS").pattern("SSS").pattern("SSS").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_5.get()).unlockedBy("has_stack_upgrade_tier_5", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_UPGRADE_TIER_5.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_DOWNGRADE_TIER_1.get())).pattern("SFS").pattern("SBS").pattern("FSF").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), (ItemLike)Items.FLINT).define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_DOWNGRADE_TIER_2.get())).pattern("FSF").pattern("SBS").pattern("FSF").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), (ItemLike)Items.FLINT).define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.STACK_DOWNGRADE_TIER_3.get())).pattern("SFS").pattern("FBF").pattern("FSF").define(Character.valueOf('S'), Tags.Items.RODS_WOODEN).define(Character.valueOf('F'), (ItemLike)Items.FLINT).define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.JUKEBOX_UPGRADE.get())).pattern(" J ").pattern("IBI").pattern(" R ").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('J'), (ItemLike)Items.JUKEBOX).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_JUKEBOX_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern(" D ").pattern("GJG").pattern("RRR").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('J'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.JUKEBOX_UPGRADE.get()).unlockedBy("has_jukebox_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.JUKEBOX_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_FEEDING_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern(" D ").pattern("GVG").pattern("RRR").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('V'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.FEEDING_UPGRADE.get()).unlockedBy("has_feeding_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.FEEDING_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMOKING_UPGRADE.get())).pattern("RIR").pattern("IBI").pattern("RSR").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('S'), (ItemLike)Items.SMOKER).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMOKING_UPGRADE.get())).pattern(" L ").pattern("LSL").pattern(" L ").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMELTING_UPGRADE.get()).define(Character.valueOf('L'), ItemTags.LOGS).unlockedBy(HAS_SMELTING_UPGRADE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMELTING_UPGRADE.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("smoking_upgrade_from_smelting_upgrade")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMOKING_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern("DHD").pattern("RSH").pattern("GHG").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('H'), (ItemLike)Items.HOPPER).define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMOKING_UPGRADE.get()).unlockedBy("has_smoking_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMOKING_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMOKING_UPGRADE.get())).pattern(" L ").pattern("LSL").pattern(" L ").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMELTING_UPGRADE.get()).define(Character.valueOf('L'), ItemTags.LOGS).unlockedBy("has_auto_smelting_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMELTING_UPGRADE.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("auto_smoking_upgrade_from_auto_smelting_upgrade")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BLASTING_UPGRADE.get())).pattern("RIR").pattern("IBI").pattern("RFR").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('F'), (ItemLike)Items.BLAST_FURNACE).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BLASTING_UPGRADE.get())).pattern("III").pattern("ISI").pattern("TTT").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMELTING_UPGRADE.get()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('T'), (ItemLike)Items.SMOOTH_STONE).unlockedBy(HAS_SMELTING_UPGRADE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.SMELTING_UPGRADE.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("blasting_upgrade_from_smelting_upgrade")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_BLASTING_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern("DHD").pattern("RSH").pattern("GHG").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('H'), (ItemLike)Items.HOPPER).define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BLASTING_UPGRADE.get()).unlockedBy("has_blasting_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.BLASTING_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_BLASTING_UPGRADE.get())).pattern("III").pattern("ISI").pattern("TTT").define(Character.valueOf('S'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMELTING_UPGRADE.get()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('T'), (ItemLike)Items.SMOOTH_STONE).unlockedBy("has_auto_smelting_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.AUTO_SMELTING_UPGRADE.get())).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("auto_blasting_upgrade_from_auto_smelting_upgrade")));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.COMPRESSION_UPGRADE.get())).pattern(" I ").pattern("PBP").pattern("RIR").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.HOPPER_UPGRADE.get())).pattern(" H ").pattern("IBI").pattern("RRR").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('H'), (ItemLike)Items.HOPPER).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_HOPPER_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern(" D ").pattern("GHG").pattern("ROR").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('O'), (ItemLike)Items.DROPPER).define(Character.valueOf('H'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.HOPPER_UPGRADE.get()).unlockedBy("has_feeding_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.HOPPER_UPGRADE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ALCHEMY_UPGRADE.get())).pattern("TGF").pattern("IBI").pattern("RPR").define(Character.valueOf('T'), (ItemLike)Items.GHAST_TEAR).define(Character.valueOf('G'), (ItemLike)Items.GLASS_BOTTLE).define(Character.valueOf('F'), (ItemLike)Items.FERMENTED_SPIDER_EYE).define(Character.valueOf('R'), (ItemLike)Items.BLAZE_ROD).define(Character.valueOf('P'), (ItemLike)Items.ENDER_PEARL).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(recipeOutput);
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ADVANCED_ALCHEMY_UPGRADE.get()), UpgradeNextTierRecipe::new).pattern(" D ").pattern("GAG").pattern("RRR").define(Character.valueOf('D'), Tags.Items.GEMS_DIAMOND).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('A'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ALCHEMY_UPGRADE.get()).unlockedBy("has_alchemy_upgrade", this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.ALCHEMY_UPGRADE.get())).save(recipeOutput);
        this.addCompatUpgradeRecipes(recipeOutput);
    }

    private void addCompatUpgradeRecipes(RecipeOutput recipeOutput) {
    }

    private void addCompatUpgradeRecipe(RecipeOutput recipeOutput, Item upgrade, Block workbench, Item backpackUpgrade, String modId) {
        RecipeOutput chippedRecipeOutput = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition(modId)});
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)upgrade).pattern(" W ").pattern("IBI").pattern(" R ").define(Character.valueOf('B'), (ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get()).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('W'), (ItemLike)workbench).unlockedBy(HAS_UPGRADE_BASE_CRITERION_NAME, this.has((ItemLike)net.p3pp3rf1y.sophisticatedstorage.init.ModItems.UPGRADE_BASE.get())).save(chippedRecipeOutput);
        RecipeOutput sbChippedRecipeOutput = chippedRecipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("sophisticatedbackpacks")});
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)upgrade).pattern("PUP").pattern(" P ").pattern("P P").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('U'), (ItemLike)backpackUpgrade).unlockedBy("has_backpack_upgrade", this.has((ItemLike)backpackUpgrade)).save(sbChippedRecipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)Identifier.fromNamespaceAndPath((String)"sophisticatedstorage", (String)("storage_" + StorageRecipeProvider.getCompatItemPath(upgrade) + "_from_backpack_" + StorageRecipeProvider.getCompatItemPath(backpackUpgrade)))));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemLike)backpackUpgrade).pattern("TUT").pattern(" L ").pattern("T T").define(Character.valueOf('T'), Tags.Items.STRINGS).define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('U'), (ItemLike)upgrade).unlockedBy("has_storage_upgrade", this.has((ItemLike)upgrade)).save(sbChippedRecipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)Identifier.fromNamespaceAndPath((String)"sophisticatedstorage", (String)("backpack_" + StorageRecipeProvider.getCompatItemPath(backpackUpgrade) + "_from_storage_" + StorageRecipeProvider.getCompatItemPath(upgrade)))));
    }

    private static String getCompatItemPath(Item upgrade) {
        return RegistryHelper.getItemKey((Item)upgrade).getPath().replace('/', '_');
    }

    private void addChestRecipes(RecipeOutput recipeOutput) {
        WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.forEach((woodType, blockFamily) -> this.woodChestRecipe(recipeOutput, (WoodType)woodType, blockFamily.getBaseBlock()));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.CHEST_ITEM.get()), WoodType.OAK), GenericWoodStorageRecipe::new).pattern("PPP").pattern("PRP").pattern("PPP").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has _plank", this.has(ItemTags.PLANKS)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("generic_chest")));
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.CHEST_ITEM.get()), WoodType.OAK)).requires((ItemLike)Blocks.CHEST).requires((ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has_vanilla_chest", this.has((ItemLike)Blocks.CHEST)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("oak_chest_from_vanilla_chest")));
        this.addStorageTierUpgradeRecipes(recipeOutput, (BlockItem)ModBlocks.CHEST_ITEM.get(), ModBlocks.COPPER_CHEST_ITEM.get(), ModBlocks.IRON_CHEST_ITEM.get(), ModBlocks.GOLD_CHEST_ITEM.get(), ModBlocks.DIAMOND_CHEST_ITEM.get(), ModBlocks.NETHERITE_CHEST_ITEM.get());
        this.addDoubleChestTierUpgradeRecipes(recipeOutput, (BlockItem)ModBlocks.CHEST_ITEM.get(), ModBlocks.COPPER_CHEST_ITEM.get(), ModBlocks.IRON_CHEST_ITEM.get(), ModBlocks.GOLD_CHEST_ITEM.get(), ModBlocks.DIAMOND_CHEST_ITEM.get(), ModBlocks.NETHERITE_CHEST_ITEM.get());
    }

    private void addQuarkChestRecipes(RecipeOutput recipeOutput) {
        this.addQuarkChestRecipe(recipeOutput, "oak_chest", WoodType.OAK);
        this.addQuarkChestRecipe(recipeOutput, "acacia_chest", WoodType.ACACIA);
        this.addQuarkChestRecipe(recipeOutput, "birch_chest", WoodType.BIRCH);
        this.addQuarkChestRecipe(recipeOutput, "crimson_chest", WoodType.CRIMSON);
        this.addQuarkChestRecipe(recipeOutput, "dark_oak_chest", WoodType.DARK_OAK);
        this.addQuarkChestRecipe(recipeOutput, "jungle_chest", WoodType.JUNGLE);
        this.addQuarkChestRecipe(recipeOutput, "mangrove_chest", WoodType.MANGROVE);
        this.addQuarkChestRecipe(recipeOutput, "spruce_chest", WoodType.SPRUCE);
        this.addQuarkChestRecipe(recipeOutput, "warped_chest", WoodType.WARPED);
        this.addQuarkChestRecipe(recipeOutput, "bamboo_chest", WoodType.BAMBOO);
        this.addQuarkChestRecipe(recipeOutput, "cherry_chest", WoodType.CHERRY);
    }

    private void addQuarkChestRecipe(RecipeOutput recipeOutput, String name, WoodType woodType) {
        String chestRegistryName = "quark:" + name;
        Block chestBlock = this.getBlock(chestRegistryName);
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.CHEST_ITEM.get()), woodType)).requires((ItemLike)chestBlock).requires((ItemLike)Blocks.REDSTONE_TORCH).save(recipeOutput.withConditions(new ICondition[]{new RegisteredCondition(ResourceKey.create((ResourceKey)Registries.ITEM, (Identifier)Identifier.parse((String)chestRegistryName)))}), ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier(woodType.name() + "_chest_from_quark_" + name)));
    }

    private Block getBlock(String registryName) {
        return (Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(Identifier.parse((String)registryName)).orElseThrow()).value();
    }

    private void addBarrelRecipes(RecipeOutput recipeOutput) {
        WoodStorageBlockBase.CUSTOM_TEXTURE_WOOD_TYPES.forEach((woodType, blockFamily) -> this.woodBarrelRecipe(recipeOutput, (WoodType)woodType, blockFamily.getBaseBlock(), blockFamily.get(BlockFamily.Variant.SLAB)));
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.BARREL_ITEM.get()), WoodType.SPRUCE), GenericWoodStorageRecipe::new).pattern("PSP").pattern("PRP").pattern("PSP").define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('S'), ItemTags.WOODEN_SLABS).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has _plank", this.has(ItemTags.PLANKS)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("generic_barrel")));
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.BARREL_ITEM.get()), WoodType.SPRUCE)).requires((ItemLike)Blocks.BARREL).requires((ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has_vanilla_barrel", this.has((ItemLike)Blocks.BARREL)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier("spruce_barrel_from_vanilla_barrel")));
        this.addStorageTierUpgradeRecipes(recipeOutput, (BlockItem)ModBlocks.BARREL_ITEM.get(), ModBlocks.COPPER_BARREL_ITEM.get(), ModBlocks.IRON_BARREL_ITEM.get(), ModBlocks.GOLD_BARREL_ITEM.get(), ModBlocks.DIAMOND_BARREL_ITEM.get(), ModBlocks.NETHERITE_BARREL_ITEM.get());
    }

    private void woodBarrelRecipe(RecipeOutput recipeOutput, WoodType woodType, Block planks, Block slab) {
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.BARREL_ITEM.get()), woodType)).pattern("PSP").pattern("PRP").pattern("PSP").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has_" + woodType.name() + PLANK_SUFFIX, this.has((ItemLike)planks)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier(woodType.name() + "_barrel")));
    }

    private void limitedWoodBarrelRecipe(RecipeOutput recipeOutput, WoodType woodType, Block planks, Block slab, Consumer<ShapedRecipeBuilder> addPattern, BlockItem item) {
        ShapedRecipeBuilder builder = ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)item), woodType)).define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('S'), (ItemLike)slab).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has_" + woodType.name() + PLANK_SUFFIX, this.has((ItemLike)planks));
        addPattern.accept(builder);
        builder.save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier(woodType.name() + "_" + RegistryHelper.getItemKey((Item)item).getPath())));
    }

    private void limitedWoodBarrel1Recipe(RecipeOutput recipeOutput, WoodType woodType, Block planks, Block slab) {
        this.limitedWoodBarrelRecipe(recipeOutput, woodType, planks, slab, builder -> builder.pattern("PSP").pattern("PRP").pattern("PPP"), ModBlocks.LIMITED_BARREL_1_ITEM.get());
    }

    private void limitedWoodBarrel2Recipe(RecipeOutput recipeOutput, WoodType woodType, Block planks, Block slab) {
        this.limitedWoodBarrelRecipe(recipeOutput, woodType, planks, slab, builder -> builder.pattern("PPP").pattern("SRS").pattern("PPP"), ModBlocks.LIMITED_BARREL_2_ITEM.get());
    }

    private void limitedWoodBarrel3Recipe(RecipeOutput recipeOutput, WoodType woodType, Block planks, Block slab) {
        this.limitedWoodBarrelRecipe(recipeOutput, woodType, planks, slab, builder -> builder.pattern("PSP").pattern("PRP").pattern("SPS"), ModBlocks.LIMITED_BARREL_3_ITEM.get());
    }

    private void limitedWoodBarrel4Recipe(RecipeOutput recipeOutput, WoodType woodType, Block planks, Block slab) {
        this.limitedWoodBarrelRecipe(recipeOutput, woodType, planks, slab, builder -> builder.pattern("SPS").pattern("PRP").pattern("SPS"), ModBlocks.LIMITED_BARREL_4_ITEM.get());
    }

    private void woodChestRecipe(RecipeOutput recipeOutput, WoodType woodType, Block planks) {
        ShapeBasedRecipeBuilder.shaped(this.items, (ItemStack)WoodStorageBlockItem.setWoodType(new ItemStack((ItemLike)ModBlocks.CHEST_ITEM.get()), woodType)).pattern("PPP").pattern("PRP").pattern("PPP").define(Character.valueOf('P'), (ItemLike)planks).define(Character.valueOf('R'), (ItemLike)Blocks.REDSTONE_TORCH).unlockedBy("has_" + woodType.name() + PLANK_SUFFIX, this.has((ItemLike)planks)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier(woodType.name() + "_chest")));
    }

    private void tintedShulkerBoxRecipe(RecipeOutput recipeOutput, Block vanillaShulkerBox, DyeColor dyeColor) {
        String vanillaShulkerBoxName = BuiltInRegistries.BLOCK.getKey((Object)vanillaShulkerBox).getPath();
        ShapelessBasedRecipeBuilder.shapeless(this.items, (ItemStack)ModBlocks.SHULKER_BOX.get().getTintedStack(dyeColor), ShulkerBoxFromVanillaShapelessRecipe::new).requires((ItemLike)vanillaShulkerBox).requires((ItemLike)Items.REDSTONE_TORCH).unlockedBy("has_" + vanillaShulkerBoxName, this.has((ItemLike)vanillaShulkerBox)).save(recipeOutput, ResourceKey.create((ResourceKey)Registries.RECIPE, (Identifier)SophisticatedStorage.getIdentifier(vanillaShulkerBoxName + "_to_sophisticated")));
    }

    public static class Runner
    extends RecipeProvider.Runner {
        protected Runner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
            super(packOutput, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            return new StorageRecipeProvider(provider, recipeOutput);
        }

        public String getName() {
            return "Sophisticated Storage Recipes";
        }
    }
}

