/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.data;

import com.mojang.serialization.MapCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;

public class CopyStorageDataFunction
implements LootItemFunction {
    private static final CopyStorageDataFunction INSTANCE = new CopyStorageDataFunction();
    public static final MapCodec<CopyStorageDataFunction> CODEC = MapCodec.unit((Object)INSTANCE).stable();

    private CopyStorageDataFunction() {
    }

    public ItemStack apply(ItemStack stack, LootContext context) {
        Block block;
        BlockState state = (BlockState)context.getOptionalParameter(LootContextParams.BLOCK_STATE);
        if (state != null && (block = state.getBlock()) instanceof IAdditionalDropDataBlock) {
            IAdditionalDropDataBlock additionalDropDataBlock = (IAdditionalDropDataBlock)block;
            BlockEntity be = (BlockEntity)context.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
            if (be instanceof StorageBlockEntity) {
                StorageBlockEntity storageBlockEntity = (StorageBlockEntity)be;
                additionalDropDataBlock.addDropData(stack, storageBlockEntity);
            }
        }
        return stack;
    }

    public LootItemFunctionType<? extends LootItemFunction> getType() {
        return ModItems.COPY_STORAGE_DATA.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements LootItemFunction.Builder {
        public LootItemFunction build() {
            return new CopyStorageDataFunction();
        }
    }
}

