/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common.gui;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.ItemStacksResourceHandler;
import net.neoforged.neoforge.transfer.item.ResourceHandlerSlot;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataPayload;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jspecify.annotations.Nullable;

public class DecorationTableMenu
extends AbstractContainerMenu
implements ISyncedContainer {
    private static final String SET_INHERITANCE_ACTION = "setInheritance";
    private static final Identifier EMPTY_RED_DYE_SLOT_BACKGROUND = SophisticatedStorage.getIdentifier("container/slot/red_dye");
    private static final Identifier EMPTY_GREEN_DYE_SLOT_BACKGROUND = SophisticatedStorage.getIdentifier("container/slot/green_dye");
    private static final Identifier EMPTY_BLUE_DYE_SLOT_BACKGROUND = SophisticatedStorage.getIdentifier("container/slot/blue_dye");
    private static final Identifier EMPTY_MATERIAL_SLOT_BACKGROUND = SophisticatedStorage.getIdentifier("container/slot/material");
    public static final int DECORATION_SLOT_PADDING = 12;
    private final DecorationTableBlockEntity blockEntity;
    private Slot resultSlot;
    private SlotRange decorationSlotRange;
    private SlotRange dyeSlotRange;
    private SlotRange storageSlotRange;
    private SlotRange playerSlotRange;
    private @Nullable Runnable slotChangedListener = null;
    private ResourceHandlerSlot storageSlot;

    public DecorationTableMenu(int containerId, Player player, BlockPos pos) {
        super(ModBlocks.DECORATION_TABLE_CONTAINER_TYPE.get(), containerId);
        this.blockEntity = player.level().getBlockEntity(pos, ModBlocks.DECORATION_TABLE_BLOCK_ENTITY_TYPE.get()).orElse(null);
        if (this.blockEntity == null) {
            throw new IllegalStateException("No block entity found at position " + String.valueOf(pos));
        }
        int y = this.addDecorationSlots();
        this.addStorageSlots();
        this.addPlayerSlots(player.getInventory(), y += 14);
    }

    public void setSlotChangedListener(@Nullable Runnable listener) {
        this.slotChangedListener = listener;
    }

    public Slot getStorageSlot() {
        return this.storageSlot;
    }

    public List<ItemStack> getDecoratedPreviewStacks() {
        return this.blockEntity.getDecoratedPreviewStacks();
    }

    private void addStorageSlots() {
        ItemStacksResourceHandler storageBlock = this.blockEntity.getStorageBlock();
        this.storageSlot = new ResourceHandlerSlot((ResourceHandler)storageBlock, (index, resource, amount) -> {
            storageBlock.set(index, resource, amount);
            if (this.slotChangedListener != null) {
                this.slotChangedListener.run();
            }
        }, 0, this.getSlot((int)this.dyeSlotRange.firstSlot()).x, this.getSlot((int)3).y);
        this.addSlot((Slot)this.storageSlot);
        this.storageSlotRange = new SlotRange(this.dyeSlotRange.firstSlot() + this.dyeSlotRange.size(), 1);
        this.resultSlot = new Slot((Container)new SimpleContainer(1){

            public ItemStack getItem(int index) {
                return DecorationTableMenu.this.blockEntity.getResult();
            }

            public ItemStack removeItem(int index, int count) {
                return index == 0 ? DecorationTableMenu.this.blockEntity.extractResult(count) : ItemStack.EMPTY;
            }
        }, 0, this.storageSlot.x + 18 + 18, this.storageSlot.y){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public boolean mayPickup(Player player) {
                return super.mayPickup(player) && DecorationTableMenu.this.getMissingDyes().isEmpty();
            }

            public ItemStack remove(int amount) {
                return super.remove(amount);
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                if (player.level().isClientSide()) {
                    return;
                }
                DecorationTableMenu.this.blockEntity.consumeIngredientsOnCraft();
                InventoryHelper.extract((ResourceHandler)DecorationTableMenu.this.blockEntity.getStorageBlock(), (int)0, (ItemResource)((ItemResource)DecorationTableMenu.this.blockEntity.getStorageBlock().getResource(0)), (int)1);
            }
        };
        this.addSlot(this.resultSlot);
    }

    private int addDecorationSlots() {
        int xOffset = 8;
        int yOffset = 17;
        ItemStacksResourceHandler decorativeBlocks = this.blockEntity.getDecorativeBlocks();
        int x = xOffset;
        int y = yOffset;
        int slotIndex = 0;
        y = this.addDecorationSlot(decorativeBlocks, slotIndex, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 1, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 2, x, y, 12);
        this.addDecorationSlot(decorativeBlocks, 3, x, y, 12);
        y = yOffset + 18 + 12;
        y = this.addDecorationSlot(decorativeBlocks, 4, x += 48, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 5, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 6, x, y, 0);
        this.decorationSlotRange = new SlotRange(0, decorativeBlocks.size());
        ItemStacksResourceHandler dyes = this.blockEntity.getDyes();
        this.addSlot(new ResourceHandlerSlot((ResourceHandler)dyes, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)dyes).set(arg_0, arg_1, arg_2), 0, x += 44, yOffset).setBackground(EMPTY_RED_DYE_SLOT_BACKGROUND));
        this.addSlot(new ResourceHandlerSlot((ResourceHandler)dyes, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)dyes).set(arg_0, arg_1, arg_2), 1, x += 18, yOffset).setBackground(EMPTY_GREEN_DYE_SLOT_BACKGROUND));
        this.addSlot(new ResourceHandlerSlot((ResourceHandler)dyes, (arg_0, arg_1, arg_2) -> ((ItemStacksResourceHandler)dyes).set(arg_0, arg_1, arg_2), 2, x += 18, yOffset).setBackground(EMPTY_BLUE_DYE_SLOT_BACKGROUND));
        this.dyeSlotRange = new SlotRange(this.decorationSlotRange.firstSlot() + this.decorationSlotRange.size(), dyes.size());
        return y;
    }

    private int addDecorationSlot(ItemStacksResourceHandler itemHandler, int slotIndex, int xOffset, int y, int yPadding) {
        this.addSlot(new ResourceHandlerSlot((ResourceHandler)itemHandler, (index, resource, amount) -> {
            itemHandler.set(index, resource, amount);
            if (this.slotChangedListener != null) {
                this.slotChangedListener.run();
            }
        }, slotIndex, xOffset, y).setBackground(EMPTY_MATERIAL_SLOT_BACKGROUND));
        y += 18;
        return y += yPadding;
    }

    private void addPlayerSlots(Inventory playerInventory, int y) {
        int playerSlotXOffset = 45;
        int hotbarPadding = 4;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, playerSlotXOffset + col * 18, y + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            Slot slot = new Slot((Container)playerInventory, col, playerSlotXOffset + col * 18, y + 54 + hotbarPadding);
            this.addSlot(slot);
        }
        this.playerSlotRange = new SlotRange(this.storageSlotRange.firstSlot() + this.storageSlotRange.size() + 1, 36);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = this.getSlot(slotIndex);
        ItemStack slotStack = slot.getItem();
        ItemStack slotStackCopy = slotStack.copy();
        if (this.isPlayerSlot(slotIndex)) {
            ItemResource resource = ItemResource.of((ItemStack)slotStack);
            if (this.blockEntity.getDecorativeBlocks().isValid(this.decorationSlotRange.firstSlot(), (Resource)resource) && !this.moveItemStackTo(slotStack, this.decorationSlotRange, false)) {
                return ItemStack.EMPTY;
            }
            if (this.isValidDye(slotStack) && !this.moveItemStackTo(slotStack, this.dyeSlotRange, false)) {
                return ItemStack.EMPTY;
            }
            if (this.blockEntity.getStorageBlock().isValid(0, (Resource)resource) && !this.moveItemStackTo(slotStack, this.storageSlotRange, false)) {
                return ItemStack.EMPTY;
            }
        } else if (!this.moveItemStackTo(slotStack, this.playerSlotRange, true)) {
            return ItemStack.EMPTY;
        }
        if (slotStackCopy.getCount() == slotStack.getCount()) {
            return ItemStack.EMPTY;
        }
        this.blockEntity.updateResultAndSetChanged();
        slot.onTake(player, slotStackCopy);
        return slotStackCopy;
    }

    private boolean isValidDye(ItemStack stack) {
        ItemStacksResourceHandler dyes = this.blockEntity.getDyes();
        ItemResource resource = ItemResource.of((ItemStack)stack);
        for (int slot = 0; slot < dyes.size(); ++slot) {
            if (!dyes.isValid(slot, (Resource)resource)) continue;
            return true;
        }
        return false;
    }

    private boolean moveItemStackTo(ItemStack stack, SlotRange slotRange, boolean reverse) {
        return this.moveItemStackTo(stack, slotRange.firstSlot(), slotRange.firstSlot() + slotRange.size(), reverse);
    }

    private boolean isPlayerSlot(int slotIndex) {
        return this.playerSlotRange.isInRange(slotIndex);
    }

    public SlotRange getDyeSlotRange() {
        return this.dyeSlotRange;
    }

    public boolean stillValid(Player player) {
        return player.isWithinBlockInteractionRange(this.blockEntity.getBlockPos(), 4.0);
    }

    public static DecorationTableMenu fromBuffer(int containerId, Inventory playerInventory, RegistryFriendlyByteBuf buffer) {
        return new DecorationTableMenu(containerId, playerInventory.player, buffer.readBlockPos());
    }

    public void setSlotMaterialInheritance(DecorationTableBlockEntity.PartSlot slot, boolean inheritance) {
        this.blockEntity.setSlotMaterialInheritance(slot, inheritance);
        this.sendToServer(tag -> {
            tag.putString("action", SET_INHERITANCE_ACTION);
            tag.putString("slot", slot.getSerializedName());
            tag.putBoolean("inheritance", inheritance);
        });
    }

    public void setMainColor(int color) {
        this.blockEntity.setMainColor(color);
        this.sendToServer(tag -> tag.putInt("mainColor", color));
    }

    public void setAccentColor(int color) {
        this.blockEntity.setAccentColor(color);
        this.sendToServer(tag -> tag.putInt("accentColor", color));
    }

    public boolean isSlotMaterialInherited(int slotIndex) {
        return this.isSlotMaterialInherited(DecorationTableBlockEntity.PartSlot.fromSlotIndex(slotIndex));
    }

    public boolean isSlotMaterialInherited(DecorationTableBlockEntity.PartSlot slot) {
        return this.blockEntity.isSlotMaterialInherited(slot);
    }

    public ItemResource getInheritedResource(int slotIndex) {
        return this.getInheritedResource(DecorationTableBlockEntity.PartSlot.fromSlotIndex(slotIndex));
    }

    public ItemResource getInheritedResource(DecorationTableBlockEntity.PartSlot childSlot) {
        return this.blockEntity.getInheritedItem(childSlot);
    }

    public int getMainColor() {
        return this.blockEntity.getMainColor();
    }

    public int getAccentColor() {
        return this.blockEntity.getAccentColor();
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }

    protected void sendToServer(Consumer<CompoundTag> addData) {
        if (this.blockEntity.getLevel() == null || !this.blockEntity.getLevel().isClientSide()) {
            return;
        }
        CompoundTag data = new CompoundTag();
        addData.accept(data);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncContainerClientDataPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public Map<Identifier, Integer> getPartsNeeded() {
        return this.blockEntity.getPartsNeeded();
    }

    public Set<Identifier> getMissingDyes() {
        return this.blockEntity.getMissingDyes();
    }

    public void handlePacket(CompoundTag data) {
        data.getString("action").ifPresent(action -> {
            if (action.equals(SET_INHERITANCE_ACTION)) {
                data.getString("slot").ifPresent(slotName -> data.getBoolean("inheritance").ifPresent(inheritance -> this.setSlotMaterialInheritance(DecorationTableBlockEntity.PartSlot.fromName(slotName), (boolean)inheritance)));
            }
        });
        data.getInt("mainColor").ifPresent(this::setMainColor);
        data.getInt("accentColor").ifPresent(this::setAccentColor);
    }

    public Map<Identifier, Integer> getPartsStored() {
        return this.blockEntity.getPartsStored();
    }

    public boolean hasMaterials() {
        return this.blockEntity.hasMaterials();
    }
}

