/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderState;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageTierUpgradeItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import org.jspecify.annotations.Nullable;

public abstract class StorageRenderer<T extends StorageBlockEntity, R extends StorageRenderState>
implements BlockEntityRenderer<T, R> {
    private final ItemModelResolver itemModelResolver;
    private long lastCacheTime = -1L;
    private boolean holdsItemThatShowsUpgrades = false;
    private boolean holdsStorageToolSetToToggleUpgrades = false;
    private boolean holdsItemThatShowsHiddenTiers = false;
    private boolean holdsItemThatShowsFillLevels = false;
    private boolean holdsToolInToggleLockOrLockDisplay = false;
    private boolean holdsToolInToggleFillLevelDisplay = false;

    public StorageRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    protected boolean holdsItemThatShowsUpgrades() {
        this.refreshCache();
        return this.holdsItemThatShowsUpgrades;
    }

    public boolean holdsItemThatShowsFillLevels() {
        return this.holdsItemThatShowsFillLevels;
    }

    private void refreshCache() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null && level.getGameTime() != this.lastCacheTime) {
            this.lastCacheTime = level.getGameTime();
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                this.holdsItemThatShowsUpgrades = false;
                this.holdsStorageToolSetToToggleUpgrades = false;
                this.holdsItemThatShowsHiddenTiers = false;
                this.holdsToolInToggleLockOrLockDisplay = false;
                return;
            }
            boolean holdsStorageTool = this.holdsItem(player, this::isStorageTool);
            this.holdsStorageToolSetToToggleUpgrades = holdsStorageTool && InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).map(item -> StorageToolItem.getMode(item) == StorageToolItem.Mode.UPGRADES_DISPLAY).orElse(false) != false;
            this.holdsItemThatShowsUpgrades = holdsStorageTool || this.holdsItem(player, this::isUpgrade);
            this.holdsItemThatShowsFillLevels = holdsStorageTool || this.holdsItem(player, this::isStorageTierUpgrade) || this.holdsItem(player, stack -> this.isUpgrade((ItemStack)stack) && stack.getItem() instanceof StackUpgradeItem);
            this.holdsItemThatShowsHiddenTiers = holdsStorageTool && InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).map(item -> StorageToolItem.getMode(item) == StorageToolItem.Mode.TIER_DISPLAY).orElse(false) != false || this.holdsItem(player, this::isStorageTierUpgrade);
            this.holdsToolInToggleLockOrLockDisplay = holdsStorageTool && InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).map(item -> {
                StorageToolItem.Mode mode = StorageToolItem.getMode(item);
                return mode == StorageToolItem.Mode.LOCK_DISPLAY || mode == StorageToolItem.Mode.LOCK;
            }).orElse(false) != false;
            this.holdsToolInToggleFillLevelDisplay = holdsStorageTool && InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.STORAGE_TOOL.get())).map(item -> StorageToolItem.getMode(item) == StorageToolItem.Mode.FILL_LEVEL_DISPLAY).orElse(false) != false;
        }
    }

    public boolean holdsItemThatShowsHiddenTiers() {
        this.refreshCache();
        return this.holdsItemThatShowsHiddenTiers;
    }

    public boolean holdsToolInToggleLockOrLockDisplay() {
        this.refreshCache();
        return this.holdsToolInToggleLockOrLockDisplay;
    }

    public boolean holdsToolInToggleFillLevelDisplay() {
        this.refreshCache();
        return this.holdsToolInToggleFillLevelDisplay;
    }

    private boolean holdsItem(LocalPlayer player, Predicate<ItemStack> itemMatcher) {
        return itemMatcher.test(player.getItemInHand(InteractionHand.MAIN_HAND)) || itemMatcher.test(player.getItemInHand(InteractionHand.OFF_HAND));
    }

    private boolean isStorageTool(ItemStack stack) {
        return stack.getItem() == ModItems.STORAGE_TOOL.get();
    }

    private boolean isUpgrade(ItemStack stack) {
        return stack.getItem() instanceof UpgradeItemBase && stack.is(ModItems.STORAGE_UPGRADE_TAG);
    }

    private boolean isStorageTierUpgrade(ItemStack stack) {
        return stack.getItem() instanceof StorageTierUpgradeItem;
    }

    public boolean shouldShowDisabledUpgradesDisplay(T storageBlockEntity) {
        this.refreshCache();
        return this.holdsStorageToolSetToToggleUpgrades && !((StorageBlockEntity)storageBlockEntity).shouldShowUpgrades();
    }

    public void extractRenderState(T blockEntity, R renderState, float partialTick, Vec3 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        BlockState blockState = blockEntity.getBlockState();
        Block block = blockState.getBlock();
        if (!(block instanceof StorageBlockBase)) {
            return;
        }
        StorageBlockBase storageBlock = (StorageBlockBase)block;
        RenderDataHandler renderDataHandler = this.getStorageWrapper(blockEntity).getRenderDataHandler();
        ((StorageRenderState)((Object)renderState)).upgradeItems = renderDataHandler.getUpgradeItems().stream().flatMap(upgradeItem -> {
            ItemStack stack = upgradeItem.isEmpty() ? new ItemStack((ItemLike)ModItems.UPGRADE_BASE.get()) : upgradeItem;
            ItemStackRenderState stackRenderState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(stackRenderState, stack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
            return Stream.of(stackRenderState);
        }).toList();
        ((StorageRenderState)((Object)renderState)).showsUpgrades = ((StorageBlockEntity)blockEntity).shouldShowUpgrades();
        ((StorageRenderState)((Object)renderState)).showsTier = ((StorageBlockEntity)blockEntity).shouldShowTier();
        ((StorageRenderState)((Object)renderState)).isLocked = ((StorageBlockEntity)blockEntity).isLocked();
        ((StorageRenderState)((Object)renderState)).showsLock = ((StorageBlockEntity)blockEntity).shouldShowLock();
        ((StorageRenderState)((Object)renderState)).showsDisabledUpgradeDisplay = this.shouldShowDisabledUpgradesDisplay(blockEntity);
        RenderData.DisplayData displayData = renderDataHandler.getDisplayData();
        List displayItems = displayData.displayItems();
        ((StorageRenderState)((Object)renderState)).inaccessibleSlots = new HashSet<Integer>(displayData.inaccessibleSlots());
        ((StorageRenderState)((Object)renderState)).displayItemSlots = storageBlock.getDisplayItemsCount(displayItems);
        ((StorageRenderState)((Object)renderState)).displayItems = new ArrayList<StorageRenderState.DisplayItemInfo>();
        for (int i = 0; i < displayItems.size(); ++i) {
            RenderData.DisplayItemData displayItem = (RenderData.DisplayItemData)displayItems.get(i);
            ItemStack stack = displayItem.item();
            if (stack.isEmpty()) continue;
            ItemStackRenderState stackRenderState = new ItemStackRenderState();
            this.itemModelResolver.updateForTopItem(stackRenderState, stack, ItemDisplayContext.FIXED, blockEntity.getLevel(), null, 0);
            float itemOffset = (float)DisplayItemRenderer.getDisplayItemOffset(stack, stackRenderState, DisplayItemRenderer.isGui3d(stackRenderState), ((StorageRenderState)((Object)renderState)).displayItemSlots == 1 ? 1.0f : 0.5f);
            ((StorageRenderState)((Object)renderState)).displayItems.add(new StorageRenderState.DisplayItemInfo(stackRenderState, storageBlock.hasFixedIndexDisplayItems() ? displayItem.slotIndex() : i, displayItem.rotation(), stack.getItem() instanceof BlockItem, itemOffset, displayItem.displaySide()));
        }
    }

    protected StorageWrapper getStorageWrapper(T blockEntity) {
        return ((StorageBlockEntity)blockEntity).getStorageWrapper();
    }
}

