/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.SimpleUnbakedGeometry;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.Identifier;
import net.minecraft.util.context.ContextMap;
import net.neoforged.neoforge.client.model.AbstractUnbakedModel;
import net.neoforged.neoforge.client.model.ExtendedUnbakedGeometry;
import net.neoforged.neoforge.client.model.NeoForgeModelProperties;
import net.neoforged.neoforge.client.model.StandardModelParameters;
import net.neoforged.neoforge.client.model.UnbakedElementsHelper;
import net.neoforged.neoforge.client.model.UnbakedModelLoader;
import org.jspecify.annotations.Nullable;

public class SimpleCompositeUnbakedModel
extends AbstractUnbakedModel {
    private final SimpleCompositeUnbakedGeometry geometry;

    private SimpleCompositeUnbakedModel(SimpleCompositeUnbakedGeometry geometry, StandardModelParameters parameters) {
        super(parameters);
        this.geometry = geometry;
    }

    public @Nullable UnbakedGeometry geometry() {
        return this.geometry;
    }

    public void resolveDependencies(ResolvableModel.Resolver resolver) {
        super.resolveDependencies(resolver);
        this.geometry.resolveDependencies(resolver);
    }

    public static class SimpleCompositeUnbakedGeometry
    implements ExtendedUnbakedGeometry {
        private final ImmutableMap<String, Either<Identifier, UnbakedModel>> children;

        public Map<String, Either<Identifier, UnbakedModel>> children() {
            return this.children;
        }

        public SimpleCompositeUnbakedGeometry(ImmutableMap<String, Either<Identifier, UnbakedModel>> children) {
            this.children = children;
        }

        public QuadCollection bake(TextureSlots slots, ModelBaker baker, ModelState state, ModelDebugName debugName, ContextMap additionalProperties) {
            ArrayList<BlockElement> allElements = new ArrayList<BlockElement>();
            this.addAllChildElements(baker, debugName, allElements);
            Transformation rootTransform = (Transformation)additionalProperties.getOrDefault(NeoForgeModelProperties.TRANSFORM, (Object)Transformation.identity());
            if (!rootTransform.isIdentity()) {
                state = UnbakedElementsHelper.composeRootTransformIntoModelState((ModelState)state, (Transformation)rootTransform);
            }
            return new SimpleUnbakedGeometry(allElements).bake(slots, baker, state, debugName, additionalProperties);
        }

        private void addAllChildElements(ModelBaker baker, ModelDebugName debugName, List<BlockElement> elements) {
            this.children.forEach((key, value) -> {
                ResolvedModel model = (ResolvedModel)value.map(arg_0 -> ((ModelBaker)baker).getModel(arg_0), inline -> baker.resolveInlineModel(inline, () -> debugName.debugName() + "_" + key));
                this.addModelElements(baker, debugName, elements, model);
            });
        }

        private void addModelElements(ModelBaker baker, ModelDebugName debugName, List<BlockElement> elements, ResolvedModel child) {
            UnbakedModel unbakedModel = child.wrapped();
            if (unbakedModel instanceof SimpleCompositeUnbakedModel) {
                SimpleCompositeUnbakedModel compositeModel = (SimpleCompositeUnbakedModel)unbakedModel;
                compositeModel.geometry.addAllChildElements(baker, debugName, elements);
            } else {
                BlockModel blockModel;
                unbakedModel = child.wrapped();
                if (unbakedModel instanceof BlockModel && (unbakedModel = (blockModel = (BlockModel)unbakedModel).geometry()) instanceof SimpleUnbakedGeometry) {
                    SimpleUnbakedGeometry geometry = (SimpleUnbakedGeometry)unbakedModel;
                    elements.addAll(geometry.elements());
                }
            }
            ResolvedModel parent = child.parent();
            if (parent != null) {
                this.addModelElements(baker, debugName, elements, parent);
            }
        }

        public void resolveDependencies(ResolvableModel.Resolver resolver) {
            this.children.values().forEach(child -> child.ifLeft(arg_0 -> ((ResolvableModel.Resolver)resolver).markDependency(arg_0)).ifRight(model -> {
                Identifier parent = model.parent();
                if (parent != null) {
                    resolver.markDependency(parent);
                }
                model.resolveDependencies(resolver);
            }));
        }
    }

    public static final class Loader
    implements UnbakedModelLoader<SimpleCompositeUnbakedModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public SimpleCompositeUnbakedModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            Loader.readChildren(jsonObject, "parts", (ImmutableMap.Builder<String, Either<Identifier, UnbakedModel>>)childrenBuilder, deserializationContext);
            ImmutableMap children = childrenBuilder.build();
            if (children.isEmpty()) {
                throw new JsonParseException("Simple Composite model requires a \"parts\" element with at least one element.");
            }
            StandardModelParameters parameters = StandardModelParameters.parse((JsonObject)jsonObject, (JsonDeserializationContext)deserializationContext);
            return new SimpleCompositeUnbakedModel(new SimpleCompositeUnbakedGeometry((ImmutableMap<String, Either<Identifier, UnbakedModel>>)children), parameters);
        }

        private static void readChildren(JsonObject jsonObject, String name, ImmutableMap.Builder<String, Either<Identifier, UnbakedModel>> children, JsonDeserializationContext context) {
            if (jsonObject.has(name)) {
                JsonObject childrenJsonObject = jsonObject.getAsJsonObject(name);
                for (Map.Entry entry : childrenJsonObject.entrySet()) {
                    JsonElement jsonElement;
                    JsonElement jsonElement2 = (JsonElement)entry.getValue();
                    Objects.requireNonNull(jsonElement2);
                    int n = 0;
                    Either child = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonPrimitive.class, JsonObject.class}, (Object)jsonElement, n)) {
                        case 0 -> {
                            JsonPrimitive reference = (JsonPrimitive)jsonElement;
                            yield Either.left((Object)Identifier.parse((String)reference.getAsString()));
                        }
                        case 1 -> {
                            JsonObject inline = (JsonObject)jsonElement;
                            yield Either.right((Object)((UnbakedModel)context.deserialize((JsonElement)inline, UnbakedModel.class)));
                        }
                        default -> throw new IllegalArgumentException("");
                    };
                    children.put((Object)((String)entry.getKey()), (Object)child);
                }
            }
        }
    }
}

