/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.jspecify.annotations.Nullable;

public class RenderHelper {
    public static final CameraRenderState ZERO_POS_CAMERA_RENDER_STATE = new CameraRenderState();
    private static final Cache<Integer, TextureAtlasSprite> SPRITE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    private RenderHelper() {
    }

    public static TextureAtlasSprite getSprite(Identifier blockName, @Nullable Direction direction, RandomSource rand) {
        int hash = blockName.hashCode();
        TextureAtlasSprite sprite = (TextureAtlasSprite)SPRITE_CACHE.getIfPresent((Object)(hash = hash * 31 + (direction == null ? 0 : direction.hashCode())));
        if (sprite == null) {
            sprite = RenderHelper.parseSprite(blockName, direction, rand);
            SPRITE_CACHE.put((Object)hash, (Object)sprite);
        }
        return sprite;
    }

    private static TextureAtlasSprite parseSprite(Identifier blockName, @Nullable Direction direction, RandomSource rand) {
        BlockState blockState = RenderHelper.getDefaultBlockState(blockName);
        TextureAtlasSprite sprite = RenderHelper.parseSpriteFromModel(blockState, direction, rand);
        if (sprite == null) {
            sprite = Minecraft.getInstance().getModelManager().getMissingBlockStateModel().particleIcon();
        }
        return sprite;
    }

    private static @Nullable TextureAtlasSprite parseSpriteFromModel(BlockState blockState, @Nullable Direction direction, RandomSource rand) {
        TextureAtlasSprite sprite = null;
        BlockStateModel blockModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState);
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return null;
        }
        try {
            List parts = blockModel.collectParts((BlockAndTintGetter)level, BlockPos.ZERO, blockState, rand);
            for (BlockModelPart part : parts) {
                List quads = part.getQuads(direction);
                if (!quads.isEmpty()) {
                    return ((BakedQuad)quads.getFirst()).sprite();
                }
                for (BakedQuad quad : part.getQuads(null)) {
                    if (sprite == null) {
                        sprite = quad.sprite();
                    }
                    if (quad.direction() != direction) continue;
                    return quad.sprite();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sprite == null) {
            try {
                sprite = blockModel.particleIcon((BlockAndTintGetter)level, BlockPos.ZERO, blockState);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sprite;
    }

    private static BlockState getDefaultBlockState(Identifier blockName) {
        return BuiltInRegistries.BLOCK.getOptional(blockName).map(Block::defaultBlockState).orElse(Blocks.AIR.defaultBlockState());
    }

    static void renderQuad(VertexConsumer consumer, Matrix4f pose, Vector3f normal, int packedOverlay, int packedLight, float alpha, TextureAtlasSprite sprite) {
        RenderHelper.renderQuad(consumer, pose, normal, packedOverlay, packedLight, alpha, 0.0f, 0.0f, 1.0f, 1.0f, sprite);
    }

    static void renderQuad(VertexConsumer consumer, Matrix4f pose, Vector3f normal, int packedOverlay, int packedLight, float alpha, float minU, float minV, float maxU, float maxV, TextureAtlasSprite sprite) {
        VertexConsumer spriteConsumer = sprite.wrap(consumer);
        boolean minX = false;
        int minY = 0;
        int maxY = 1;
        boolean maxX = true;
        RenderHelper.addVertex(pose, normal, spriteConsumer, maxY, (float)minX, packedOverlay, packedLight, maxU, minV, alpha);
        RenderHelper.addVertex(pose, normal, spriteConsumer, minY, (float)minX, packedOverlay, packedLight, maxU, maxV, alpha);
        RenderHelper.addVertex(pose, normal, spriteConsumer, minY, (float)maxX, packedOverlay, packedLight, minU, maxV, alpha);
        RenderHelper.addVertex(pose, normal, spriteConsumer, maxY, (float)maxX, packedOverlay, packedLight, minU, minV, alpha);
    }

    private static void addVertex(Matrix4f pose, Vector3f normal, VertexConsumer consumer, int pY, float pX, int packedOverlay, int packedLight, float u, float v, float alpha) {
        Vector4f pos = new Vector4f(pX, (float)pY, 0.0f, 1.0f);
        pose.transform(pos);
        int color = (int)(alpha * 255.0f) << 24 | 0xFF0000 | 0xFF00 | 0xFF;
        consumer.addVertex(pos.x(), pos.y(), pos.z(), color, u, v, packedOverlay, packedLight, normal.x(), normal.y(), normal.z());
    }

    public static boolean isSpecialRenderer(ItemStackRenderState renderState) {
        for (ItemStackRenderState.LayerRenderState layer : renderState.layers) {
            if (layer.specialRenderer == null) continue;
            return true;
        }
        return false;
    }
}

