/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelBlockStateModelBase;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderState;
import net.p3pp3rf1y.sophisticatedstorage.client.render.StorageRenderer;
import org.jspecify.annotations.Nullable;

public abstract class BarrelRendererBase<T extends BarrelBlockEntity, R extends BarrelRenderStateBase>
extends StorageRenderer<T, R> {
    public static final RenderType TRANSLUCENT = RenderTypes.entityTranslucent((Identifier)TextureAtlas.LOCATION_BLOCKS);
    protected final DisplayItemRenderer displayItemRenderer = new DisplayItemRenderer(0.5, new Vec3(0.0, 0.0, -0.0625));
    protected final DisplayItemRenderer flatDisplayItemRenderer = new DisplayItemRenderer(0.5, Vec3.ZERO);

    public BarrelRendererBase(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void submitHiddenTier(SubmitNodeCollector submitNodeCollector, BarrelRenderStateBase renderState, PoseStack poseStack) {
        if (!renderState.showsTier && this.holdsItemThatShowsHiddenTiers()) {
            this.submitTranslucentQuads(submitNodeCollector, poseStack, renderState.lightCoords, renderState.hiddenTierQuads);
        }
    }

    protected void submitHiddenLock(SubmitNodeCollector submitNodeCollector, BarrelRenderStateBase renderState, PoseStack poseStack) {
        if (!renderState.showsLock && renderState.isLocked && this.holdsToolInToggleLockOrLockDisplay()) {
            this.submitTranslucentQuads(submitNodeCollector, poseStack, renderState.lightCoords, renderState.hiddenLockQuads);
        }
    }

    private void submitTranslucentQuads(SubmitNodeCollector submitNodeCollector, PoseStack poseStack, int packedLight, List<BakedQuad> quads) {
        if (quads.isEmpty()) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(-0.005, -0.005, -0.005);
        poseStack.scale(1.01f, 1.01f, 1.01f);
        submitNodeCollector.submitCustomGeometry(poseStack, TRANSLUCENT, (pose, vertexConsumer) -> quads.forEach(quad -> vertexConsumer.putBulkData(pose, quad, 1.0f, 1.0f, 1.0f, 0.5f, packedLight, OverlayTexture.NO_OVERLAY)));
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 32;
    }

    @Override
    public void extractRenderState(T blockEntity, R renderState, float partialTick, Vec3 cameraPos, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BarrelBlockStateModelBase barrelBlockStateModel;
        BlockStateModel blockModel;
        super.extractRenderState(blockEntity, renderState, partialTick, cameraPos, crumblingOverlay);
        ((BarrelRenderStateBase)((Object)renderState)).packed = ((WoodStorageBlockEntity)blockEntity).isPacked();
        if (((BarrelRenderStateBase)((Object)renderState)).packed) {
            return;
        }
        BlockPos pos = blockEntity.getBlockPos();
        BlockState blockState = blockEntity.getBlockState();
        Block block = blockState.getBlock();
        if (block instanceof BarrelBlock) {
            BarrelBlock storageBlock = (BarrelBlock)block;
            if (blockEntity.getLevel() != null && pos != BlockPos.ZERO) {
                Direction facing = storageBlock.getFacing(blockState);
                ((BarrelRenderStateBase)((Object)renderState)).lightCoords = LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)pos.relative(facing));
            }
        }
        ((BarrelRenderStateBase)((Object)renderState)).flatTop = (Boolean)blockState.getValue((Property)BarrelBlock.FLAT_TOP);
        ((BarrelRenderStateBase)((Object)renderState)).woodName = ((WoodStorageBlockEntity)blockEntity).getWoodType().orElse(WoodType.ACACIA).name();
        if (!((BarrelRenderStateBase)((Object)renderState)).showsTier && this.holdsItemThatShowsHiddenTiers() && (blockModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState)) instanceof BarrelBlockStateModelBase) {
            barrelBlockStateModel = (BarrelBlockStateModelBase)blockModel;
            barrelBlockStateModel.setWoodName(((BarrelRenderStateBase)((Object)renderState)).woodName);
            ((BarrelRenderStateBase)((Object)renderState)).hiddenTierQuads = barrelBlockStateModel.getTierQuads().getAll();
        }
        if (!((BarrelRenderStateBase)((Object)renderState)).showsLock && this.holdsToolInToggleLockOrLockDisplay() && (blockModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState)) instanceof BarrelBlockStateModelBase) {
            barrelBlockStateModel = (BarrelBlockStateModelBase)blockModel;
            barrelBlockStateModel.setWoodName(((BarrelRenderStateBase)((Object)renderState)).woodName);
            ((BarrelRenderStateBase)((Object)renderState)).hiddenLockQuads = barrelBlockStateModel.getLockQuads().getAll();
        }
    }

    public static class BarrelRenderStateBase
    extends StorageRenderState {
        public boolean flatTop;
        public boolean packed;
        public String woodName = WoodType.ACACIA.name();
        public List<BakedQuad> hiddenTierQuads = Collections.emptyList();
        public List<BakedQuad> hiddenLockQuads = Collections.emptyList();
    }
}

