/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.render;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.math.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.UnbakedGeometry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.neoforge.client.model.DynamicBlockStateModel;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.client.render.BarrelModelPart;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DisplayItemRenderer;
import net.p3pp3rf1y.sophisticatedstorage.client.render.DynamicBarrelBakingData;
import net.p3pp3rf1y.sophisticatedstorage.client.render.RenderHelper;
import org.joml.Quaternionfc;
import org.jspecify.annotations.Nullable;

public abstract class BarrelBlockStateModelBase
implements DynamicBlockStateModel {
    public static final Map<Direction, Transformation> DIRECTION_ROTATES = Map.of(Direction.UP, BarrelBlockStateModelBase.getDirectionRotationTransform(Direction.UP), Direction.DOWN, BarrelBlockStateModelBase.getDirectionRotationTransform(Direction.DOWN), Direction.NORTH, BarrelBlockStateModelBase.getDirectionRotationTransform(Direction.NORTH), Direction.SOUTH, BarrelBlockStateModelBase.getDirectionRotationTransform(Direction.SOUTH), Direction.WEST, BarrelBlockStateModelBase.getDirectionRotationTransform(Direction.WEST), Direction.EAST, BarrelBlockStateModelBase.getDirectionRotationTransform(Direction.EAST));
    private static final LoadingCache<Direction, Cache<Integer, Transformation>> DIRECTION_MOVES_3D_ITEMS = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Direction, Cache<Integer, Transformation>>(){

        public Cache<Integer, Transformation> load(Direction key) {
            return CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
        }
    });
    private static final Cache<Integer, Transformation> DIRECTION_MOVE_BACK_TO_SIDE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static final Cache<Integer, List<BlockModelPart>> BAKED_PARTS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build();
    public static final Cache<Integer, List<BakedQuad>> BAKED_QUADS_CACHE = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).build();
    private static final List<BarrelMaterial> PARTICLE_ICON_MATERIAL_PRIORITY = List.of(BarrelMaterial.ALL, BarrelMaterial.ALL_BUT_TRIM, BarrelMaterial.TOP_ALL, BarrelMaterial.TOP);
    private boolean showsLock;
    private final ModelBaker baker;
    protected final Map<String, Map<BarrelModelPart, QuadCollection>> woodModelParts;
    private final Map<String, Map<BarrelModelPart, TextureAtlasSprite>> particleIcons;
    private Item barrelItem = Items.AIR;
    private @Nullable String woodName = null;
    private boolean hasMainColor = false;
    private boolean hasAccentColor = false;
    private boolean isPacked = false;
    private boolean showsTier = true;
    private Map<BarrelMaterial, Identifier> materials = new EnumMap<BarrelMaterial, Identifier>(BarrelMaterial.class);
    private boolean flatTop = false;
    private final Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData;
    private final Map<String, Map<BarrelModelPart, QuadCollection>> woodPartitionedModelParts;
    private final Cache<Integer, QuadCollection> dynamicBakedModelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public static void invalidateCache() {
        DIRECTION_MOVES_3D_ITEMS.invalidateAll();
        DIRECTION_MOVE_BACK_TO_SIDE.invalidateAll();
        BAKED_PARTS_CACHE.invalidateAll();
        BAKED_QUADS_CACHE.invalidateAll();
    }

    protected BarrelBlockStateModelBase(ModelBaker baker, Map<String, Map<BarrelModelPart, QuadCollection>> woodModelParts, Map<String, Map<BarrelModelPart, TextureAtlasSprite>> particleIcons, Map<String, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData>> woodDynamicBakingData, Map<String, Map<BarrelModelPart, QuadCollection>> woodPartitionedModelParts) {
        this.baker = baker;
        this.woodModelParts = woodModelParts;
        this.particleIcons = particleIcons;
        this.woodDynamicBakingData = woodDynamicBakingData;
        this.woodPartitionedModelParts = woodPartitionedModelParts;
    }

    public void setBarrelItem(Item barrelItem) {
        this.barrelItem = barrelItem;
    }

    public void setWoodName(@Nullable String woodName) {
        this.woodName = woodName;
    }

    public void setHasMainColor(boolean hasMainColor) {
        this.hasMainColor = hasMainColor;
    }

    public void setHasAccentColor(boolean hasAccentColor) {
        this.hasAccentColor = hasAccentColor;
    }

    public void setPacked(boolean packed) {
        this.isPacked = packed;
    }

    public void setShowsTier(boolean showsTier) {
        this.showsTier = showsTier;
    }

    public void setBarrelMaterials(Map<BarrelMaterial, Identifier> barrelMaterials) {
        this.materials = barrelMaterials;
    }

    public void setFlatTop(boolean flatTop) {
        this.flatTop = flatTop;
    }

    private static Transformation getDirectionRotationTransform(Direction dir) {
        return new Transformation(null, (Quaternionfc)DisplayItemRenderer.getNorthBasedRotation(dir), null, null);
    }

    public TextureAtlasSprite particleIcon() {
        if (this.hasMainColor) {
            return this.particleIcons.values().iterator().next().get((Object)BarrelModelPart.TINTABLE_MAIN);
        }
        if (!this.materials.isEmpty()) {
            for (BarrelMaterial barrelMaterial : PARTICLE_ICON_MATERIAL_PRIORITY) {
                if (!this.materials.containsKey((Object)barrelMaterial)) continue;
                BlockState blockState = this.getDefaultBlockState(this.materials.get((Object)barrelMaterial));
                return Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState).particleIcon();
            }
        }
        if (this.particleIcons.containsKey(this.woodName)) {
            return this.particleIcons.get(this.woodName).get((Object)BarrelModelPart.BASE);
        }
        return this.particleIcons.values().iterator().next().get((Object)BarrelModelPart.BASE);
    }

    public List<BakedQuad> getQuads(RandomSource rand) {
        this.showsLock = false;
        int hash = this.createItemHash();
        List cachedQuads = (List)BAKED_QUADS_CACHE.getIfPresent((Object)hash);
        if (cachedQuads != null) {
            return cachedQuads;
        }
        List<BlockModelPart> parts = this.getParts(null, rand);
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
        for (BlockModelPart part : parts) {
            for (Direction dir : Direction.values()) {
                bakedQuads.addAll(part.getQuads(dir));
            }
            bakedQuads.addAll(part.getQuads(null));
        }
        BAKED_QUADS_CACHE.put((Object)hash, bakedQuads);
        return bakedQuads;
    }

    public void collectParts(@Nullable BlockAndTintGetter level, BlockPos pos, @Nullable BlockState state, RandomSource rand, List<BlockModelPart> parts) {
        int hash;
        List cachedParts;
        this.showsLock = false;
        BarrelBlockEntity be = WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, BarrelBlockEntity.class).orElse(null);
        if (be != null) {
            this.hasMainColor = be.getStorageWrapper().hasMainColor();
            this.hasAccentColor = be.getStorageWrapper().hasAccentColor();
            this.isPacked = be.isPacked();
            this.showsTier = be.shouldShowTier();
            this.woodName = be.getWoodType().map(WoodType::name).orElse(WoodType.ACACIA.name());
            this.materials = be.getMaterials();
            this.flatTop = state != null && (Boolean)state.getValue((Property)BarrelBlock.FLAT_TOP) != false;
            this.showsLock = be.isLocked() && be.shouldShowLock();
            this.showsTier = be.shouldShowTier();
        }
        if ((cachedParts = (List)BAKED_PARTS_CACHE.getIfPresent((Object)(hash = this.createHash(state)))) != null) {
            parts.addAll(cachedParts);
            return;
        }
        List<BlockModelPart> partsToCache = this.getParts(state, rand);
        BAKED_PARTS_CACHE.put((Object)hash, partsToCache);
        parts.addAll(partsToCache);
    }

    private List<BlockModelPart> getParts(@Nullable BlockState state, RandomSource rand) {
        QuadCollection.Builder cutoutQuadCollectionBuilder = new QuadCollection.Builder();
        QuadCollection.Builder translucentQuadCollectionBuilder = new QuadCollection.Builder();
        boolean isBakedDynamically = !this.materials.isEmpty();
        Set materialModelParts = this.materials.keySet().stream().map(BarrelMaterial::getMaterialModelPart).collect(Collectors.toSet());
        boolean rendersUsingSplitModel = materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.CORE) || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.TRIM);
        Map<BarrelModelPart, QuadCollection> modelParts = this.getWoodModelParts(isBakedDynamically && rendersUsingSplitModel);
        if (modelParts.isEmpty()) {
            return Collections.emptyList();
        }
        if (!(this.hasMainColor && this.hasAccentColor || isBakedDynamically)) {
            this.addPartQuads(cutoutQuadCollectionBuilder, modelParts, this.getBasePart(state));
        }
        this.addTintableModelQuads(cutoutQuadCollectionBuilder, state, modelParts);
        if (isBakedDynamically) {
            this.bakeAndAddDynamicQuads(cutoutQuadCollectionBuilder, rand, rendersUsingSplitModel, !this.hasMainColor || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.CORE), !this.hasAccentColor || materialModelParts.contains((Object)BarrelMaterial.MaterialModelPart.TRIM));
        }
        if (this.showsTier) {
            this.addPartQuads(cutoutQuadCollectionBuilder, modelParts, BarrelModelPart.TIER);
        }
        if (this.isPacked) {
            this.addPartQuads(cutoutQuadCollectionBuilder, modelParts, BarrelModelPart.PACKED);
        } else if (this.showsLock) {
            this.addPartQuads(cutoutQuadCollectionBuilder, modelParts, BarrelModelPart.LOCKED);
        }
        ArrayList<BlockModelPart> parts = new ArrayList<BlockModelPart>();
        parts.add((BlockModelPart)new SimpleModelWrapper(cutoutQuadCollectionBuilder.build(), true, this.particleIcon(), ChunkSectionLayer.CUTOUT));
        QuadCollection translucentQuads = translucentQuadCollectionBuilder.build();
        if (!translucentQuads.getAll().isEmpty()) {
            parts.add((BlockModelPart)new SimpleModelWrapper(translucentQuads, true, this.particleIcon(), ChunkSectionLayer.TRANSLUCENT));
        }
        return parts;
    }

    public QuadCollection getTierQuads() {
        return this.getPartQuads(BarrelModelPart.TIER);
    }

    public QuadCollection getLockQuads() {
        return this.getPartQuads(BarrelModelPart.LOCKED);
    }

    private QuadCollection getPartQuads(BarrelModelPart part) {
        Map<BarrelModelPart, QuadCollection> modelParts = this.getWoodModelParts(false);
        QuadCollection.Builder builder = new QuadCollection.Builder();
        this.addPartQuads(builder, modelParts, part);
        return builder.build();
    }

    private void bakeAndAddDynamicQuads(QuadCollection.Builder builder, RandomSource rand, boolean rendersUsingSplitModel, boolean renderCore, boolean renderTrim) {
        Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData> bakingData = this.woodDynamicBakingData.get(this.woodName != null ? this.woodName : WoodType.ACACIA.name());
        HashMap<String, Material> mats = new HashMap<String, Material>();
        for (Map.Entry<BarrelMaterial, Identifier> entry : this.materials.entrySet()) {
            BarrelMaterial barrelMaterial = entry.getKey();
            for (BarrelMaterial childMaterial : barrelMaterial.getChildren()) {
                Identifier blockName = entry.getValue();
                TextureAtlasSprite sprite = RenderHelper.getSprite(blockName, childMaterial.getLeafSide(), rand);
                mats.put(childMaterial.getSerializedName(), new Material(TextureAtlas.LOCATION_BLOCKS, sprite.contents().name()));
            }
        }
        if (rendersUsingSplitModel) {
            if (renderCore) {
                builder.addAll(this.getDynamicModel(this.woodName, bakingData, mats, DynamicBarrelBakingData.DynamicPart.CORE));
            }
            if (renderTrim) {
                builder.addAll(this.getDynamicModel(this.woodName, bakingData, mats, DynamicBarrelBakingData.DynamicPart.TRIM));
            }
        } else {
            builder.addAll(this.getDynamicModel(this.woodName, bakingData, mats, DynamicBarrelBakingData.DynamicPart.WHOLE));
        }
    }

    private QuadCollection getDynamicModel(@Nullable String woodName, Map<DynamicBarrelBakingData.DynamicPart, DynamicBarrelBakingData> bakingData, Map<String, Material> materials, DynamicBarrelBakingData.DynamicPart dynamicPart) {
        int hash = Objects.hash(woodName, materials, dynamicPart.name());
        QuadCollection bakedModel = (QuadCollection)this.dynamicBakedModelCache.getIfPresent((Object)hash);
        if (bakedModel == null) {
            bakedModel = this.compileAndBakeModel(materials, bakingData.get((Object)dynamicPart));
            this.dynamicBakedModelCache.put((Object)hash, (Object)bakedModel);
        }
        return bakedModel;
    }

    private BlockState getDefaultBlockState(Identifier blockName) {
        return ((Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(blockName).orElseThrow()).value()).defaultBlockState();
    }

    private QuadCollection compileAndBakeModel(Map<String, Material> textures, DynamicBarrelBakingData bakingData) {
        bakingData.baseTextures().forEach((textureName, texture) -> {
            if (!textures.containsKey(textureName)) {
                textures.put((String)textureName, (Material)texture);
            }
        });
        TextureSlots.Data.Builder texturesBuilder = new TextureSlots.Data.Builder();
        textures.forEach((arg_0, arg_1) -> ((TextureSlots.Data.Builder)texturesBuilder).addTexture(arg_0, arg_1));
        TextureSlots.Resolver resolver = new TextureSlots.Resolver();
        resolver.addLast(texturesBuilder.build());
        UnbakedGeometry geometry = bakingData.baseModel().geometry();
        return geometry == null ? QuadCollection.EMPTY : geometry.bake(resolver.resolve(bakingData.debugName()), this.baker, bakingData.modelState(), bakingData.debugName(), ContextMap.EMPTY);
    }

    protected abstract BarrelModelPart getBasePart(@Nullable BlockState var1);

    public int createItemHash() {
        return this.barrelItem.hashCode() * 31 + this.createHash(null);
    }

    protected int createHash(@Nullable BlockState state) {
        int hash;
        int n = hash = state != null ? state.getBlock().hashCode() : 0;
        if (this.woodName != null) {
            hash = hash * 31 + this.woodName.hashCode() + 1;
        }
        hash = hash * 31 + (this.hasMainColor ? 1 : 0);
        hash = hash * 31 + (this.hasAccentColor ? 1 : 0);
        hash = hash * 31 + (this.isPacked ? 1 : 0);
        hash = hash * 31 + (this.showsLock ? 1 : 0);
        hash = hash * 31 + (this.showsTier ? 1 : 0);
        hash = hash * 31 + (this.flatTop ? 1 : 0);
        hash = hash * 31 + this.materials.hashCode();
        return hash;
    }

    private void addTintableModelQuads(QuadCollection.Builder builder, @Nullable BlockState state, Map<BarrelModelPart, QuadCollection> modelParts) {
        if (this.hasAccentColor) {
            this.addPartQuads(builder, modelParts, BarrelModelPart.TINTABLE_ACCENT);
        }
        if (this.hasMainColor) {
            this.addPartQuads(builder, modelParts, this.getMainPart(state));
        }
    }

    private BarrelModelPart getMainPart(@Nullable BlockState state) {
        return this.rendersOpen() && state != null && (Boolean)state.getValue((Property)BarrelBlock.OPEN) != false ? BarrelModelPart.TINTABLE_MAIN_OPEN : BarrelModelPart.TINTABLE_MAIN;
    }

    protected abstract boolean rendersOpen();

    private void addPartQuads(QuadCollection.Builder builder, Map<BarrelModelPart, QuadCollection> modelParts, BarrelModelPart part) {
        if (modelParts.containsKey((Object)part)) {
            builder.addAll(modelParts.get((Object)part));
        }
    }

    private Map<BarrelModelPart, QuadCollection> getWoodModelParts(boolean requiresPartitionedModel) {
        if (requiresPartitionedModel && this.woodPartitionedModelParts.containsKey(this.woodName)) {
            return this.woodPartitionedModelParts.get(this.woodName);
        }
        if (this.woodModelParts.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.woodName == null || !this.woodModelParts.containsKey(this.woodName)) {
            return this.woodModelParts.values().iterator().next();
        }
        return this.woodModelParts.get(this.woodName);
    }

    public void setModelPropertiesFromBlockEntity(BarrelBlockEntity be) {
        this.hasMainColor = be.getStorageWrapper().hasMainColor();
        this.hasAccentColor = be.getStorageWrapper().hasAccentColor();
        this.isPacked = be.isPacked();
        this.showsLock = be.isLocked() && be.shouldShowLock();
        this.showsTier = be.shouldShowTier();
        Optional<WoodType> woodType = be.getWoodType();
        this.woodName = woodType.isPresent() || !this.hasMainColor || !this.hasAccentColor ? woodType.orElse(WoodType.ACACIA).name() : null;
        this.materials = be.getMaterials();
    }
}

