/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.init;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jspecify.annotations.Nullable;

public class ModBlockColors {
    private ModBlockColors() {
    }

    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register(ModBlockColors::getBarrelTintColor, new Block[]{(Block)ModBlocks.BARREL.get(), (Block)ModBlocks.COPPER_BARREL.get(), (Block)ModBlocks.IRON_BARREL.get(), (Block)ModBlocks.GOLD_BARREL.get(), (Block)ModBlocks.DIAMOND_BARREL.get(), (Block)ModBlocks.NETHERITE_BARREL.get(), (Block)ModBlocks.LIMITED_BARREL_1.get(), (Block)ModBlocks.LIMITED_COPPER_BARREL_1.get(), (Block)ModBlocks.LIMITED_IRON_BARREL_1.get(), (Block)ModBlocks.LIMITED_GOLD_BARREL_1.get(), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_1.get(), (Block)ModBlocks.LIMITED_NETHERITE_BARREL_1.get(), (Block)ModBlocks.LIMITED_BARREL_2.get(), (Block)ModBlocks.LIMITED_COPPER_BARREL_2.get(), (Block)ModBlocks.LIMITED_IRON_BARREL_2.get(), (Block)ModBlocks.LIMITED_GOLD_BARREL_2.get(), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_2.get(), (Block)ModBlocks.LIMITED_NETHERITE_BARREL_2.get(), (Block)ModBlocks.LIMITED_BARREL_3.get(), (Block)ModBlocks.LIMITED_COPPER_BARREL_3.get(), (Block)ModBlocks.LIMITED_IRON_BARREL_3.get(), (Block)ModBlocks.LIMITED_GOLD_BARREL_3.get(), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_3.get(), (Block)ModBlocks.LIMITED_NETHERITE_BARREL_3.get(), (Block)ModBlocks.LIMITED_BARREL_4.get(), (Block)ModBlocks.LIMITED_COPPER_BARREL_4.get(), (Block)ModBlocks.LIMITED_IRON_BARREL_4.get(), (Block)ModBlocks.LIMITED_GOLD_BARREL_4.get(), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_4.get(), (Block)ModBlocks.LIMITED_NETHERITE_BARREL_4.get()});
        event.register(ModBlockColors::getChestShulkerBoxColor, new Block[]{(Block)ModBlocks.CHEST.get(), (Block)ModBlocks.COPPER_CHEST.get(), (Block)ModBlocks.IRON_CHEST.get(), (Block)ModBlocks.GOLD_CHEST.get(), (Block)ModBlocks.DIAMOND_CHEST.get(), (Block)ModBlocks.NETHERITE_CHEST.get(), (Block)ModBlocks.SHULKER_BOX.get(), (Block)ModBlocks.COPPER_SHULKER_BOX.get(), (Block)ModBlocks.IRON_SHULKER_BOX.get(), (Block)ModBlocks.GOLD_SHULKER_BOX.get(), (Block)ModBlocks.DIAMOND_SHULKER_BOX.get(), (Block)ModBlocks.NETHERITE_SHULKER_BOX.get()});
    }

    private static int getBarrelTintColor(BlockState state, @Nullable BlockAndTintGetter blockDisplayReader, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex < 0 || pos == null) {
            return -1;
        }
        return WorldHelper.getBlockEntity((BlockGetter)blockDisplayReader, (BlockPos)pos, StorageBlockEntity.class).map(be -> {
            if (tintIndex == 0) {
                return be.getStorageWrapper().getMainColor();
            }
            if (tintIndex == 1) {
                return be.getStorageWrapper().getAccentColor();
            }
            return -1;
        }).orElse(-1);
    }

    private static int getTint(BlockState state, int displayItemIndex, int adjustedTintIndex, StorageBlockEntity be) {
        RenderData.DisplayData displayData = be.getStorageWrapper().getRenderDataHandler().getDisplayData();
        List displayItems = displayData.displayItems();
        ItemStack stack = ModBlockColors.getDisplayItemWithIndex(displayItemIndex, displayItems, state.getBlock() instanceof LimitedBarrelBlock);
        if (stack.isEmpty()) {
            return -1;
        }
        ItemStackRenderState renderState = new ItemStackRenderState();
        Minecraft.getInstance().getItemModelResolver().updateForTopItem(renderState, stack, ItemDisplayContext.FIXED, null, null, 0);
        for (ItemStackRenderState.LayerRenderState layer : renderState.layers) {
            if (layer.tintLayers.length <= adjustedTintIndex) continue;
            return layer.tintLayers[adjustedTintIndex];
        }
        return -1;
    }

    private static ItemStack getDisplayItemWithIndex(int displayItemIndex, List<RenderData.DisplayItemData> displayItems, boolean isLimitedBarrel) {
        if (isLimitedBarrel) {
            for (RenderData.DisplayItemData displayItem : displayItems) {
                if (displayItem.slotIndex() != displayItemIndex) continue;
                return displayItem.item();
            }
        }
        return displayItems.size() > displayItemIndex ? displayItems.get(displayItemIndex).item() : ItemStack.EMPTY;
    }

    private static int getChestShulkerBoxColor(BlockState state, @Nullable BlockAndTintGetter blockDisplayReader, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex < 0 || pos == null) {
            return -1;
        }
        return WorldHelper.getBlockEntity((BlockGetter)blockDisplayReader, (BlockPos)pos, StorageBlockEntity.class).map(be -> {
            if (tintIndex == 0) {
                return be.getStorageWrapper().getMainColor();
            }
            return -1;
        }).orElse(-1);
    }
}

