/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client.gui;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.client.gui.GuiLayer;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.PaintbrushItem;
import org.jspecify.annotations.Nullable;

public class PaintbrushOverlay {
    private static Optional<PaintbrushItem.ItemRequirements> ITEM_REQUIREMENTS_CACHE = Optional.empty();
    private static @Nullable BlockPos lastPosCached = null;
    private static @Nullable ItemStack lastPaintbrushCached = null;
    public static final GuiLayer HUD_PAINTBRUSH_INFO = (guiGraphics, deltaTracker) -> {
        HitResult patt0$temp;
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            if (!mc.screen.isPauseScreen()) {
                lastPosCached = null;
                lastPaintbrushCached = null;
            }
            return;
        }
        LocalPlayer player = mc.player;
        ClientLevel level = mc.level;
        if (player == null || level == null || !((patt0$temp = mc.hitResult) instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)patt0$temp;
        BlockPos pos = blockHitResult.getBlockPos();
        if (!(level.getBlockState(pos).getBlock() instanceof StorageBlockBase) && level.getBlockState(pos).getBlock() != ModBlocks.CONTROLLER.get()) {
            return;
        }
        InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.PAINTBRUSH.get())).flatMap(arg_0 -> PaintbrushOverlay.lambda$static$0(player, (Level)level, pos, arg_0)).ifPresent(itemRequirements -> {
            if (itemRequirements.itemsMissing().isEmpty()) {
                return;
            }
            Component missingItems = StorageTranslationHelper.INSTANCE.translItemOverlayMessage((Item)ModItems.PAINTBRUSH.get(), "missing_items", new Object[0]);
            Font font = mc.font;
            int i = font.width((FormattedText)missingItems);
            int x = (guiGraphics.guiWidth() - i) / 2;
            int y = guiGraphics.guiHeight() - 75 - 10;
            guiGraphics.drawStringWithBackdrop(font, missingItems, x + 1, y, DyeColor.WHITE.getTextColor(), -1);
            x = (guiGraphics.guiWidth() - itemRequirements.itemsMissing().size() * 18) / 2;
            for (ItemStack missingItem : itemRequirements.itemsMissing()) {
                guiGraphics.renderItem(missingItem, x, y + 10);
                guiGraphics.renderItemDecorations(font, missingItem, x, y + 10);
                x += 18;
            }
        });
    };

    public static Optional<PaintbrushItem.ItemRequirements> getItemRequirementsFor(ItemStack paintbrush, Player player, Level level, BlockPos pos) {
        if (!pos.equals((Object)lastPosCached) || paintbrush != lastPaintbrushCached) {
            ITEM_REQUIREMENTS_CACHE = PaintbrushItem.getItemRequirements(paintbrush, player, level, pos);
            lastPosCached = pos;
            lastPaintbrushCached = paintbrush;
        }
        return ITEM_REQUIREMENTS_CACHE;
    }

    private static /* synthetic */ Optional lambda$static$0(LocalPlayer player, Level level, BlockPos pos, ItemStack paintbrush) {
        return PaintbrushOverlay.getItemRequirementsFor(paintbrush, (Player)player, level, pos);
    }
}

