/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.WoodType;
import org.jspecify.annotations.Nullable;

public class StorageTextureManager
extends SimpleJsonResourceReloadListener<JsonElement> {
    public static final StorageTextureManager INSTANCE = new StorageTextureManager();
    private static final String PARENT_TAG = "parent";
    private static final String TYPE_TAG = "type";
    private static final String TEXTURES_TAG = "textures";
    private static final WoodType defaultChestWoodType = WoodType.ACACIA;
    private static final String CHEST_SUFFIX = "_chest";
    private static final Map<String, Supplier<ITextureParser>> TEXTURE_PARSERS = new HashMap<String, Supplier<ITextureParser>>();
    private final Map<WoodType, Map<ChestType, Map<ChestMaterial, Material>>> woodChestMaterials = new HashMap<WoodType, Map<ChestType, Map<ChestMaterial, Material>>>();

    private StorageTextureManager() {
        super(ExtraCodecs.JSON, FileToIdConverter.json((String)"storage_texture_definitions"));
    }

    protected Map<Identifier, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        this.clear();
        Map fileContents = super.prepare(resourceManager, profiler);
        HashMap<Identifier, StorageTextureDefinition> storageTextureDefinitions = new HashMap<Identifier, StorageTextureDefinition>();
        fileContents.forEach((identifier, json) -> this.loadDefinition((Map<Identifier, StorageTextureDefinition>)storageTextureDefinitions, (Identifier)identifier, (JsonElement)json, fileContents));
        storageTextureDefinitions.forEach((fileName, definition) -> {
            String type = definition.getType();
            String filePath = fileName.getPath();
            if (type.equals("chest") && filePath.endsWith(CHEST_SUFFIX)) {
                WoodType.values().filter(wt -> wt.name().equals(filePath.substring(0, filePath.lastIndexOf(CHEST_SUFFIX)))).findFirst().ifPresent(wt -> {
                    EnumMap chestMaterials = new EnumMap(ChestType.class);
                    definition.getTextures().forEach((chestTypeName, textures) -> textures.forEach((textureName, rl) -> ChestMaterial.fromString(textureName).ifPresent(cm -> chestMaterials.computeIfAbsent(ChestType.valueOf((String)chestTypeName.toUpperCase(Locale.ROOT)), t -> new EnumMap(ChestMaterial.class)).put(cm, new Material(Sheets.CHEST_SHEET, rl)))));
                    this.woodChestMaterials.put((WoodType)wt, chestMaterials);
                });
            }
        });
        return fileContents;
    }

    private void clear() {
        this.woodChestMaterials.clear();
    }

    protected void apply(Map<Identifier, JsonElement> entries, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
    }

    public @Nullable Map<ChestMaterial, Material> getWoodChestMaterials(ChestType chestType, WoodType woodType) {
        Map<ChestType, Map<ChestMaterial, Material>> chestTypeMaterials = this.woodChestMaterials.getOrDefault(woodType, this.woodChestMaterials.get(defaultChestWoodType));
        return chestTypeMaterials == null ? null : chestTypeMaterials.get(chestType);
    }

    private Optional<StorageTextureDefinition> loadDefinition(Map<Identifier, StorageTextureDefinition> storageTextureDefinitions, Identifier identifier, JsonElement json, Map<Identifier, JsonElement> fileContents) {
        JsonElement parentJson;
        Identifier parent;
        if (storageTextureDefinitions.containsKey(identifier)) {
            return Optional.of(storageTextureDefinitions.get(identifier));
        }
        if (!json.isJsonObject()) {
            return Optional.empty();
        }
        JsonObject jsonContents = json.getAsJsonObject();
        String type = "";
        StorageTextureDefinition parentDefinition = null;
        if (jsonContents.has(PARENT_TAG) && jsonContents.get(PARENT_TAG).isJsonPrimitive() && (parentDefinition = (StorageTextureDefinition)this.loadDefinition(storageTextureDefinitions, parent = Identifier.parse((String)jsonContents.get(PARENT_TAG).getAsString()), parentJson = fileContents.get(parent), fileContents).orElse(null)) != null) {
            type = parentDefinition.getType();
        }
        if (jsonContents.has(TYPE_TAG) && jsonContents.get(TYPE_TAG).isJsonPrimitive()) {
            type = jsonContents.get(TYPE_TAG).getAsString();
        }
        if (!TEXTURE_PARSERS.containsKey(type)) {
            return Optional.empty();
        }
        ITextureParser textureParser = TEXTURE_PARSERS.get(type).get();
        if (parentDefinition != null) {
            textureParser.copyFromParentDefinition(parentDefinition);
        }
        Optional<StorageTextureDefinition> result = textureParser.parseDefinition(type, jsonContents);
        result.ifPresent(def -> storageTextureDefinitions.put(identifier, (StorageTextureDefinition)def));
        return result;
    }

    static {
        TEXTURE_PARSERS.put("chest", ChestTextureParser::new);
    }

    public static class StorageTextureDefinition {
        private static final String ALL_SIDES_TEXTURES = "allSides";
        private final String type;
        private final Map<String, Map<String, Map<String, Identifier>>> textures;

        public StorageTextureDefinition(String type, Map<String, Map<String, Map<String, Identifier>>> multiplePartTextures, boolean multipleTextureIgnoredParameter) {
            this.type = type;
            this.textures = multiplePartTextures;
        }

        public StorageTextureDefinition(String type, Map<String, Map<String, Identifier>> textures) {
            this.type = type;
            this.textures = new HashMap<String, Map<String, Map<String, Identifier>>>();
            this.textures.put(ALL_SIDES_TEXTURES, textures);
        }

        public String getType() {
            return this.type;
        }

        public Map<String, Map<String, Identifier>> getTextures() {
            return this.textures.getOrDefault(ALL_SIDES_TEXTURES, new HashMap());
        }
    }

    private static interface ITextureParser {
        public void copyFromParentDefinition(StorageTextureDefinition var1);

        public Optional<StorageTextureDefinition> parseDefinition(String var1, JsonObject var2);
    }

    public static enum ChestMaterial {
        BASE,
        WOOD_TIER,
        COPPER_TIER,
        IRON_TIER,
        GOLD_TIER,
        DIAMOND_TIER,
        NETHERITE_TIER,
        TINTABLE_MAIN,
        TINTABLE_ACCENT,
        PACKED;


        public static Optional<ChestMaterial> fromString(String materialName) {
            for (ChestMaterial value : ChestMaterial.values()) {
                if (!value.name().toLowerCase(Locale.ROOT).equals(materialName)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }

    private static class ChestTextureParser
    implements ITextureParser {
        private final Map<String, Map<String, Identifier>> textures = new HashMap<String, Map<String, Identifier>>();

        private ChestTextureParser() {
        }

        @Override
        public void copyFromParentDefinition(StorageTextureDefinition parentDefinition) {
            parentDefinition.getTextures().forEach((key, value) -> this.textures.put((String)key, new HashMap(value)));
        }

        @Override
        public Optional<StorageTextureDefinition> parseDefinition(String type, JsonObject jsonContents) {
            if (jsonContents.has(StorageTextureManager.TEXTURES_TAG) && jsonContents.get(StorageTextureManager.TEXTURES_TAG).isJsonObject()) {
                JsonObject jsonTextures = jsonContents.get(StorageTextureManager.TEXTURES_TAG).getAsJsonObject();
                jsonTextures.keySet().forEach(name -> jsonTextures.get(name).getAsJsonObject().entrySet().forEach(entry -> {
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        this.textures.computeIfAbsent((String)name, k -> new HashMap()).put((String)entry.getKey(), Identifier.parse((String)((JsonElement)entry.getValue()).getAsString()));
                    }
                }));
            }
            return Optional.of(new StorageTextureDefinition(type, this.textures));
        }
    }
}

