/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.util.ValueIOSerializable;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.settings.StorageSettingsHandler;
import org.jspecify.annotations.Nullable;

public abstract class StorageWrapper
implements IStorageWrapper,
ValueIOSerializable {
    public static final String MAIN_COLOR = "mainColor";
    public static final String ACCENT_COLOR = "accentColor";
    private static final String UUID = "uuid";
    private static final String OPEN_TAB_ID = "openTabId";
    public static final String CONTENTS = "contents";
    public static final String NUMBER_OF_INVENTORY_SLOTS = "numberOfInventorySlots";
    public static final String NUMBER_OF_UPGRADE_SLOTS = "numberOfUpgradeSlots";
    public static final String RENDER_DATA = "renderData";
    public static final String SORT_BY = "sortBy";
    private final Supplier<Runnable> getSaveHandler;
    private @Nullable InventoryHandler inventoryHandler = null;
    private @Nullable InventoryIOHandler inventoryIOHandler = null;
    private @Nullable UpgradeHandler upgradeHandler = null;
    private ContainerContents contents = new ContainerContents();
    private final SettingsHandler settingsHandler;
    private final RenderDataHandler renderDataHandler;
    private RenderData renderData = new RenderData();
    protected @Nullable UUID contentsUuid = null;
    private int openTabId = -1;
    protected int numberOfInventorySlots = 0;
    protected int numberOfUpgradeSlots = -1;
    private SortBy sortBy = SortBy.NAME;
    private int columnsTaken = 0;
    private int mainColor = -1;
    private int accentColor = -1;
    private Runnable upgradeCachesInvalidatedHandler = () -> {};
    private final Map<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>> upgradeDefaultsHandlers = new HashMap<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>>();
    private Runnable onInventoryForInputOutputHandlerRefresh = () -> {};

    protected StorageWrapper(Supplier<Runnable> getSaveHandler, Runnable onSerializeRenderData, Runnable markContentsDirty) {
        this(getSaveHandler, onSerializeRenderData, markContentsDirty, 1, false);
    }

    protected StorageWrapper(Supplier<Runnable> getSaveHandler, Runnable onSerializeRenderData, Runnable markContentsDirty, final int numberOfDisplayItems, boolean showsCountsAndFillRatios) {
        this.getSaveHandler = getSaveHandler;
        this.renderDataHandler = new RenderDataHandler(this.renderData, renderData -> {
            onSerializeRenderData.run();
            ((Runnable)getSaveHandler.get()).run();
        }, showsCountsAndFillRatios);
        this.settingsHandler = new StorageSettingsHandler(this, this.contents.settings(), markContentsDirty, this::getInventoryHandler, () -> this.renderDataHandler){

            @Override
            protected int getNumberOfDisplayItems() {
                return numberOfDisplayItems;
            }
        };
    }

    public void setContentsUuid(@Nullable UUID contentsUuid) {
        this.contentsUuid = contentsUuid;
    }

    public SettingsHandler getSettingsHandler() {
        return this.settingsHandler;
    }

    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = new UpgradeHandler(this.getNumberOfUpgradeSlots(), this, this.getContents(), this.getSaveHandler.get(), () -> {
                if (this.inventoryHandler != null) {
                    this.inventoryHandler.clearListeners();
                    this.inventoryHandler.setBaseSlotLimit(StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
                }
                this.getInventoryHandler().addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
                this.refreshInventoryForInputOutput();
                ((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
            }){

                public boolean isValid(int index, ItemResource resource) {
                    return super.isValid(index, resource) && (resource.isEmpty() || resource.is(ModItems.STORAGE_UPGRADE_TAG));
                }

                public void refreshUpgradeWrappers() {
                    super.refreshUpgradeWrappers();
                    StorageWrapper.this.onUpgradeRefresh();
                }
            };
            this.upgradeDefaultsHandlers.forEach(this::registerUpgradeDefaultsHandlerInUpgradeHandler);
        }
        return this.upgradeHandler;
    }

    private <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandlerInUpgradeHandler(Class<T> wrapperClass, Consumer<? extends IUpgradeWrapper> defaultsHandler) {
        this.upgradeHandler.registerUpgradeDefaultsHandler(wrapperClass, defaultsHandler);
    }

    public void setUpgradeCachesInvalidatedHandler(Runnable handler) {
        this.upgradeCachesInvalidatedHandler = handler;
    }

    protected abstract void onUpgradeRefresh();

    public void serialize(ValueOutput out) {
        this.saveContents(out);
        this.saveData(out);
    }

    private void saveContents(ValueOutput out) {
        out.store(CONTENTS, ContainerContents.CODEC, (Object)this.getContents().copy());
    }

    void saveClientData(ValueOutput out) {
        out.store("settings", ContainerContents.SettingsData.CODEC, (Object)this.contents.settings());
        this.saveData(out);
    }

    void saveData(ValueOutput out) {
        out.store(RENDER_DATA, RenderData.CODEC, (Object)this.renderData);
        if (this.contentsUuid != null) {
            out.store(UUID, UUIDUtil.CODEC, (Object)this.contentsUuid);
        }
        if (this.openTabId >= 0) {
            out.putInt(OPEN_TAB_ID, this.openTabId);
        }
        out.putString(SORT_BY, this.sortBy.getSerializedName());
        if (this.columnsTaken > 0) {
            out.putInt("columnsTaken", this.columnsTaken);
        }
        if (this.numberOfInventorySlots > 0) {
            out.putInt(NUMBER_OF_INVENTORY_SLOTS, this.numberOfInventorySlots);
        }
        if (this.numberOfUpgradeSlots > -1) {
            out.putInt(NUMBER_OF_UPGRADE_SLOTS, this.numberOfUpgradeSlots);
        }
        if (this.mainColor != -1) {
            out.putInt(MAIN_COLOR, this.mainColor);
        }
        if (this.accentColor != -1) {
            out.putInt(ACCENT_COLOR, this.accentColor);
        }
    }

    public void deserialize(ValueInput in) {
        this.loadContents(in);
        this.loadData(in);
        if (this.inventoryHandler != null) {
            this.initInventoryHandler();
        }
        if (this.upgradeHandler != null) {
            this.getUpgradeHandler().refreshUpgradeWrappers();
        }
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && this.getRenderDataHandler().getUpgradeItems().size() != this.getUpgradeHandler().size()) {
            this.getUpgradeHandler().setRenderUpgradeItems();
        }
    }

    public void loadClientData(ValueInput in) {
        in.read("settings", ContainerContents.SettingsData.CODEC).ifPresent(arg_0 -> ((ContainerContents.SettingsData)this.contents.settings()).reloadFrom(arg_0));
        this.settingsHandler.reloadFrom(this.contents.settings());
        this.loadData(in);
        if (this.inventoryHandler != null) {
            this.initInventoryHandler();
        }
        if (this.upgradeHandler != null) {
            this.getUpgradeHandler().refreshUpgradeWrappers();
        }
    }

    private void loadData(ValueInput in) {
        this.renderData = in.read(RENDER_DATA, RenderData.CODEC).or(() -> in.read("renderInfo", RenderData.CODEC)).orElse(RenderData.EMPTY.copy());
        this.renderDataHandler.reloadFrom(this.renderData);
        this.contentsUuid = in.read(UUID, UUIDUtil.CODEC).orElse(null);
        this.openTabId = in.getIntOr(OPEN_TAB_ID, -1);
        this.sortBy = in.read(SORT_BY, SortBy.CODEC).orElse(SortBy.NAME);
        this.columnsTaken = in.getIntOr("columnsTaken", 0);
        this.loadSlotNumbers(in);
        this.mainColor = in.getIntOr(MAIN_COLOR, -1);
        this.accentColor = in.getIntOr(ACCENT_COLOR, -1);
    }

    protected void loadSlotNumbers(ValueInput in) {
        this.numberOfInventorySlots = in.getIntOr(NUMBER_OF_INVENTORY_SLOTS, 0);
        this.numberOfUpgradeSlots = in.getIntOr(NUMBER_OF_UPGRADE_SLOTS, -1);
    }

    private void loadContents(ValueInput in) {
        this.readContainerContents(in).ifPresent(c -> {
            this.contents = c;
            this.onContentsUpdated();
        });
    }

    private Optional<ContainerContents> readContainerContents(ValueInput in) {
        return in.read(CONTENTS, ContainerContents.CODEC).map(contents -> {
            in.read("settings", CompoundTag.CODEC).ifPresent(settingsTag -> {
                CompoundTag settingsNbt = in.read("settings", CompoundTag.CODEC).orElse(new CompoundTag());
                contents.settings().reloadFrom(ContainerContents.LegacyDeserialization.deserializeSettingsData((CompoundTag)settingsNbt));
            });
            return contents;
        });
    }

    public void setContentsChangeHandler(Runnable contentsChangeHandler) {
    }

    public ITrackedContentsItemResourceHandler getInventoryForUpgradeProcessing() {
        return this.getInventoryHandler();
    }

    public InventoryHandler getInventoryHandler() {
        if (this.inventoryHandler == null) {
            this.initInventoryHandler();
        }
        return this.inventoryHandler;
    }

    private void initInventoryHandler() {
        this.inventoryHandler = new InventoryHandler(this.getNumberOfInventorySlots(), this, this.getContents(), this.getSaveHandler.get(), StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this), Config.SERVER.stackUpgrade){

            protected boolean isAllowed(ItemResource resource) {
                return StorageWrapper.this.isAllowedInStorage(resource);
            }
        };
        this.inventoryHandler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
        this.inventoryHandler.setShouldInsertIntoEmpty(this::emptyInventorySlotsAcceptItems);
    }

    protected boolean emptyInventorySlotsAcceptItems() {
        return true;
    }

    public ContainerContents getContents() {
        return this.contents;
    }

    public int getNumberOfInventorySlots() {
        if (this.numberOfInventorySlots > 0) {
            return this.numberOfInventorySlots;
        }
        this.numberOfInventorySlots = this.getDefaultNumberOfInventorySlots();
        this.save();
        return this.numberOfInventorySlots;
    }

    protected void save() {
        this.getSaveHandler.get().run();
    }

    public abstract int getDefaultNumberOfInventorySlots();

    protected abstract boolean isAllowedInStorage(ItemResource var1);

    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    public ITrackedContentsItemResourceHandler getInventoryForInputOutput() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler((IStorageWrapper)this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    private int getNumberOfUpgradeSlots() {
        if (this.numberOfUpgradeSlots >= this.getDefaultNumberOfUpgradeSlots()) {
            return this.numberOfUpgradeSlots;
        }
        this.numberOfUpgradeSlots = this.getDefaultNumberOfUpgradeSlots();
        this.save();
        return this.numberOfUpgradeSlots;
    }

    public abstract int getDefaultNumberOfUpgradeSlots();

    public int getMainColor() {
        return this.mainColor;
    }

    public boolean hasMainColor() {
        return this.mainColor != -1;
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public boolean hasAccentColor() {
        return this.accentColor != -1;
    }

    public Optional<Integer> getOpenTabId() {
        return this.openTabId >= 0 ? Optional.of(this.openTabId) : Optional.empty();
    }

    public void setOpenTabId(int openTabId) {
        this.openTabId = openTabId;
        this.save();
    }

    public void removeOpenTabId() {
        this.openTabId = -1;
        this.save();
    }

    public void setColors(int mainColor, int accentColor) {
        this.mainColor = mainColor;
        this.accentColor = accentColor;
        this.save();
    }

    public void setSortBy(SortBy sortBy) {
        this.sortBy = sortBy;
        this.save();
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public void sort() {
        HashSet slotIndexesExcludedFromSort = new HashSet();
        slotIndexesExcludedFromSort.addAll(((NoSortSettingsCategory)this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(((MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).getSlotIndexes());
        slotIndexesExcludedFromSort.addAll(this.getInventoryHandler().getNoSortSlots());
        InventorySorter.sortHandler((InventoryHandler)this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new MatchException(null, null);
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
            case SortBy.MOD -> InventorySorter.BY_MOD;
        };
    }

    public void onContentsUpdated() {
        this.inventoryHandler = null;
        this.upgradeHandler = null;
        this.settingsHandler.reloadFrom(this.contents.settings());
        this.refreshInventoryForUpgradeProcessing();
    }

    public void refreshInventoryForUpgradeProcessing() {
        this.refreshInventoryForInputOutput();
    }

    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
        this.upgradeCachesInvalidatedHandler.run();
        this.onInventoryForInputOutputHandlerRefresh.run();
    }

    public void registerOnInventoryInputOutputHandlerRefreshListener(Runnable onInventoryForInputOutputHandlerRefresh) {
        this.onInventoryForInputOutputHandlerRefresh = onInventoryForInputOutputHandlerRefresh;
    }

    public void setPersistent(boolean persistent) {
    }

    public void fillWithLoot(Player playerEntity) {
    }

    public RenderDataHandler getRenderDataHandler() {
        return this.renderDataHandler;
    }

    public void setColumnsTaken(int columnsTaken, boolean hasChanged) {
        this.columnsTaken = columnsTaken;
        this.save();
    }

    public int getColumnsTaken() {
        return this.columnsTaken;
    }

    public void changeSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        this.numberOfInventorySlots += additionalInventorySlots;
        this.numberOfUpgradeSlots += additionalUpgradeSlots;
        this.save();
        this.onContentsUpdated();
    }

    public <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandler(Class<T> upgradeClass, Consumer<T> defaultsHandler) {
        this.upgradeDefaultsHandlers.put(upgradeClass, defaultsHandler);
    }
}

