/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.p3pp3rf1y.sophisticatedcore.controller.ControllerBlockEntityBase;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jspecify.annotations.Nullable;

public class StorageLinkBlockEntity
extends BlockEntity
implements ILinkable {
    private @Nullable BlockPos controllerPos = null;
    private boolean chunkBeingUnloaded = false;

    public StorageLinkBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.STORAGE_LINK_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    protected void saveAdditional(ValueOutput out) {
        super.saveAdditional(out);
        this.saveControllerPos(out);
    }

    public void loadAdditional(ValueInput in) {
        super.loadAdditional(in);
        this.loadControllerPos(in);
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.setChanged();
    }

    public BlockPos getStorageBlockPos() {
        return this.getBlockPos();
    }

    public Level getStorageBlockLevel() {
        return Objects.requireNonNull(this.getLevel());
    }

    public boolean canConnectStorages() {
        return true;
    }

    public boolean canBeConnected() {
        return false;
    }

    public void registerController(ControllerBlockEntityBase controllerBlockEntity) {
        this.setControllerPos(controllerBlockEntity.getBlockPos());
    }

    public void unregisterController() {
        this.removeControllerPos();
    }

    public Set<BlockPos> getConnectablePositions() {
        return Collections.singleton(this.getBlockPos().offset(((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite().getUnitVec3i()));
    }

    public boolean connectLinkedSelf() {
        return false;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.setChanged();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public boolean isLinked() {
        return this.getControllerPos().isPresent();
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void setRemoved() {
        if (!this.chunkBeingUnloaded && this.level != null) {
            this.unlinkFromController();
        }
        super.setRemoved();
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        super.preRemoveSideEffects(pos, state);
        this.unlinkFromController();
    }
}

