/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageIOBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import org.jspecify.annotations.Nullable;

public class StorageInputBlockEntity
extends StorageIOBlockEntity {
    private @Nullable ResourceHandler<ItemResource> itemResourceHandler;

    public StorageInputBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.STORAGE_INPUT_BLOCK_ENTITY_TYPE.get(), pos, state);
    }

    @Override
    public @Nullable ResourceHandler<ItemResource> getExternalItemResourceHandler(@Nullable Direction side) {
        if (this.getControllerPos().isEmpty()) {
            return null;
        }
        if (this.itemResourceHandler == null) {
            ResourceHandler<ItemResource> handler = super.getExternalItemResourceHandler(null);
            if (handler == null) {
                return null;
            }
            this.itemResourceHandler = new SingleSlotInputItemResourceHandlerWrapper(handler);
        }
        return this.itemResourceHandler;
    }

    @Override
    protected void invalidateItemHandlerCache() {
        super.invalidateItemHandlerCache();
        this.itemResourceHandler = null;
    }

    private static class SingleSlotInputItemResourceHandlerWrapper
    implements ResourceHandler<ItemResource> {
        private final ResourceHandler<ItemResource> itemResourceHandler;

        public SingleSlotInputItemResourceHandlerWrapper(ResourceHandler<ItemResource> itemResourceHandler) {
            this.itemResourceHandler = itemResourceHandler;
        }

        public int size() {
            return 1;
        }

        public ItemResource getResource(int slot) {
            return ItemResource.EMPTY;
        }

        public long getAmountAsLong(int slot) {
            return 0L;
        }

        public long getCapacityAsLong(int slot, ItemResource itemResource) {
            return 99L;
        }

        public boolean isValid(int slot, ItemResource itemResource) {
            return true;
        }

        public int insert(int slot, ItemResource itemResource, int amount, TransactionContext transaction) {
            return 0;
        }

        public int insert(ItemResource itemResource, int amount, TransactionContext transaction) {
            return this.itemResourceHandler.insert((Resource)itemResource, amount, transaction);
        }

        public int extract(int slot, ItemResource itemResource, int amount, TransactionContext transaction) {
            return this.itemResourceHandler.insert(slot, (Resource)itemResource, amount, transaction);
        }
    }
}

