/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ValueIOHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.IAdditionalDropDataBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.ItemContentsStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.client.particle.CustomTintTerrainParticleData;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageToolItem;
import org.jspecify.annotations.Nullable;

public class ShulkerBoxBlock
extends StorageBlockBase
implements IAdditionalDropDataBlock {
    public static final EnumProperty<Direction> FACING = DirectionalBlock.FACING;
    private static final VoxelShape ITEM_ENTITY_COLLISION_SHAPE = ShulkerBoxBlock.box((double)0.05, (double)0.05, (double)0.05, (double)15.95, (double)15.95, (double)15.95);

    public ShulkerBoxBlock(Config.Server.StorageConfig config, BlockBehaviour.Properties properties) {
        this(config, 2.0f, properties);
    }

    public ShulkerBoxBlock(Config.Server.StorageConfig config, float explosionResistance, BlockBehaviour.Properties properties) {
        super(ShulkerBoxBlock.setProperties(explosionResistance, properties), config::numberOfInventorySlots, config::numberOfUpgradeSlots);
    }

    private static BlockBehaviour.Properties setProperties(float explosionResistance, BlockBehaviour.Properties properties) {
        BlockBehaviour.StatePredicate statePredicate = (state, blockGetter, pos) -> {
            BlockEntity blockentity = blockGetter.getBlockEntity(pos);
            if (!(blockentity instanceof ShulkerBoxBlockEntity)) {
                return true;
            }
            ShulkerBoxBlockEntity shulkerboxblockentity = (ShulkerBoxBlockEntity)blockentity;
            return shulkerboxblockentity.isClosed();
        };
        return properties.strength(2.0f, explosionResistance).forceSolidOn().dynamicShape().noOcclusion().isSuffocating(statePredicate).isViewBlocking(statePredicate).pushReaction(PushReaction.DESTROY).mapColor(DyeColor.PURPLE);
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ShulkerBoxBlock.createTickerHelper(blockEntityType, ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE.get(), (l, pos, s, blockEntity) -> {
            ShulkerBoxBlockEntity.tick(l, pos, s, blockEntity);
            if (!l.isClientSide()) {
                StorageBlockEntity.serverTick(l, pos, blockEntity);
            }
        });
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ShulkerBoxBlockEntity shulkerBoxBlockEntity;
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (player.isSpectator()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ShulkerBoxBlockEntity) || !ShulkerBoxBlock.canOpen(state, level, pos, shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockEntity)) {
            return InteractionResult.FAIL;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(b -> {
            InteractionResult result = this.tryItemInteraction(player, (StorageBlockEntity)b, player.getItemInHand(hand), this.getFacing(state), hitResult);
            if (result.consumesAction()) {
                return result;
            }
            return InteractionResult.TRY_WITH_EMPTY_HAND;
        }).orElse((InteractionResult)InteractionResult.TRY_WITH_EMPTY_HAND);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        ShulkerBoxBlockEntity shulkerBoxBlockEntity;
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        if (player.isSpectator()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof ShulkerBoxBlockEntity) || !ShulkerBoxBlock.canOpen(state, level, pos, shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockEntity)) {
            return InteractionResult.PASS;
        }
        player.awardStat(Stats.CUSTOM.get((Object)Stats.OPEN_SHULKER_BOX));
        player.openMenu((MenuProvider)new SimpleMenuProvider((w, p, pl) -> new StorageContainerMenu(w, pl, pos), WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).map(StorageBlockEntity::getDisplayName).orElse((Component)Component.empty())), pos);
        Level level2 = player.level();
        if (level2 instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            PiglinAi.angerNearbyPiglins((ServerLevel)serverLevel, (Player)player, (boolean)true);
        }
        return InteractionResult.CONSUME;
    }

    private InteractionResult tryItemInteraction(Player player, StorageBlockEntity b, ItemStack itemInHand, Direction facing, BlockHitResult hitResult) {
        return this.tryAddUpgrade(player, b, itemInHand, facing, hitResult);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, StorageBlockEntity.class).ifPresent(be -> {
            Item patt0$temp;
            UUID storageUuid = (UUID)stack.get(ModCoreDataComponents.STORAGE_UUID);
            if (storageUuid != null) {
                ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
                CompoundTag beTag = itemContentsStorage.getOrCreateAddtionalBeData(storageUuid);
                ContainerContents contents = itemContentsStorage.getOrCreateContents(storageUuid);
                Tag contentsTag = (Tag)ContainerContents.CODEC.encodeStart((DynamicOps)RegistryOps.create((DynamicOps)NbtOps.INSTANCE, (HolderLookup.Provider)be.getLevel().registryAccess()), (Object)contents).getOrThrow();
                beTag.getCompound("storageWrapper").ifPresent(tag -> tag.put("contents", contentsTag));
                be.loadAdditional(ValueIOHelper.inputFromCompoundTag((HolderLookup.Provider)level.registryAccess(), (CompoundTag)beTag));
                itemContentsStorage.removeContents(storageUuid);
                itemContentsStorage.removeAddtionalBeData(storageUuid);
            }
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                be.setCustomName((Component)stack.get(DataComponents.CUSTOM_NAME));
            }
            if ((patt0$temp = stack.getItem()) instanceof ShulkerBoxItem) {
                ShulkerBoxItem shulkerBoxItem = (ShulkerBoxItem)patt0$temp;
                StorageWrapper storageWrapper = be.getStorageWrapper();
                storageWrapper.setColors(shulkerBoxItem.getMainColor(stack).orElse(-1), shulkerBoxItem.getAccentColor(stack).orElse(-1));
                InventoryHandler inventoryHandler = storageWrapper.getInventoryHandler();
                UpgradeHandler upgradeHandler = storageWrapper.getUpgradeHandler();
                storageWrapper.changeSize(shulkerBoxItem.getNumberOfInventorySlots((HolderLookup.Provider)level.registryAccess(), stack) - inventoryHandler.size(), shulkerBoxItem.getNumberOfUpgradeSlots((HolderLookup.Provider)level.registryAccess(), stack) - upgradeHandler.size());
            }
            be.getStorageWrapper().onInit();
            be.tryToAddToController();
            if (placer != null && placer.getOffhandItem().getItem() == ModItems.STORAGE_TOOL.get()) {
                StorageToolItem.useOffHandOnPlaced(placer.getOffhandItem(), be);
            }
            be.setChanged();
        });
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        itemConsumer.accept(new ItemStack((ItemLike)this));
        if (this == ModBlocks.SHULKER_BOX.get() || !Config.CLIENT_SPEC.isLoaded() || ((Boolean)Config.CLIENT.showHigherTierTintedVariants.get()).booleanValue()) {
            for (DyeColor color : DyeColor.values()) {
                ItemStack storageStack = this.getTintedStack(color);
                itemConsumer.accept(storageStack);
            }
            ItemStack storageStack = new ItemStack((ItemLike)this);
            Item item = storageStack.getItem();
            if (item instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                tintableBlockItem.setMainColor(storageStack, DyeColor.YELLOW.getTextureDiffuseColor());
                tintableBlockItem.setAccentColor(storageStack, DyeColor.LIME.getTextureDiffuseColor());
            }
            itemConsumer.accept(storageStack);
        }
    }

    public ItemStack getTintedStack(DyeColor color) {
        ItemStack storageStack = new ItemStack((ItemLike)this);
        Item item = storageStack.getItem();
        if (item instanceof ITintableBlockItem) {
            ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
            tintableBlockItem.setMainColor(storageStack, color.getTextureDiffuseColor());
            tintableBlockItem.setAccentColor(storageStack, color.getTextureDiffuseColor());
        }
        return storageStack;
    }

    private static boolean canOpen(BlockState state, Level level, BlockPos pos, ShulkerBoxBlockEntity blockEntity) {
        if (blockEntity.getAnimationStatus() != ShulkerBoxBlockEntity.AnimationStatus.CLOSED) {
            return true;
        }
        AABB aabb = Shulker.getProgressDeltaAabb((float)1.0f, (Direction)((Direction)state.getValue(FACING)), (float)0.0f, (float)0.5f, (Vec3)pos.getBottomCenter()).move(pos).deflate(1.0E-6);
        return level.noCollision(aabb);
    }

    @Override
    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockentity;
            if (!level.isClientSide() && player.isCreative() && this.hasAnyItems(shulkerBoxBlockEntity)) {
                ItemStack shulkerBoxDrop = new ItemStack((ItemLike)this);
                this.addShulkerContentsToStack(shulkerBoxDrop, shulkerBoxBlockEntity);
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, shulkerBoxDrop);
                itementity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itementity);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    private boolean hasAnyItems(ShulkerBoxBlockEntity shulkerBoxBlockEntity) {
        if (!ResourceHandlerUtil.isEmpty((ResourceHandler)shulkerBoxBlockEntity.getStorageWrapper().getInventoryHandler())) {
            return true;
        }
        return !ResourceHandlerUtil.isEmpty((ResourceHandler)shulkerBoxBlockEntity.getStorageWrapper().getUpgradeHandler());
    }

    @Override
    public void addDropData(ItemStack stack, StorageBlockEntity be) {
        this.addShulkerContentsToStack(stack, be);
    }

    private void addShulkerContentsToStack(ItemStack stack, StorageBlockEntity be) {
        StorageWrapper storageWrapper = be.getStorageWrapper();
        UUID shulkerBoxUuid = storageWrapper.getContentsUuid().orElse(UUID.randomUUID());
        CompoundTag additionalBeData = be.saveWithoutMetadata((HolderLookup.Provider)be.getLevel().registryAccess());
        ContainerContents contents = be.getStorageWrapper().getContents().copy();
        additionalBeData.getCompound("storageWrapper").ifPresent(tag -> tag.remove("contents"));
        additionalBeData.remove("controllerPos");
        ItemContentsStorage itemContentsStorage = ItemContentsStorage.get();
        itemContentsStorage.setContents(shulkerBoxUuid, contents);
        if (!additionalBeData.isEmpty()) {
            itemContentsStorage.setAdditionalBeData(shulkerBoxUuid, additionalBeData);
            stack.set(ModCoreDataComponents.STORAGE_UUID, (Object)shulkerBoxUuid);
        }
        this.addBasicPropertiesToStack(stack, be, storageWrapper);
        StorageBlockItem.setShowsTier(stack, be.shouldShowTier());
    }

    private void addBasicPropertiesToStack(ItemStack stack, StorageBlockEntity be, StorageWrapper storageWrapper) {
        Item item;
        if (be.hasCustomName()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)be.getCustomName());
        }
        if ((item = stack.getItem()) instanceof ShulkerBoxItem) {
            int accentColor;
            ShulkerBoxItem shulkerBoxItem = (ShulkerBoxItem)item;
            int mainColor = storageWrapper.getMainColor();
            if (mainColor != -1) {
                shulkerBoxItem.setMainColor(stack, mainColor);
            }
            if ((accentColor = storageWrapper.getAccentColor()) != -1) {
                shulkerBoxItem.setAccentColor(stack, accentColor);
            }
            StorageBlockItem.setNumberOfInventorySlots(stack, storageWrapper.getInventoryHandler().size());
            StorageBlockItem.setNumberOfUpgradeSlots(stack, storageWrapper.getUpgradeHandler().size());
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape voxelShape;
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)blockentity;
            voxelShape = Shapes.create((AABB)shulkerBoxBlockEntity.getBoundingBox(state));
        } else {
            voxelShape = Shapes.block();
        }
        return voxelShape;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack stack = super.getCloneItemStack(level, pos, state, includeData);
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ShulkerBoxBlockEntity.class).ifPresent(be -> {
            if (includeData) {
                this.addShulkerContentsToStack(stack, (StorageBlockEntity)be);
            } else {
                StorageWrapper storageWrapper = be.getStorageWrapper();
                this.addBasicPropertiesToStack(stack, (StorageBlockEntity)be, storageWrapper);
            }
        });
        return stack;
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation rotation) {
        return (BlockState)state.setValue(FACING, (Comparable)rotation.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return this.rotate(state, mirror.getRotation((Direction)state.getValue(FACING)));
    }

    @Override
    public void setTicking(Level level, BlockPos pos, BlockState currentState, boolean ticking) {
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Override
    public StorageBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ShulkerBoxBlockEntity(pos, state);
    }

    @Override
    protected BlockEntityType<? extends StorageBlockEntity> getBlockEntityType() {
        return ModBlocks.SHULKER_BOX_BLOCK_ENTITY_TYPE.get();
    }

    @Override
    public Direction getFacing(BlockState state) {
        return (Direction)state.getValue(FACING);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCollisionContext;
        return context instanceof EntityCollisionContext && (entityCollisionContext = (EntityCollisionContext)context).getEntity() instanceof ItemEntity ? ITEM_ENTITY_COLLISION_SHAPE : super.getCollisionShape(state, level, pos, context);
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean addLandingEffects(BlockState state1, ServerLevel level, BlockPos pos, BlockState state2, LivingEntity entity, int numberOfParticles) {
        level.sendParticles((ParticleOptions)new CustomTintTerrainParticleData(state1, pos), entity.getX(), entity.getY(), entity.getZ(), numberOfParticles, 0.0, 0.0, 0.0, 0.15);
        return true;
    }

    public boolean addRunningEffects(BlockState state, Level level, BlockPos pos, Entity entity) {
        Vec3 vec3 = entity.getDeltaMovement();
        level.addParticle((ParticleOptions)new CustomTintTerrainParticleData(state, pos), entity.getX() + (level.random.nextDouble() - 0.5) * (double)entity.getBbWidth(), entity.getY() + 0.1, entity.getZ() + (level.random.nextDouble() - 0.5) * (double)entity.getBbWidth(), vec3.x * -4.0, 1.5, vec3.z * -4.0);
        return true;
    }
}

