/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.StreamCodecHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class LimitedBarrelBlockEntity
extends BarrelBlockEntity
implements ICountDisplay,
IFillLevelDisplay {
    public static final Codec<Map<Integer, DyeColor>> SLOT_COLORS_CODEC = Codec.unboundedMap((Codec)CodecHelper.STRING_ENCODED_INT, (Codec)DyeColor.CODEC);
    public static final StreamCodec<FriendlyByteBuf, Map<Integer, DyeColor>> SLOT_COLORS_STREAM_CODEC = StreamCodecHelper.ofMap((StreamCodec)ByteBufCodecs.INT, (StreamCodec)DyeColor.STREAM_CODEC, HashMap::new);
    public static final Consumer<VoidUpgradeWrapper> VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT = voidUpgrade -> {
        voidUpgrade.getFilterLogic().setAllowByDefault(false);
        voidUpgrade.setShouldVoidOverflowDefaultOrLoadFromNbt(true);
    };
    public static final String STORAGE_TYPE = "limited_barrel";
    private long lastDepositTime = -100L;
    private Map<Integer, DyeColor> slotColors = new HashMap<Integer, DyeColor>();
    private boolean showCounts = true;
    private boolean showFillLevels = false;
    private boolean useLightInFrontForFrontRender = true;

    public LimitedBarrelBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, (BlockEntityType<? extends BarrelBlockEntity>)ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE.get());
        this.registerUpgradeDefaults();
    }

    public void setUseLightInFrontForFrontRender(boolean useLightInFrontForFrontRender) {
        this.useLightInFrontForFrontRender = useLightInFrontForFrontRender;
    }

    public boolean shouldUseLightInFrontForFrontRender() {
        return this.useLightInFrontForFrontRender;
    }

    public static void setFixedSettings(IStorageWrapper storageWrapper, int numberOfInventorySlots) {
        NoSortSettingsCategory noSortSettingsCategory;
        SettingsHandler settingsHandler = storageWrapper.getSettingsHandler();
        ItemDisplaySettingsCategory itemDisplaySettingsCategory = (ItemDisplaySettingsCategory)settingsHandler.getTypeCategory(ItemDisplaySettingsCategory.class);
        if (itemDisplaySettingsCategory.getSlots().size() != numberOfInventorySlots) {
            itemDisplaySettingsCategory.selectSlots(0, numberOfInventorySlots);
        }
        if ((noSortSettingsCategory = (NoSortSettingsCategory)settingsHandler.getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots().size() != numberOfInventorySlots) {
            noSortSettingsCategory.selectSlots(0, numberOfInventorySlots);
        }
    }

    private void registerUpgradeDefaults() {
        this.getStorageWrapper().registerUpgradeDefaultsHandler(VoidUpgradeWrapper.class, VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT);
    }

    @Override
    public boolean shouldShowCounts() {
        return this.showCounts;
    }

    @Override
    public boolean memorizesItemsWhenLocked() {
        return true;
    }

    @Override
    public boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return false;
    }

    @Override
    public void toggleCountVisibility() {
        this.showCounts = !this.showCounts;
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public List<Integer> getSlotCounts() {
        return this.getStorageWrapper().getRenderDataHandler().getDisplayData().slotCounts();
    }

    @Override
    public boolean shouldShowFillLevels() {
        return this.showFillLevels;
    }

    @Override
    public void toggleFillLevelVisibility() {
        this.showFillLevels = !this.showFillLevels;
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public List<Float> getSlotFillLevels() {
        return this.getStorageWrapper().getRenderDataHandler().getDisplayData().slotFillRatios();
    }

    public boolean applyDye(int slot, ItemStack dyeStack, DyeColor dyeColor, boolean applyToAll) {
        if (slot < 0 || slot >= this.getStorageWrapper().getInventoryHandler().size()) {
            return false;
        }
        StorageWrapper storageWrapper = this.getStorageWrapper();
        InventoryHandler invHandler = storageWrapper.getInventoryHandler();
        if (applyToAll) {
            boolean success = false;
            for (int i = 0; i < invHandler.size(); ++i) {
                success |= this.applyDye(i, dyeColor, invHandler);
            }
            if (!success) {
                return false;
            }
        } else if (!this.applyDye(slot, dyeColor, invHandler)) {
            return false;
        }
        this.setChanged();
        dyeStack.shrink(1);
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
        return true;
    }

    private boolean applyDye(int slot, DyeColor dyeColor, InventoryHandler invHandler) {
        if (invHandler.getResource(slot).isEmpty() || dyeColor.equals((Object)this.slotColors.get(slot))) {
            return false;
        }
        this.slotColors.put(slot, dyeColor);
        return true;
    }

    public int getSlotColor(int slot) {
        return this.slotColors.getOrDefault(slot, DyeColor.WHITE).getTextColor();
    }

    public boolean depositItem(Player player, InteractionHand hand, ItemStack stackInHand, int slot) {
        long gameTime = this.getLevel().getGameTime();
        boolean doubleClick = gameTime - this.lastDepositTime < 10L;
        this.lastDepositTime = gameTime;
        StorageWrapper storageWrapper = this.getStorageWrapper();
        InventoryHandler invHandler = storageWrapper.getInventoryHandler();
        ItemResource resourceInSlot = invHandler.getResource(slot);
        MemorySettingsCategory memorySettings = (MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
        if (doubleClick) {
            return this.depositFromAllOfPlayersInventory(player, slot, invHandler, resourceInSlot, memorySettings);
        }
        if (resourceInSlot.isEmpty()) {
            if (invHandler.isItemValid(slot, stackInHand, player)) {
                int stackLimit = invHandler.getCapacityAsInt(slot, (Resource)ItemResource.of((ItemStack)stackInHand));
                invHandler.setStackInSlot(slot, stackInHand.split(stackLimit));
                if (this.isLocked()) {
                    memorySettings.selectSlot(slot);
                }
                if (stackInHand.isEmpty()) {
                    player.setItemInHand(hand, ItemStack.EMPTY);
                }
                return true;
            }
        } else {
            ItemStack result = invHandler.insertItemOnlyToSlot(slot, stackInHand);
            if (result.getCount() != stackInHand.getCount()) {
                if (this.isLocked()) {
                    memorySettings.selectSlot(slot);
                }
                player.setItemInHand(hand, result);
                return true;
            }
        }
        return false;
    }

    private boolean depositFromAllOfPlayersInventory(Player player, int slot, InventoryHandler invHandler, ItemResource itemResource, MemorySettingsCategory memorySettings) {
        AtomicBoolean success = new AtomicBoolean(false);
        Predicate<ItemStack> memoryItemMatches = itemStack -> memorySettings.isSlotSelected(slot) && memorySettings.matchesFilter(slot, itemStack);
        InventoryHelper.iteratePlayerInventory((Player)player, (playerSlot, playerStack) -> {
            ItemStack result;
            if ((itemResource.isEmpty() && (memoryItemMatches.test((ItemStack)playerStack) || invHandler.isFilterItem(playerStack.getItem())) || !playerStack.isEmpty() && itemResource.matches(playerStack)) && (result = invHandler.insertItemOnlyToSlot(slot, playerStack)).getCount() < playerStack.getCount()) {
                int toExtract = playerStack.getCount() - result.getCount();
                player.getInventory().removeItem(playerSlot.intValue(), toExtract);
                success.set(true);
            }
        });
        return success.get();
    }

    boolean tryToTakeItem(Player player, int slot) {
        InventoryHandler inventoryHandler = this.getStorageWrapper().getInventoryHandler();
        ItemResource resourceInSlot = inventoryHandler.getResource(slot);
        if (resourceInSlot.isEmpty()) {
            return false;
        }
        int countToTake = player.isShiftKeyDown() ? Math.min(resourceInSlot.getMaxStackSize(), inventoryHandler.getAmountAsInt(slot)) : 1;
        try (Transaction tx = Transaction.openRoot();){
            ItemStack stackTaken = resourceInSlot.toStack(inventoryHandler.extract(slot, resourceInSlot, countToTake, (TransactionContext)tx));
            if (player.getInventory().add(stackTaken)) {
                this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne((RandomSource)this.getLevel().random) * 0.7f + 1.0f) * 2.0f);
            } else {
                player.drop(stackTaken, false);
            }
            tx.commit();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    void updateOpenBlockState(BlockState state, boolean open) {
    }

    @Override
    public void onLoad() {
        super.onLoad();
        SettingsHandler settingsHandler = this.getStorageWrapper().getSettingsHandler();
        ((MemorySettingsCategory)settingsHandler.getTypeCategory(MemorySettingsCategory.class)).setIgnoreNbt(false);
        LimitedBarrelBlockEntity.setFixedSettings(this.getStorageWrapper(), this.getStorageWrapper().getNumberOfInventorySlots());
    }

    @Override
    public void loadSynchronizedData(ValueInput in) {
        super.loadSynchronizedData(in);
        this.showCounts = in.getBooleanOr("showCounts", true);
        this.showFillLevels = in.getBooleanOr("showFillLevels", false);
        this.slotColors = in.read("slotColors", SLOT_COLORS_CODEC).orElseGet(HashMap::new);
    }

    @Override
    public void loadAdditional(ValueInput out) {
        super.loadAdditional(out);
        if (this.level == null || !this.level.isClientSide()) {
            LimitedBarrelBlockEntity.setFixedSettings(this.getStorageWrapper(), this.getStorageWrapper().getNumberOfInventorySlots());
        }
    }

    @Override
    protected void saveSynchronizedData(ValueOutput out) {
        super.saveSynchronizedData(out);
        if (!this.showCounts) {
            out.putBoolean("showCounts", this.showCounts);
        }
        if (this.showFillLevels) {
            out.putBoolean("showFillLevels", this.showFillLevels);
        }
        if (!this.slotColors.isEmpty()) {
            out.store("slotColors", SLOT_COLORS_CODEC, this.slotColors);
        }
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }

    @Override
    public float getSlotFillPercentage(int slot) {
        return slot < this.getSlotFillLevels().size() ? this.getSlotFillLevels().get(slot).floatValue() : 0.0f;
    }
}

