/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.IMaterialHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.SophisticatedOpenersCounter;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.common.gui.StorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;

public class BarrelBlockEntity
extends WoodStorageBlockEntity
implements IMaterialHolder {
    public static final String MATERIALS = "materials";
    public static final String STORAGE_TYPE = "barrel";
    private Map<BarrelMaterial, Identifier> materials = new EnumMap<BarrelMaterial, Identifier>(BarrelMaterial.class);
    private final SophisticatedOpenersCounter openersCounter = new SophisticatedOpenersCounter(){

        protected void onOpen(Level level, BlockPos pos, BlockState state) {
            BarrelBlockEntity.this.playSound(state, SoundEvents.BARREL_OPEN);
            BarrelBlockEntity.this.updateOpenBlockState(state, true);
        }

        protected void onClose(Level level, BlockPos pos, BlockState state) {
            BarrelBlockEntity.this.playSound(state, SoundEvents.BARREL_CLOSE);
            BarrelBlockEntity.this.updateOpenBlockState(state, false);
        }

        protected void openerCountChanged(Level level, BlockPos pos, BlockState state, int previousOpenerCount, int newOpenerCount) {
        }

        public boolean isOwnContainer(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof StorageContainerMenu) {
                StorageContainerMenu storageContainerMenu = (StorageContainerMenu)abstractContainerMenu;
                return storageContainerMenu.getStorageBlockEntity() == BarrelBlockEntity.this;
            }
            return false;
        }
    };

    @Override
    public SophisticatedOpenersCounter getOpenersCounter() {
        return this.openersCounter;
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }

    protected BarrelBlockEntity(BlockPos pos, BlockState state, BlockEntityType<? extends BarrelBlockEntity> blockEntityType) {
        super(pos, state, blockEntityType);
        this.getStorageWrapper().getRenderDataHandler().setDisplayItemsChangeListener(ri -> WorldHelper.notifyBlockUpdate((BlockEntity)this));
    }

    public BarrelBlockEntity(BlockPos pos, BlockState state) {
        this(pos, state, (BlockEntityType<? extends BarrelBlockEntity>)ModBlocks.BARREL_BLOCK_ENTITY_TYPE.get());
    }

    void updateOpenBlockState(BlockState state, boolean open) {
        if (this.level == null) {
            return;
        }
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    @Override
    public void toggleLock() {
        this.setUpdateBlockRender();
        super.toggleLock();
    }

    @Override
    protected void saveSynchronizedData(ValueOutput out) {
        super.saveSynchronizedData(out);
        out.store(MATERIALS, BarrelBlockItem.MATERIALS_CODEC, this.materials);
    }

    @Override
    public void loadSynchronizedData(ValueInput in) {
        super.loadSynchronizedData(in);
        this.materials = in.read(MATERIALS, BarrelBlockItem.MATERIALS_CODEC).orElse(Map.of());
    }

    @Override
    public void setMaterials(Map<BarrelMaterial, Identifier> materials) {
        this.materials = materials;
        this.setChanged();
    }

    @Override
    public Map<BarrelMaterial, Identifier> getMaterials() {
        return this.materials;
    }

    @Override
    public boolean canHoldMaterials() {
        return true;
    }
}

