/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilteredUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeGroup;
import net.p3pp3rf1y.sophisticatedcore.upgrades.alchemy.AlchemyUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.AutoCookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.CookingUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.cooking.ICookingUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.magnet.MagnetUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pump.PumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.xppump.XpPumpUpgradeConfig;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.compression.CompressionUpgradeConfig;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeConfig;
import org.apache.commons.lang3.tuple.Pair;
import org.jspecify.annotations.Nullable;

public class Config {
    private static final String MAX_UPGRADES_MATCHER = "([a-z0-9_]+\\|[a-z0-9_/.-]+\\|\\d+)";
    public static final Client CLIENT;
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Server SERVER;
    public static final ModConfigSpec SERVER_SPEC;
    public static final Common COMMON;
    public static final ModConfigSpec COMMON_SPEC;

    private Config() {
    }

    static {
        Pair serverSpec = new ModConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ModConfigSpec)serverSpec.getRight();
        SERVER = (Server)serverSpec.getLeft();
        Pair clientSpec = new ModConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ModConfigSpec)clientSpec.getRight();
        CLIENT = (Client)clientSpec.getLeft();
        Pair commonSpec = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)commonSpec.getRight();
        COMMON = (Common)commonSpec.getLeft();
    }

    public static class Server {
        public final StorageConfig woodBarrel;
        public final StorageConfig copperBarrel;
        public final StorageConfig ironBarrel;
        public final StorageConfig goldBarrel;
        public final StorageConfig diamondBarrel;
        public final StorageConfig netheriteBarrel;
        public final LimitedBarrelConfig limitedBarrel1;
        public final LimitedBarrelConfig copperLimitedBarrel1;
        public final LimitedBarrelConfig ironLimitedBarrel1;
        public final LimitedBarrelConfig goldLimitedBarrel1;
        public final LimitedBarrelConfig diamondLimitedBarrel1;
        public final LimitedBarrelConfig netheriteLimitedBarrel1;
        public final LimitedBarrelConfig limitedBarrel2;
        public final LimitedBarrelConfig copperLimitedBarrel2;
        public final LimitedBarrelConfig ironLimitedBarrel2;
        public final LimitedBarrelConfig goldLimitedBarrel2;
        public final LimitedBarrelConfig diamondLimitedBarrel2;
        public final LimitedBarrelConfig netheriteLimitedBarrel2;
        public final LimitedBarrelConfig limitedBarrel3;
        public final LimitedBarrelConfig copperLimitedBarrel3;
        public final LimitedBarrelConfig ironLimitedBarrel3;
        public final LimitedBarrelConfig goldLimitedBarrel3;
        public final LimitedBarrelConfig diamondLimitedBarrel3;
        public final LimitedBarrelConfig netheriteLimitedBarrel3;
        public final LimitedBarrelConfig limitedBarrel4;
        public final LimitedBarrelConfig copperLimitedBarrel4;
        public final LimitedBarrelConfig ironLimitedBarrel4;
        public final LimitedBarrelConfig goldLimitedBarrel4;
        public final LimitedBarrelConfig diamondLimitedBarrel4;
        public final LimitedBarrelConfig netheriteLimitedBarrel4;
        public final StorageConfig woodChest;
        public final StorageConfig copperChest;
        public final StorageConfig ironChest;
        public final StorageConfig goldChest;
        public final StorageConfig diamondChest;
        public final StorageConfig netheriteChest;
        public final StorageConfig shulkerBox;
        public final StorageConfig copperShulkerBox;
        public final StorageConfig ironShulkerBox;
        public final StorageConfig goldShulkerBox;
        public final StorageConfig diamondShulkerBox;
        public final StorageConfig netheriteShulkerBox;
        public final ShulkerBoxDisallowedItems shulkerBoxDisallowedItems;
        public final StackUpgradeConfig stackUpgrade;
        public final FilteredUpgradeConfig compactingUpgrade;
        public final FilteredUpgradeConfig advancedCompactingUpgrade;
        public final FilteredUpgradeConfig feedingUpgrade;
        public final FilteredUpgradeConfig advancedFeedingUpgrade;
        public final FilteredUpgradeConfig filterUpgrade;
        public final FilteredUpgradeConfig advancedFilterUpgrade;
        public final MagnetUpgradeConfig magnetUpgrade;
        public final MagnetUpgradeConfig advancedMagnetUpgrade;
        public final FilteredUpgradeConfig pickupUpgrade;
        public final FilteredUpgradeConfig advancedPickupUpgrade;
        public final VoidUpgradeConfig voidUpgrade;
        public final VoidUpgradeConfig advancedVoidUpgrade;
        public final CookingUpgradeConfig smeltingUpgrade;
        public final CookingUpgradeConfig smokingUpgrade;
        public final CookingUpgradeConfig blastingUpgrade;
        public final AutoCookingUpgradeConfig autoSmeltingUpgrade;
        public final AutoCookingUpgradeConfig autoSmokingUpgrade;
        public final AutoCookingUpgradeConfig autoBlastingUpgrade;
        public final PumpUpgradeConfig pumpUpgrade;
        public final XpPumpUpgradeConfig xpPumpUpgrade;
        public final CompressionUpgradeConfig compressionUpgrade;
        public final HopperUpgradeConfig hopperUpgrade;
        public final HopperUpgradeConfig advancedHopperUpgrade;
        public final JukeboxUpgradeConfig advancedJukeboxUpgrade;
        public final AlchemyUpgradeConfig alchemyUpgrade;
        public final AlchemyUpgradeConfig advancedAlchemyUpgrade;
        public final ModConfigSpec.IntValue tooManyItemEntityDrops;
        public final MaxUgradesPerStorageConfig maxUpgradesPerStorage;
        public final ModConfigSpec.BooleanValue limitedBarrelCountDyeingEnabled;
        public final ModConfigSpec.IntValue controllerRange;

        public void initListeners(IEventBus modBus) {
            modBus.addListener(this::onConfigReload);
            modBus.addListener(this::onConfigLoad);
        }

        public void onConfigReload(ModConfigEvent.Reloading event) {
            this.clearCache();
        }

        public void onConfigLoad(ModConfigEvent.Loading event) {
            this.clearCache();
        }

        private void clearCache() {
            this.stackUpgrade.clearNonStackableItems();
            this.maxUpgradesPerStorage.clearCache();
            this.compressionUpgrade.clearCache();
        }

        private static <T> T getIfLoadedOrDefault(ModConfigSpec.ConfigValue<T> configValue) {
            return (T)(SERVER_SPEC.isLoaded() ? configValue.get() : configValue.getDefault());
        }

        public Server(ModConfigSpec.Builder builder) {
            builder.comment("Server Settings").push("server");
            this.woodBarrel = new StorageConfig(builder, "Wood Barrel", 27, 1);
            this.copperBarrel = new StorageConfig(builder, "Copper Barrel", 45, 1);
            this.ironBarrel = new StorageConfig(builder, "Iron Barrel", 54, 2);
            this.goldBarrel = new StorageConfig(builder, "Gold Barrel", 81, 3);
            this.diamondBarrel = new StorageConfig(builder, "Diamond Barrel", 108, 4);
            this.netheriteBarrel = new StorageConfig(builder, "Netherite Barrel", 132, 5);
            this.limitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Barrel I", 32, 1);
            this.copperLimitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Copper Barrel I", 53, 1);
            this.ironLimitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Iron Barrel I", 64, 2);
            this.goldLimitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Gold Barrel I", 96, 3);
            this.diamondLimitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Diamond Barrel I", 128, 4);
            this.netheriteLimitedBarrel1 = new LimitedBarrelConfig(builder, "Limited Netherite Barrel I", 160, 5);
            this.limitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Barrel II", 16, 1);
            this.copperLimitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Copper Barrel II", 27, 1);
            this.ironLimitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Iron Barrel II", 32, 2);
            this.goldLimitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Gold Barrel II", 48, 3);
            this.diamondLimitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Diamond Barrel II", 64, 4);
            this.netheriteLimitedBarrel2 = new LimitedBarrelConfig(builder, "Limited Netherite Barrel II", 80, 5);
            this.limitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Barrel III", 10, 1);
            this.copperLimitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Copper Barrel III", 17, 1);
            this.ironLimitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Iron Barrel III", 20, 2);
            this.goldLimitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Gold Barrel III", 30, 3);
            this.diamondLimitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Diamond Barrel III", 40, 4);
            this.netheriteLimitedBarrel3 = new LimitedBarrelConfig(builder, "Limited Netherite Barrel III", 50, 5);
            this.limitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Barrel IV", 8, 1);
            this.copperLimitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Copper Barrel IV", 13, 1);
            this.ironLimitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Iron Barrel IV", 16, 2);
            this.goldLimitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Gold Barrel IV", 24, 3);
            this.diamondLimitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Diamond Barrel IV", 32, 4);
            this.netheriteLimitedBarrel4 = new LimitedBarrelConfig(builder, "Limited Netherite Barrel IV", 40, 5);
            this.woodChest = new StorageConfig(builder, "Wood Chest", 27, 1);
            this.copperChest = new StorageConfig(builder, "Copper Chest", 45, 1);
            this.ironChest = new StorageConfig(builder, "Iron Chest", 54, 2);
            this.goldChest = new StorageConfig(builder, "Gold Chest", 81, 3);
            this.diamondChest = new StorageConfig(builder, "Diamond Chest", 108, 4);
            this.netheriteChest = new StorageConfig(builder, "Netherite Chest", 132, 5);
            this.shulkerBox = new StorageConfig(builder, "Shulker Box", 27, 1);
            this.copperShulkerBox = new StorageConfig(builder, "Copper Shulker Box", 45, 1);
            this.ironShulkerBox = new StorageConfig(builder, "Iron Shulker Box", 54, 2);
            this.goldShulkerBox = new StorageConfig(builder, "Gold Shulker Box", 81, 3);
            this.diamondShulkerBox = new StorageConfig(builder, "Diamond Shulker Box", 108, 4);
            this.netheriteShulkerBox = new StorageConfig(builder, "Netherite Shulker Box", 132, 5);
            this.shulkerBoxDisallowedItems = new ShulkerBoxDisallowedItems(builder);
            this.stackUpgrade = new StackUpgradeConfig(builder);
            this.compactingUpgrade = new FilteredUpgradeConfig(builder, "Compacting Upgrade", "compactingUpgrade", 9, 3);
            this.advancedCompactingUpgrade = new FilteredUpgradeConfig(builder, "Advanced Compacting Upgrade", "advancedCompactingUpgrade", 16, 4);
            this.feedingUpgrade = new FilteredUpgradeConfig(builder, "Feeding Upgrade", "feedingUpgrade", 9, 3);
            this.advancedFeedingUpgrade = new FilteredUpgradeConfig(builder, "Advanced Feeding Upgrade", "advancedFeedingUpgrade", 16, 4);
            this.filterUpgrade = new FilteredUpgradeConfig(builder, "Filter Upgrade", "filterUpgrade", 9, 3);
            this.advancedFilterUpgrade = new FilteredUpgradeConfig(builder, "Advanced Filter Upgrade", "advancedFilterUpgrade", 16, 4);
            this.magnetUpgrade = new MagnetUpgradeConfig(builder, "Magnet Upgrade", "magnetUpgrade", 9, 3, 3);
            this.advancedMagnetUpgrade = new MagnetUpgradeConfig(builder, "Advanced Magnet Upgrade", "advancedMagnetUpgrade", 16, 4, 5);
            this.pickupUpgrade = new FilteredUpgradeConfig(builder, "Pickup Upgrade", "pickupUpgrade", 9, 3);
            this.advancedPickupUpgrade = new FilteredUpgradeConfig(builder, "Advanced Pickup Upgrade", "advancedPickupUpgrade", 16, 4);
            this.voidUpgrade = new VoidUpgradeConfig(builder, "Void Upgrade", "voidUpgrade", 9, 3);
            this.advancedVoidUpgrade = new VoidUpgradeConfig(builder, "Advanced Void Upgrade", "advancedVoidUpgrade", 16, 4);
            this.smeltingUpgrade = CookingUpgradeConfig.getInstance((ModConfigSpec.Builder)builder, (String)"Smelting Upgrade", (String)"smeltingUpgrade");
            this.smokingUpgrade = CookingUpgradeConfig.getInstance((ModConfigSpec.Builder)builder, (String)"Smoking Upgrade", (String)"smokingUpgrade");
            this.blastingUpgrade = CookingUpgradeConfig.getInstance((ModConfigSpec.Builder)builder, (String)"Blasting Upgrade", (String)"blastingUpgrade");
            this.autoSmeltingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Smelting Upgrade", "autoSmeltingUpgrade");
            this.autoSmokingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Smoking Upgrade", "autoSmokingUpgrade");
            this.autoBlastingUpgrade = new AutoCookingUpgradeConfig(builder, "Auto-Blasting Upgrade", "autoBlastingUpgrade");
            this.pumpUpgrade = new PumpUpgradeConfig(builder);
            this.xpPumpUpgrade = new XpPumpUpgradeConfig(builder);
            this.compressionUpgrade = new CompressionUpgradeConfig(builder);
            this.hopperUpgrade = new HopperUpgradeConfig(builder, "Hopper Upgrade", "hopperUpgrade", 2, 2, 2, 2, 8, 1);
            this.advancedHopperUpgrade = new HopperUpgradeConfig(builder, "Advanced Hopper Upgrade", "advancedHopperUpgrade", 4, 4, 4, 4, 2, 4);
            this.advancedJukeboxUpgrade = new JukeboxUpgradeConfig(builder, "Advanced Jukebox Upgrade", "advancedJukeboxUpgrade", 12);
            this.alchemyUpgrade = new AlchemyUpgradeConfig(builder, "Alchemy Upgrade", "alchemyUpgrade", 4);
            this.advancedAlchemyUpgrade = new AlchemyUpgradeConfig(builder, "Advanced Alchemy Upgrade", "advancedAlchemyUpgrade", 8);
            this.maxUpgradesPerStorage = new MaxUgradesPerStorageConfig(builder, Map.of("chest", Map.of(StackUpgradeItem.UPGRADE_GROUP.name(), 2, ICookingUpgrade.UPGRADE_GROUP.name(), 1, JukeboxUpgradeItem.UPGRADE_GROUP.name(), 1), "barrel", Map.of(StackUpgradeItem.UPGRADE_GROUP.name(), 2, ICookingUpgrade.UPGRADE_GROUP.name(), 1, JukeboxUpgradeItem.UPGRADE_GROUP.name(), 1), "shulker_box", Map.of(StackUpgradeItem.UPGRADE_GROUP.name(), 2, ICookingUpgrade.UPGRADE_GROUP.name(), 1, JukeboxUpgradeItem.UPGRADE_GROUP.name(), 1), "limited_barrel", Map.of(ICookingUpgrade.UPGRADE_GROUP.name(), 1, JukeboxUpgradeItem.UPGRADE_GROUP.name(), 1)));
            this.tooManyItemEntityDrops = builder.comment("Threshold of number of item entities dropped from chest / barrel above which break is canceled (unless shift key is pressed) and message is displayed explaining to player many drops and packing tape use").defineInRange("tooManyItemEntityDrops", 200, 0, 1000);
            this.limitedBarrelCountDyeingEnabled = builder.comment("Determines if limited barrel counts can be dyed to change their color").define("limitedBarrelCountDyeingEnabled", true);
            this.controllerRange = builder.comment("Defines the maximum range of the controller at which it connects storage blocks to multiblock").defineInRange("controllerRange", 15, 4, 64);
            builder.pop();
        }

        public static class MaxUgradesPerStorageConfig
        implements IUpgradeCountLimitConfig {
            private final ModConfigSpec.ConfigValue<List<? extends String>> maxUpgradesPerStorageList;
            private @Nullable Map<String, Map<String, Integer>> maxUpgradesPerStorage = null;

            protected MaxUgradesPerStorageConfig(ModConfigSpec.Builder builder, Map<String, Map<String, Integer>> defaultUpgradesPerStorage) {
                this.maxUpgradesPerStorageList = builder.comment("Limit of maximum number of upgrades of type per storage in format of \"StorageType|UpgradeRegistryName[or UpgradeGroup]|MaxNumber\"").defineList("maxUpgradesPerStorage", this.convertToList(defaultUpgradesPerStorage), () -> "upgrade_name|1", mapping -> ((String)mapping).matches(Config.MAX_UPGRADES_MATCHER));
            }

            private List<String> convertToList(Map<String, Map<String, Integer>> defaultUpgradesPerStorage) {
                ArrayList<String> list = new ArrayList<String>();
                defaultUpgradesPerStorage.forEach((storageType, upgradeMap) -> upgradeMap.forEach((upgradeName, maxNumber) -> list.add(storageType + "|" + upgradeName + "|" + maxNumber)));
                return list;
            }

            public void clearCache() {
                this.maxUpgradesPerStorage = null;
            }

            public int getMaxUpgradesPerStorage(String storageType, @Nullable Identifier upgradeRegistryName) {
                if (this.maxUpgradesPerStorage == null) {
                    this.initMaxUpgradesPerStorage();
                }
                if (upgradeRegistryName == null) {
                    return Integer.MAX_VALUE;
                }
                if (!this.maxUpgradesPerStorage.containsKey(storageType)) {
                    return Integer.MAX_VALUE;
                }
                return this.maxUpgradesPerStorage.get(storageType).getOrDefault(upgradeRegistryName.getPath(), Integer.MAX_VALUE);
            }

            private void initMaxUpgradesPerStorage() {
                this.maxUpgradesPerStorage = new HashMap<String, Map<String, Integer>>();
                for (String entry : (List)this.maxUpgradesPerStorageList.get()) {
                    String[] parts = entry.split("\\|");
                    if (parts.length != 3) continue;
                    String storageType = parts[0];
                    String upgradeName = parts[1];
                    int maxNumber = Integer.parseInt(parts[2]);
                    this.maxUpgradesPerStorage.computeIfAbsent(storageType, k -> new HashMap()).put(upgradeName, maxNumber);
                }
            }

            public int getMaxUpgradesInGroupPerStorage(String storageType, UpgradeGroup upgradeGroup) {
                if (this.maxUpgradesPerStorage == null) {
                    this.initMaxUpgradesPerStorage();
                }
                if (!this.maxUpgradesPerStorage.containsKey(storageType)) {
                    return Integer.MAX_VALUE;
                }
                return this.maxUpgradesPerStorage.get(storageType).getOrDefault(upgradeGroup.name(), Integer.MAX_VALUE);
            }
        }

        public static class StorageConfig {
            public final ModConfigSpec.IntValue inventorySlotCount;
            public final ModConfigSpec.IntValue upgradeSlotCount;

            public StorageConfig(ModConfigSpec.Builder builder, String storagePrefix, int inventorySlotCountDefault, int upgradeSlotCountDefault) {
                builder.comment(storagePrefix + " Settings").push(storagePrefix.replace(" ", ""));
                this.inventorySlotCount = builder.comment("Number of inventory slots in the storage").defineInRange("inventorySlotCount", inventorySlotCountDefault, 1, 180);
                this.upgradeSlotCount = builder.comment("Number of upgrade slots in the storage").defineInRange("upgradeSlotCount", upgradeSlotCountDefault, 0, 10);
                builder.pop();
            }

            public int numberOfInventorySlots() {
                return (Integer)Server.getIfLoadedOrDefault(this.inventorySlotCount);
            }

            public int numberOfUpgradeSlots() {
                return (Integer)Server.getIfLoadedOrDefault(this.upgradeSlotCount);
            }
        }

        public static class LimitedBarrelConfig {
            public final ModConfigSpec.IntValue baseSlotLimitMultiplier;
            public final ModConfigSpec.IntValue upgradeSlotCount;

            public LimitedBarrelConfig(ModConfigSpec.Builder builder, String storagePrefix, int baseSlotLimitMultiplierDefault, int upgradeSlotCountDefault) {
                builder.comment(storagePrefix + " Settings").push(storagePrefix.replace(" ", ""));
                this.baseSlotLimitMultiplier = builder.comment("Multiplier that's used to calculate base slot limit").defineInRange("baseSlotLimitMultiplier", baseSlotLimitMultiplierDefault, 1, 8192);
                this.upgradeSlotCount = builder.comment("Number of upgrade slots in the storage").defineInRange("upgradeSlotCount", upgradeSlotCountDefault, 0, 10);
                builder.pop();
            }

            public int baseSlotLimitMultiplier() {
                return (Integer)Server.getIfLoadedOrDefault(this.baseSlotLimitMultiplier);
            }

            public int upgradeSlotCount() {
                return (Integer)Server.getIfLoadedOrDefault(this.upgradeSlotCount);
            }
        }

        public static class ShulkerBoxDisallowedItems {
            private final ModConfigSpec.BooleanValue containerItemsDisallowed;
            private final ModConfigSpec.ConfigValue<List<String>> disallowedItemsList;
            private boolean initialized = false;
            private Set<Item> disallowedItemsSet = null;

            ShulkerBoxDisallowedItems(ModConfigSpec.Builder builder) {
                builder.push("shulkerBoxDisallowedItems");
                this.disallowedItemsList = builder.comment("List of items that are not allowed to be put in shulkerboxes - e.g. \"minecraft:bundle\"").define("disallowedItems", new ArrayList());
                this.containerItemsDisallowed = builder.comment("Determines if container items (those that override canFitInsideContainerItems to false) are able to fit in shulker boxes").define("containerItemsDisallowed", false);
                builder.pop();
            }

            public boolean isItemDisallowed(Item item) {
                if (!SERVER_SPEC.isLoaded()) {
                    return true;
                }
                if (!this.initialized) {
                    this.loadDisallowedSet();
                }
                if (Boolean.TRUE.equals(this.containerItemsDisallowed.get()) && !item.canFitInsideContainerItems()) {
                    return true;
                }
                return this.disallowedItemsSet.contains(item);
            }

            private void loadDisallowedSet() {
                this.initialized = true;
                this.disallowedItemsSet = new HashSet<Item>();
                for (String disallowedItemName : (List)this.disallowedItemsList.get()) {
                    Identifier registryName = Identifier.parse((String)disallowedItemName);
                    BuiltInRegistries.ITEM.getOptional(registryName).ifPresent(this.disallowedItemsSet::add);
                }
            }
        }
    }

    public static class Client {
        public final ModConfigSpec.BooleanValue showHigherTierTintedVariants;
        public final ModConfigSpec.BooleanValue showSingleWoodVariantOnly;

        public Client(ModConfigSpec.Builder builder) {
            builder.comment("Client-side Settings").push("client");
            this.showHigherTierTintedVariants = builder.comment("Determines whether JEI and creative tab will show tinted storage items for iron and higher tiers. Can help with easily removing many of these items from there.").worldRestart().define("showHigherTierTintedVariants", true);
            this.showSingleWoodVariantOnly = builder.comment("Determines whether JEI and creative tab will show only single wood variant of storage item per tier. Makes creative tab and .").worldRestart().define("showSingleWoodVariantOnly", false);
            builder.pop();
        }
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue dropPacked;

        public Common(ModConfigSpec.Builder builder) {
            builder.comment("Common Settings").push("common");
            this.dropPacked = builder.comment("Determines whether chests / barrels are always dropped as packed with their contents when broken without the need to use packing tape").define("dropPacked", false);
            builder.pop();
        }
    }
}

