/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.util;

import com.mrbysco.armorposer.Reference;
import java.util.Optional;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.Vec2;

public class ArmorStandData {
    public boolean invisible = false;
    public boolean noBasePlate = false;
    public boolean noGravity = false;
    public boolean showArms = false;
    public boolean small = false;
    public boolean nameVisible = true;
    public boolean locked = true;
    public float rotation = 0.0f;
    public final float[] pose = new float[21];

    public boolean getBooleanValue(int index) {
        return switch (index) {
            case 0 -> this.invisible;
            case 1 -> {
                if (!this.noBasePlate) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (!this.noGravity) {
                    yield true;
                }
                yield false;
            }
            case 3 -> this.showArms;
            case 4 -> this.small;
            case 5 -> this.nameVisible;
            case 6 -> this.locked;
            default -> false;
        };
    }

    public void readFromNBT(CompoundTag compound) {
        this.invisible = compound.getBooleanOr("Invisible", false);
        this.noBasePlate = compound.getBooleanOr("NoBasePlate", false);
        this.noGravity = compound.getBooleanOr("NoGravity", false);
        this.showArms = compound.getBooleanOr("ShowArms", false);
        this.small = compound.getBooleanOr("Small", false);
        this.nameVisible = compound.getBooleanOr("CustomNameVisible", false);
        this.locked = compound.getBooleanOr("Invulnerable", false);
        Optional rotation = compound.read("Rotation", Vec2.CODEC);
        if (rotation.isPresent()) {
            this.rotation = ((Vec2)rotation.get()).x;
        }
        if (compound.contains("Pose")) {
            CompoundTag poseTag = compound.getCompoundOrEmpty("Pose");
            if (poseTag.isEmpty()) {
                Reference.LOGGER.warn("Pose tag is empty, skipping pose data");
                return;
            }
            String[] keys = new String[]{"Head", "Body", "LeftLeg", "RightLeg", "LeftArm", "RightArm"};
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!poseTag.contains(key)) continue;
                Rotations rotations = poseTag.read(key, Rotations.CODEC).orElse(new Rotations(0.0f, 0.0f, 0.0f));
                this.pose[i * 3] = rotations.x();
                this.pose[i * 3 + 1] = rotations.y();
                this.pose[i * 3 + 2] = rotations.z();
            }
        }
    }

    public CompoundTag writeToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Invisible", this.invisible);
        compound.putBoolean("NoBasePlate", this.noBasePlate);
        compound.putBoolean("NoGravity", this.noGravity);
        compound.putBoolean("ShowArms", this.showArms);
        compound.putBoolean("Small", this.small);
        compound.putBoolean("CustomNameVisible", this.nameVisible);
        compound.putBoolean("Invulnerable", this.locked);
        compound.putInt("DisabledSlots", this.locked ? 0x3F3F3F : 0);
        compound.store("Rotation", Vec2.CODEC, (Object)new Vec2(this.rotation, 0.0f));
        CompoundTag poseTag = new CompoundTag();
        ListTag poseHeadTag = new ListTag();
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.pose[0]));
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.pose[1]));
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.pose[2]));
        poseTag.put("Head", (Tag)poseHeadTag);
        ListTag poseBodyTag = new ListTag();
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.pose[3]));
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.pose[4]));
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.pose[5]));
        poseTag.put("Body", (Tag)poseBodyTag);
        ListTag poseLeftLegTag = new ListTag();
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.pose[6]));
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.pose[7]));
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.pose[8]));
        poseTag.put("LeftLeg", (Tag)poseLeftLegTag);
        ListTag poseRightLegTag = new ListTag();
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.pose[9]));
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.pose[10]));
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.pose[11]));
        poseTag.put("RightLeg", (Tag)poseRightLegTag);
        ListTag poseLeftArmTag = new ListTag();
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.pose[12]));
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.pose[13]));
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.pose[14]));
        poseTag.put("LeftArm", (Tag)poseLeftArmTag);
        ListTag poseRightArmTag = new ListTag();
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.pose[15]));
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.pose[16]));
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.pose[17]));
        poseTag.put("RightArm", (Tag)poseRightArmTag);
        compound.put("Pose", (Tag)poseTag);
        return compound;
    }
}

