/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import com.mojang.blaze3d.platform.cursor.CursorTypes;
import com.mrbysco.armorposer.mixin.AbstractSliderButtonAccessor;
import java.text.DecimalFormat;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;

public class RangeSlider
extends AbstractSliderButton {
    protected Component prefix;
    protected Component suffix;
    protected double minValue;
    protected double maxValue;
    private final double stepSize = 1.0;
    private final DecimalFormat format = new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
    protected boolean drawString;
    protected final OnChange onChange;

    public RangeSlider(int x, int y, int width, int height, Component prefix, Component suffix, double minValue, double maxValue, double currentValue, boolean drawString, OnChange onChange) {
        super(x, y, width, height, (Component)Component.empty(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        this.onChange = onChange;
        this.updateMessage();
    }

    public double getValue() {
        return this.value * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void setValue(double value) {
        this.setFractionalValue((value - this.minValue) / (this.maxValue - this.minValue));
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void onClick(MouseButtonEvent event, boolean doubleClick) {
        ((AbstractSliderButtonAccessor)((Object)this)).armorposer$setDragging(this.active);
        this.setValueFromMouse(event.x());
    }

    protected void onDrag(MouseButtonEvent event, double dragX, double dragY) {
        super.onDrag(event, dragX, dragY);
        this.setValueFromMouse(event.x());
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        boolean flag = keyEvent.isLeft();
        if (flag || keyEvent.isRight()) {
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f = flag ? -1.0f : 1.0f;
            this.setValue(this.getValue() + (double)f * this.stepSize);
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setFractionalValue((mouseX - (double)(this.getX() + 4)) / (double)(this.width - 8));
    }

    private void setFractionalValue(double fractionalValue) {
        double oldValue = this.value;
        this.value = this.snapToNearest(fractionalValue);
        if (!Mth.equal((double)oldValue, (double)this.value)) {
            this.applyValue();
        }
        this.updateMessage();
    }

    private double snapToNearest(double value) {
        value = Mth.lerp((double)Mth.clamp((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = 1.0 * (double)Math.round(value / 1.0);
        value = this.minValue > this.maxValue ? Mth.clamp((double)value, (double)this.maxValue, (double)this.minValue) : Mth.clamp((double)value, (double)this.minValue, (double)this.maxValue);
        return Mth.map((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void updateMessage() {
        if (this.drawString) {
            this.setMessage((Component)Component.literal((String)"").append(this.prefix).append(this.getValueString()).append(this.suffix));
        } else {
            this.setMessage((Component)Component.empty());
        }
    }

    protected void applyValue() {
        if (this.onChange != null) {
            this.onChange.onChange(this.getValueInt());
        }
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, ((AbstractSliderButtonAccessor)((Object)this)).armorposer$getSprite(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)this.alpha));
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, ((AbstractSliderButtonAccessor)((Object)this)).armorposer$getHandleSprite(), this.getX() + (int)(this.value * (double)(this.width - 8)), this.getY(), 8, this.getHeight(), ARGB.white((float)this.alpha));
        int i = this.active ? 0xFFFFFF : 0xA0A0A0;
        MutableComponent message = this.getMessage().copy().withStyle(style -> style.withColor(i));
        this.renderScrollingStringOverContents(guiGraphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE), (Component)message, 2);
        if (this.isHovered()) {
            guiGraphics.requestCursor(((AbstractSliderButtonAccessor)((Object)this)).armorposer$isDragging() ? CursorTypes.RESIZE_EW : CursorTypes.POINTING_HAND);
        }
    }

    public static interface OnChange {
        public void onChange(int var1);
    }
}

