/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import java.util.Locale;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.math.NumberUtils;

public class NumberFieldBox
extends EditBox {
    public float scrollMultiplier = 1.0f;
    public float modValue = 360.0f;
    public int decimalPoints = 0;
    public boolean allowDecimal = false;

    public NumberFieldBox(Font font, int x, int y, int width, int height, Component defaultValue) {
        super(font, x, y, width, height, defaultValue);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        return super.keyPressed(keyEvent);
    }

    public void insertText(String textToWrite) {
        float currentValue;
        if (this.isNumeric(textToWrite)) {
            super.insertText(textToWrite);
        }
        if ((currentValue = this.getFloat()) > 360.0f || currentValue < -360.0f) {
            this.setValue("0");
        }
    }

    public String getValue() {
        return this.isNumeric(super.getValue()) ? super.getValue() : "0";
    }

    public void setValue(String value) {
        if (value.isEmpty()) {
            super.setValue("0");
        } else {
            super.setValue(String.format(Locale.ROOT, "%." + this.decimalPoints + "f", Float.valueOf(Float.parseFloat(value))));
        }
    }

    public float getFloat() {
        return NumberUtils.toFloat((String)super.getValue(), (float)0.0f);
    }

    public int getInt() {
        return Mth.ceil((float)this.getFloat());
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.setHighlightPos(this.getValue().length());
            this.moveCursorToEnd(false);
        }
    }

    protected boolean isNumeric(String value) {
        if (this.allowDecimal && value.equals(".")) {
            return true;
        }
        return value.equals("-") || NumberUtils.isParsable((String)value);
    }
}

