/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui;

import com.mrbysco.armorposer.client.GlowHandler;
import com.mrbysco.armorposer.client.gui.ArmorStandScreen;
import com.mrbysco.armorposer.client.gui.widgets.ArmorGlowWidget;
import com.mrbysco.armorposer.client.gui.widgets.RangeSlider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.decoration.ArmorStand;

public class ArmorGlowScreen
extends Screen {
    private static final int PADDING = 6;
    private ArmorGlowWidget[] armorListWidget = new ArmorGlowWidget[2];
    private ArmorGlowWidget.ListEntry selected = null;
    private final List<ArmorStand> armorStands;
    private final List<ArmorStand> invisiblearmorStands;
    private Button locateButton;
    private Button modifyButton;
    private RangeSlider rangeSlider;
    public final ArmorStandScreen parentScreen;
    private double range = 30.0;

    public ArmorGlowScreen(ArmorStandScreen parent) {
        super((Component)Component.translatable((String)"armorposer.gui.armor_list.list"));
        this.parentScreen = parent;
        if (this.minecraft.player == null || this.minecraft.level == null) {
            this.onClose();
        }
        assert (this.minecraft.level != null);
        ArrayList armorStands = new ArrayList(this.minecraft.level.getEntitiesOfClass(ArmorStand.class, this.minecraft.player.getBoundingBox().inflate(30.0), EntitySelector.LIVING_ENTITY_STILL_ALIVE));
        armorStands.sort((armorStand, armorStand2) -> {
            double distance1 = armorStand.distanceToSqr((Entity)this.minecraft.player);
            double distance2 = armorStand2.distanceToSqr((Entity)this.minecraft.player);
            return Double.compare(distance1, distance2);
        });
        this.armorStands = armorStands.stream().filter(stand -> !stand.isInvisible()).toList();
        this.invisiblearmorStands = armorStands.stream().filter(Entity::isInvisible).toList();
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        int centerWidth = this.width / 2;
        int listWidth = this.width / 4 + 20;
        int structureWidth = this.width - listWidth - 18;
        int closeButtonWidth = Math.min(structureWidth, 160);
        int y = this.height - 20 - 6;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).bounds(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20).build());
        int buttonWidth = closeButtonWidth / 2 - 1;
        this.locateButton = Button.builder((Component)Component.translatable((String)"armorposer.gui.armor_list.locate"), b -> {
            if (this.selected != null && this.minecraft.player != null) {
                GlowHandler.startGlowing(this.selected.getArmorStand().getUUID());
                this.minecraft.player.lookAt(EntityAnchorArgument.Anchor.EYES, this.selected.getArmorStand().position());
            }
        }).bounds(centerWidth - closeButtonWidth / 2 + 6, y -= 24, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.locateButton);
        this.modifyButton = Button.builder((Component)Component.translatable((String)"armorposer.gui.armor_list.modify"), b -> {
            if (this.selected != null && this.minecraft.player != null) {
                this.minecraft.setScreen((Screen)new ArmorStandScreen(this.selected.getArmorStand()));
            }
        }).bounds(centerWidth - closeButtonWidth / 2 + 6 + buttonWidth + 2, y, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.modifyButton);
        int fullButtonHeight = 32;
        MutableComponent mutableComponent = Component.translatable((String)"armorposer.gui.armor_list.list");
        Objects.requireNonNull(this.getScreenFont());
        this.armorListWidget[0] = new ArmorGlowWidget(this, (Component)mutableComponent, true, listWidth, fullButtonHeight, y - 9 - 6);
        this.armorListWidget[0].setX(0);
        this.armorListWidget[0].setY(16);
        this.armorListWidget[0].setHeight(this.height);
        this.addRenderableWidget((GuiEventListener)this.armorListWidget[0]);
        this.armorListWidget[0].refreshList(true);
        MutableComponent mutableComponent2 = Component.translatable((String)"armorposer.gui.armor_list.list2");
        Objects.requireNonNull(this.getScreenFont());
        this.armorListWidget[1] = new ArmorGlowWidget(this, (Component)mutableComponent2, false, listWidth, fullButtonHeight, y - 9 - 6);
        this.armorListWidget[1].setX(this.width - listWidth);
        this.armorListWidget[1].setY(16);
        this.armorListWidget[1].setHeight(this.height);
        this.addRenderableWidget((GuiEventListener)this.armorListWidget[1]);
        this.armorListWidget[1].refreshList(false);
        this.rangeSlider = new RangeSlider(centerWidth - 50, 4, 100, 20, (Component)Component.translatable((String)"armorposer.gui.label.range").append(" : "), (Component)Component.empty(), 1.0, 30.0, 30.0, true, value -> {
            this.range = value;
            this.armorListWidget[0].refreshList(true);
            this.armorListWidget[1].refreshList(false);
        });
        this.rangeSlider.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.range")));
        this.addRenderableWidget((GuiEventListener)this.rangeSlider);
        this.updateCache();
    }

    public void tick() {
        if (this.armorListWidget[0].children().contains((Object)this.selected)) {
            this.armorListWidget[0].setSelected(this.selected);
            this.armorListWidget[1].setSelected((ArmorGlowWidget.ListEntry)null);
        } else if (this.armorListWidget[1].children().contains((Object)this.selected)) {
            this.armorListWidget[0].setSelected((ArmorGlowWidget.ListEntry)null);
            this.armorListWidget[1].setSelected(this.selected);
        }
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildVisiblePositions(Consumer<T> listViewConsumer, Function<ArmorStand, T> newEntry) {
        List<ArmorStand> filteredStands = this.filterRange(this.armorStands, this.range);
        filteredStands.forEach(stand -> listViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((ArmorStand)stand)));
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildInvisiblePositions(Consumer<T> listViewConsumer, Function<ArmorStand, T> newEntry) {
        List<ArmorStand> filteredStands = this.filterRange(this.invisiblearmorStands, this.range);
        filteredStands.forEach(stand -> listViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((ArmorStand)stand)));
    }

    private List<ArmorStand> filterRange(List<ArmorStand> stands, double range) {
        if (this.minecraft.player == null) {
            return stands;
        }
        return stands.stream().filter(stand -> stand.distanceToSqr((Entity)this.minecraft.player) <= range * range).toList();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.armorListWidget[0].keyPressed(event)) {
            return true;
        }
        if (this.armorListWidget[1].keyPressed(event)) {
            return true;
        }
        return super.keyPressed(event);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void setSelected(ArmorGlowWidget.ListEntry previousEntry, ArmorGlowWidget.ListEntry entry, boolean visible) {
        if (this.selected == previousEntry) {
            this.selected = entry;
        } else if (this.selected == null || entry != null) {
            this.selected = entry;
        }
        this.updateCache();
    }

    private void updateCache() {
        this.locateButton.active = this.selected != null;
        this.modifyButton.active = this.selected != null;
    }

    public boolean mouseClicked(MouseButtonEvent buttonEvent, boolean flag) {
        boolean clicked = super.mouseClicked(buttonEvent, flag);
        if (this.armorListWidget[0].mouseClicked(buttonEvent, flag)) {
            return true;
        }
        if (this.armorListWidget[1].mouseClicked(buttonEvent, flag)) {
            return true;
        }
        return clicked;
    }

    public void resize(int width, int height) {
        ArmorGlowWidget.ListEntry selected = this.selected;
        this.init(width, height);
        this.selected = selected;
        this.updateCache();
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)this.parentScreen);
    }

    public Minecraft getScreenMinecraft() {
        return this.minecraft;
    }

    public Font getScreenFont() {
        return this.font;
    }
}

