/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.mixin;

import baguchi.hunters_return.item.MiniCrossbowItem;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowItemMixin
extends ProjectileWeaponItem {
    public CrossbowItemMixin(Item.Properties properties) {
        super(properties);
    }

    @Inject(method={"getChargeDuration"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getChargeDuration(ItemStack stack, LivingEntity shooter, CallbackInfoReturnable<Integer> cir) {
        if (stack.getItem() instanceof MiniCrossbowItem) {
            float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)stack, (LivingEntity)shooter, (float)0.65f);
            cir.setReturnValue((Object)Mth.floor((float)(f * 20.0f)));
        }
    }

    @Inject(method={"tryLoadProjectiles"}, at={@At(value="RETURN")})
    private static void tryLoadProjectiles(LivingEntity shooter, ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        InteractionHand hand2;
        ItemStack itemstack2;
        if (stack.getItem() instanceof MiniCrossbowItem && ((Boolean)cir.getReturnValue()).booleanValue() && (itemstack2 = shooter.getItemInHand(hand2 = shooter.getUsedItemHand() == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND)).getItem() instanceof MiniCrossbowItem && !CrossbowItem.isCharged((ItemStack)itemstack2)) {
            MiniCrossbowItem.tryLoadProjectiles(shooter, itemstack2);
        }
    }
}

