/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.entity;

import baguchi.bagus_lib.entity.goal.AnimateAttackGoal;
import baguchi.hunters_return.HunterConfig;
import baguchi.hunters_return.api.HunterVariant;
import baguchi.hunters_return.data.resources.registries.HunterVariants;
import baguchi.hunters_return.entity.ai.BoomeranAttackGoal;
import baguchi.hunters_return.entity.ai.CallAllyGoal;
import baguchi.hunters_return.entity.ai.DoSleepingGoal;
import baguchi.hunters_return.entity.ai.DodgeGoal;
import baguchi.hunters_return.entity.ai.MiniCrossBowAttackGoal;
import baguchi.hunters_return.entity.ai.SleepOnBedGoal;
import baguchi.hunters_return.entity.ai.WakeUpGoal;
import baguchi.hunters_return.entity.projectile.BoomerangEntity;
import baguchi.hunters_return.init.HunterEnchantments;
import baguchi.hunters_return.init.HunterEntityDatas;
import baguchi.hunters_return.init.HunterItems;
import baguchi.hunters_return.init.HunterSounds;
import baguchi.hunters_return.item.MiniCrossbowItem;
import baguchi.hunters_return.utils.HunterConfigUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.golem.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.creaking.Creaking;
import net.minecraft.world.entity.monster.illager.AbstractIllager;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.villager.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Instruments;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPatterns;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.event.EventHooks;

public class Hunter
extends AbstractIllager
implements CrossbowAttackMob,
RangedAttackMob,
InventoryCarrier {
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.defineId(Hunter.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_USING_MOUTH = SynchedEntityData.defineId(Hunter.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ItemStack> MOUTH_ITEM = SynchedEntityData.defineId(Hunter.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final EntityDataAccessor<Holder<HunterVariant>> HUNTER_VARIANT = SynchedEntityData.defineId(Hunter.class, (EntityDataSerializer)((EntityDataSerializer)HunterEntityDatas.HUNTER_VARIANT.get()));
    private static final Predicate<? super ItemEntity> ALLOWED_ITEMS = p_213616_0_ -> HunterConfigUtils.isWhitelistedItem(p_213616_0_.getItem().getItem());
    private final SimpleContainer inventory = new SimpleContainer(5);
    @Nullable
    private BlockPos homeTarget;
    private int huntCooldown;
    protected ItemStack useMouthItem = ItemStack.EMPTY;
    protected int mouthItemRemaining;
    private final int attackAnimationLength = 18;
    private final int shootAnimationLength = 20;
    private final int attackAnimationActionPoint = 6;
    private int attackAnimationTick;
    private int shootAnimationTick;
    private int thrownAnimationTick;
    private int dodghAnimationTick;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState shootAnimationState = new AnimationState();
    public final AnimationState chargeAnimationState = new AnimationState();
    public final AnimationState thrownAnimationState = new AnimationState();
    public final AnimationState dodghRightAnimationState = new AnimationState();
    public final AnimationState dodghLeftAnimationState = new AnimationState();

    public Hunter(EntityType<? extends Hunter> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
        this.getNavigation().setCanOpenDoors(true);
        this.setCanPickUpLoot(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326255_) {
        super.defineSynchedData(p_326255_);
        p_326255_.define(IS_CHARGING_CROSSBOW, (Object)false);
        p_326255_.define(IS_USING_MOUTH, (Object)false);
        p_326255_.define(MOUTH_ITEM, (Object)ItemStack.EMPTY);
        RegistryAccess registryaccess = this.registryAccess();
        Registry registry = registryaccess.lookupOrThrow(HunterVariants.HUNTER_VARIANT_KEY);
        p_326255_.define(HUNTER_VARIANT, (Object)((Holder)registry.get(HunterVariants.DEFAULT).or(() -> ((Registry)registry).getAny()).orElseThrow()));
    }

    public Holder<HunterVariant> getHunterVariant() {
        return (Holder)this.entityData.get(HUNTER_VARIANT);
    }

    public void setHunterVariant(Holder<HunterVariant> p_332777_) {
        this.entityData.set(HUNTER_VARIANT, p_332777_);
    }

    @Nullable
    public Identifier getTexture() {
        HunterVariant tofunianVariant = (HunterVariant)this.getHunterVariant().value();
        return tofunianVariant.texture();
    }

    @Nullable
    public Identifier getTextureOld() {
        HunterVariant tofunianVariant = (HunterVariant)this.getHunterVariant().value();
        if (tofunianVariant.textureOld().isPresent()) {
            return tofunianVariant.textureOld().get();
        }
        return null;
    }

    public void setMouthItem(ItemStack itemStack) {
        this.entityData.set(MOUTH_ITEM, (Object)itemStack);
    }

    public ItemStack getMouthItem() {
        return (ItemStack)this.entityData.get(MOUTH_ITEM);
    }

    public void setUsingMouthItem(boolean mouth) {
        this.entityData.set(IS_USING_MOUTH, (Object)mouth);
    }

    public boolean isUsingMouthItem() {
        return (Boolean)this.entityData.get(IS_USING_MOUTH);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new WakeUpGoal((PathfinderMob)this));
        this.goalSelector.addGoal(0, (Goal)new DoSleepingGoal((PathfinderMob)this));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new CallAllyGoal(this));
        this.goalSelector.addGoal(0, (Goal)new DodgeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(2, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.goalSelector.addGoal(3, (Goal)new Raider.HoldGroundAttackGoal((AbstractIllager)this, 10.0f));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creaking.class, 8.0f, 1.2, 1.35));
        this.goalSelector.addGoal(4, new MiniCrossBowAttackGoal<Hunter>(this, 1.1, 10.0f));
        this.goalSelector.addGoal(4, (Goal)new RangedBowAttackGoal((Monster)this, (double)1.1f, 50, 16.0f));
        this.goalSelector.addGoal(4, (Goal)new BoomeranAttackGoal(this, 50, 16.0f));
        this.goalSelector.addGoal(4, (Goal)new AnimateAttackGoal(this, (PathfinderMob)this, 1.15f, 6, 18){

            public boolean canUse() {
                return !this.mob.isHolding(item -> item.getItem() instanceof BowItem || item.getItem() instanceof MiniCrossbowItem) && super.canUse();
            }

            public boolean canContinueToUse() {
                return !this.mob.isHolding(item -> item.getItem() instanceof BowItem || item.getItem() instanceof MiniCrossbowItem) && super.canContinueToUse();
            }
        });
        this.goalSelector.addGoal(5, (Goal)new SleepOnBedGoal((PathfinderMob)this, 1.0, 12));
        this.goalSelector.addGoal(6, (Goal)new GetFoodGoal(this, this));
        this.goalSelector.addGoal(7, (Goal)new MoveToGoal(this, 45.0, 1.2));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[]{AbstractIllager.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Goat.class, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, true, false, (living, server) -> !living.isBaby() && HunterConfigUtils.isWhitelistedEntity(living.getType())){

            public boolean canUse() {
                return Hunter.this.huntCooldown <= 0 && super.canUse();
            }
        });
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public void baseTick() {
        super.baseTick();
        if (this.level().isClientSide()) {
            if (this.attackAnimationTick < this.attackAnimationLength) {
                ++this.attackAnimationTick;
                if (this.thrownAnimationState.isStarted()) {
                    this.thrownAnimationState.stop();
                }
            }
            if (this.attackAnimationTick >= this.attackAnimationLength) {
                this.attackAnimationState.stop();
            }
            if (this.shootAnimationTick < this.shootAnimationLength) {
                ++this.shootAnimationTick;
            }
            if (this.shootAnimationTick >= this.shootAnimationLength) {
                this.shootAnimationState.stop();
            }
            if (this.thrownAnimationTick < this.attackAnimationLength) {
                ++this.thrownAnimationTick;
            }
            if (this.thrownAnimationTick >= this.attackAnimationLength) {
                this.thrownAnimationState.stop();
            }
            if (this.dodghAnimationTick < 11) {
                ++this.dodghAnimationTick;
            }
            if (this.dodghAnimationTick >= 11) {
                this.dodghRightAnimationState.stop();
                this.dodghLeftAnimationState.stop();
            }
            if (this.isHolding(is -> is.getItem() instanceof BowItem) && this.isAggressive() && this.shootAnimationTick >= this.shootAnimationLength) {
                if (!this.chargeAnimationState.isStarted()) {
                    this.chargeAnimationState.start(this.tickCount);
                }
            } else {
                this.chargeAnimationState.stop();
            }
        }
    }

    public void handleEntityEvent(byte p_219360_) {
        if (p_219360_ == 4) {
            this.attackAnimationTick = 0;
            this.attackAnimationState.start(this.tickCount);
        } else if (p_219360_ == 61) {
            this.shootAnimationTick = 0;
            this.shootAnimationState.start(this.tickCount);
        } else if (p_219360_ == 62) {
            this.thrownAnimationTick = 0;
            this.thrownAnimationState.start(this.tickCount);
        } else if (p_219360_ == 64) {
            this.dodghAnimationTick = 0;
            this.dodghRightAnimationState.start(this.tickCount);
        } else if (p_219360_ == 65) {
            this.dodghAnimationTick = 0;
            this.dodghLeftAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_219360_);
        }
    }

    public void tick() {
        super.tick();
        this.updatingUsingMouthItem();
    }

    public void aiStep() {
        if (!this.level().isClientSide() && this.isAlive()) {
            ItemStack stack;
            ItemStack mainhand = this.getItemInHand(InteractionHand.MAIN_HAND);
            if (!this.isUsingItem() && this.getOffhandItem().isEmpty() && (mainhand.getItem() != Items.BOW || this.getTarget() == null)) {
                stack = ItemStack.EMPTY;
                if (this.getHealth() >= this.getMaxHealth() && this.random.nextFloat() < 0.01f) {
                    stack = this.findBoomerang();
                }
                if (!stack.isEmpty()) {
                    this.setItemSlot(EquipmentSlot.OFFHAND, stack);
                    if (stack.get(DataComponents.FOOD) != null) {
                        this.startUsingItem(InteractionHand.OFF_HAND);
                    }
                }
            }
            if (this.getMouthItem().isEmpty()) {
                stack = ItemStack.EMPTY;
                if (this.getHealth() < this.getMaxHealth() && this.random.nextFloat() < 0.005f) {
                    stack = this.findFood();
                }
                if (!stack.isEmpty()) {
                    this.setMouthItem(stack);
                    if (stack.get(DataComponents.FOOD) != null) {
                        this.startUsingMouthItem();
                    }
                }
            }
        }
        super.aiStep();
    }

    public void startUsingMouthItem() {
        ItemStack itemstack = this.getMouthItem();
        if (!itemstack.isEmpty() && !this.isUsingMouthItem()) {
            this.useMouthItem = itemstack;
            this.mouthItemRemaining = itemstack.getUseDuration((LivingEntity)this);
            this.setUsingMouthItem(true);
            if (!this.level().isClientSide()) {
                this.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
            }
        }
    }

    private void updatingUsingMouthItem() {
        if (this.isUsingMouthItem()) {
            ItemStack itemStack = this.getMouthItem();
            if (CommonHooks.canContinueUsing((ItemStack)this.useMouthItem, (ItemStack)itemStack)) {
                this.useMouthItem = itemStack;
            }
            if (itemStack == this.useMouthItem) {
                this.updateUsingMouthItem(this.useMouthItem);
            } else {
                this.stopUsingMouth();
            }
        }
    }

    protected void updateUsingMouthItem(ItemStack p_147201_) {
        if (!p_147201_.isEmpty()) {
            this.mouthItemRemaining = EventHooks.onItemUseTick((LivingEntity)this, (ItemStack)p_147201_, (int)this.mouthItemRemaining);
        }
        if (this.mouthItemRemaining > 0) {
            p_147201_.onUseTick(this.level(), (LivingEntity)this, this.mouthItemRemaining);
        }
        if (--this.mouthItemRemaining <= 0 && !this.level().isClientSide() && !p_147201_.useOnRelease()) {
            this.completeUsingMouth();
            this.stopUsingMouth();
        }
    }

    protected void completeUsingMouth() {
        FoodProperties foodProperties = (FoodProperties)this.getMouthItem().get(DataComponents.FOOD);
        if (foodProperties != null) {
            this.heal(foodProperties.nutrition());
        }
        this.getMouthItem().finishUsingItem(this.level(), (LivingEntity)this);
        this.setMouthItem(ItemStack.EMPTY);
    }

    protected void stopUsingMouth() {
        this.useMouthItem = ItemStack.EMPTY;
        this.mouthItemRemaining = 0;
        this.setUsingMouthItem(false);
    }

    private ItemStack findFood() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || itemstack.get(DataComponents.FOOD) == null || !HunterConfigUtils.isWhitelistedItem(itemstack.getItem())) continue;
            return itemstack.split(1);
        }
        return ItemStack.EMPTY;
    }

    private ItemStack findBoomerang() {
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.inventory.getItem(i);
            if (itemstack.isEmpty() || !itemstack.is((Item)HunterItems.BOOMERANG.get())) continue;
            return itemstack.split(1);
        }
        return ItemStack.EMPTY;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.FOLLOW_RANGE, 20.0).add(Attributes.MAX_HEALTH, 26.0).add(Attributes.ARMOR, 1.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public void addAdditionalSaveData(ValueOutput p_213281_1_) {
        super.addAdditionalSaveData(p_213281_1_);
        if (!this.getMouthItem().isEmpty()) {
            p_213281_1_.store("mouth_item", ItemStack.CODEC, (Object)this.getMouthItem());
        }
        if (this.homeTarget != null) {
            p_213281_1_.store("HomeTarget", BlockPos.CODEC, (Object)this.homeTarget);
        }
        this.writeInventoryToTag(p_213281_1_);
        p_213281_1_.putInt("HuntingCooldown", this.huntCooldown);
        p_213281_1_.store("hunter_variant", HunterVariant.CODEC, this.getHunterVariant());
    }

    public void readAdditionalSaveData(ValueInput nbt) {
        super.readAdditionalSaveData(nbt);
        Optional optional = nbt.read("hunter_variant", HunterVariant.CODEC);
        if (optional.isPresent()) {
            this.setHunterVariant((Holder<HunterVariant>)((Holder)optional.get()));
        }
        this.setMouthItem(nbt.read("mouth_item", ItemStack.CODEC).orElse(ItemStack.EMPTY));
        this.homeTarget = nbt.read("HomeTarget", BlockPos.CODEC).orElse(null);
        this.readInventoryFromTag(nbt);
        this.huntCooldown = nbt.getInt("HuntingCooldown").orElse(0);
        this.setCanPickUpLoot(true);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public void applyRaidBuffs(ServerLevel p_348605_, int p_37844_, boolean p_37845_) {
        boolean flag;
        ItemStack offHandStack = new ItemStack((ItemLike)HunterItems.BOOMERANG.get());
        Registry enchantment = p_348605_.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        Raid raid = this.getCurrentRaid();
        int i = 1;
        if (p_37844_ > raid.getNumGroups(Difficulty.NORMAL)) {
            i = 2;
        }
        ItemStack itemstack = raid.getRaidOmenLevel() < 2 || p_37844_ <= raid.getNumGroups(Difficulty.NORMAL) ? (this.random.nextBoolean() ? new ItemStack((ItemLike)HunterItems.MINI_CROSSBOW.asItem()) : new ItemStack((ItemLike)Items.COPPER_SWORD)) : (this.random.nextBoolean() ? new ItemStack((ItemLike)HunterItems.MINI_CROSSBOW.asItem()) : new ItemStack((ItemLike)Items.IRON_SWORD));
        this.inventory.addItem(new ItemStack((ItemLike)Items.PORKCHOP, 5));
        boolean bl = flag = this.random.nextFloat() <= raid.getEnchantOdds();
        if (flag) {
            if (itemstack.getItem() == HunterItems.MINI_CROSSBOW.asItem()) {
                if (this.random.nextBoolean()) {
                    itemstack.enchant((Holder)enchantment.getOrThrow(Enchantments.PIERCING), i);
                } else {
                    itemstack.enchant((Holder)enchantment.getOrThrow(Enchantments.MULTISHOT), 1);
                }
            } else {
                itemstack.enchant((Holder)enchantment.getOrThrow(Enchantments.SHARPNESS), i);
            }
            this.inventory.addItem(new ItemStack((ItemLike)Items.COOKED_BEEF, 2));
            offHandStack.enchant((Holder)enchantment.getOrThrow(HunterEnchantments.CUTTING), i);
        }
        if (this.random.nextFloat() < 0.25f && !itemstack.is(HunterItems.MINI_CROSSBOW)) {
            offHandStack.enchant((Holder)enchantment.getOrThrow(HunterEnchantments.RETURN), i);
            this.setItemInHand(InteractionHand.OFF_HAND, offHandStack);
        }
        if (itemstack.is(HunterItems.MINI_CROSSBOW)) {
            this.setItemInHand(InteractionHand.OFF_HAND, HunterItems.MINI_CROSSBOW.toStack());
        }
        if (this.random.nextFloat() < 0.25f) {
            this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.LEATHER_HELMET));
        }
        ItemStack stack = new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE);
        if (this.random.nextFloat() < 0.5f) {
            stack = new ItemStack((ItemLike)Items.COPPER_CHESTPLATE);
        }
        Registry registrylookup1 = this.registryAccess().lookupOrThrow(Registries.TRIM_MATERIAL);
        Registry registrylookup2 = this.registryAccess().lookupOrThrow(Registries.TRIM_PATTERN);
        stack.set(DataComponents.TRIM, (Object)new ArmorTrim((Holder)registrylookup1.getOrThrow(TrimMaterials.EMERALD), (Holder)registrylookup2.getOrThrow(TrimPatterns.SENTRY)));
        this.setItemSlot(EquipmentSlot.CHEST, stack);
        this.setDropChance(EquipmentSlot.CHEST, 0.0f);
        this.setItemInHand(InteractionHand.MAIN_HAND, itemstack);
    }

    protected void pickUpItem(ServerLevel p_376160_, ItemEntity p_175445_1_) {
        ItemStack itemstack = p_175445_1_.getItem();
        if (itemstack.getItem() instanceof BannerItem) {
            super.pickUpItem(p_376160_, p_175445_1_);
        } else {
            Item item = itemstack.getItem();
            if (this.wantsFood(itemstack)) {
                this.onItemPickup(p_175445_1_);
                this.take((Entity)p_175445_1_, itemstack.getCount());
                ItemStack itemstack1 = this.inventory.addItem(itemstack);
                if (itemstack1.isEmpty()) {
                    p_175445_1_.discard();
                } else {
                    itemstack.setCount(itemstack1.getCount());
                }
            } else if (item == HunterItems.BOOMERANG.get()) {
                this.onItemPickup(p_175445_1_);
                this.take((Entity)p_175445_1_, itemstack.getCount());
                ItemStack itemstack1 = this.inventory.addItem(itemstack);
                if (itemstack1.isEmpty()) {
                    p_175445_1_.discard();
                } else {
                    itemstack.setCount(itemstack1.getCount());
                }
            }
        }
    }

    private boolean wantsFood(ItemStack p_213672_1_) {
        return p_213672_1_.get(DataComponents.FOOD) != null && HunterConfigUtils.isWhitelistedItem(p_213672_1_.getItem());
    }

    @org.jetbrains.annotations.Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, EntitySpawnReason p_37858_, @org.jetbrains.annotations.Nullable SpawnGroupData p_37859_) {
        Item item;
        RandomSource randomsource = p_37856_.getRandom();
        SpawnGroupData ilivingentitydata = super.finalizeSpawn(p_37856_, p_37857_, p_37858_, p_37859_);
        this.getNavigation().setCanOpenDoors(true);
        this.setCanPickUpLoot(true);
        Holder holder = p_37856_.getBiome(this.blockPosition());
        this.setHunterVariant(HunterVariants.getSpawnVariant(this.registryAccess(), (Holder<Biome>)holder));
        if (!((List)HunterConfig.COMMON.foodInInventoryWhitelist.get()).isEmpty() && (item = (Item)BuiltInRegistries.ITEM.getValue(Identifier.tryParse((String)((String)((List)HunterConfig.COMMON.foodInInventoryWhitelist.get()).get(this.random.nextInt(((List)HunterConfig.COMMON.foodInInventoryWhitelist.get()).size())))))) != Items.AIR) {
            this.inventory.addItem(new ItemStack((ItemLike)item, 3 + this.random.nextInt(3)));
        }
        if (p_37858_ == EntitySpawnReason.STRUCTURE) {
            this.setHomeTarget(this.blockPosition());
        } else {
            this.populateDefaultEquipmentSlots(randomsource, p_37857_);
        }
        this.populateDefaultEquipmentEnchantments(p_37856_, randomsource, p_37857_);
        return ilivingentitydata;
    }

    protected void dropEquipment(ServerLevel serverLevel) {
        super.dropEquipment(serverLevel);
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.inventory.getItem(i);
                if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                this.spawnAtLocation(serverLevel, itemstack);
            }
        }
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_217055_, DifficultyInstance p_217056_) {
        if (this.getCurrentRaid() == null) {
            if (this.getMainHandItem().isEmpty()) {
                if (this.random.nextFloat() < 0.1f) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)HunterItems.MINI_CROSSBOW.asItem()));
                    this.setItemSlot(EquipmentSlot.OFFHAND, this.createHorn());
                } else if (this.random.nextFloat() < 0.5f) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)HunterItems.MINI_CROSSBOW.asItem()));
                    this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)HunterItems.MINI_CROSSBOW.asItem()));
                } else {
                    this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.WOODEN_SWORD));
                    if (this.random.nextBoolean()) {
                        ItemStack offHandStack = new ItemStack((ItemLike)HunterItems.BOOMERANG.get());
                        this.setItemInHand(InteractionHand.OFF_HAND, offHandStack);
                    }
                }
            }
            if (this.random.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.LEATHER_HELMET));
            }
            if (this.random.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.LEATHER_CHESTPLATE));
            }
        }
    }

    public ItemStack createHorn() {
        Optional holderset = this.registryAccess().lookupOrThrow(Registries.INSTRUMENT).get(Instruments.CALL_GOAT_HORN);
        if (holderset.isPresent()) {
            return InstrumentItem.create((Item)Items.GOAT_HORN, (Holder)((Holder)holderset.get()));
        }
        return ItemStack.EMPTY;
    }

    public SoundEvent getCelebrateSound() {
        return HunterSounds.HUNTER_ILLAGER_CHEER.get();
    }

    protected SoundEvent getAmbientSound() {
        return HunterSounds.HUNTER_ILLAGER_IDLE.get();
    }

    protected SoundEvent getDeathSound() {
        return HunterSounds.HUNTER_ILLAGER_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource p_184601_1_) {
        return HunterSounds.HUNTER_ILLAGER_HURT.get();
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isAggressive()) {
            if (this.isChargingCrossbow()) {
                return AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE;
            }
            if (this.isHolding(is -> is.getItem() instanceof CrossbowItem)) {
                return AbstractIllager.IllagerArmPose.CROSSBOW_HOLD;
            }
            return this.isHolding(Items.BOW) || this.isHolding((Item)HunterItems.BOOMERANG.get()) ? AbstractIllager.IllagerArmPose.BOW_AND_ARROW : AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.isCelebrating() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.CROSSED;
    }

    public boolean killedEntity(ServerLevel p_216988_, LivingEntity p_216989_, DamageSource damageSource) {
        this.playSound(HunterSounds.HUNTER_ILLAGER_LAUGH.get(), this.getSoundVolume(), this.getVoicePitch());
        this.huntCooldown = 300;
        return super.killedEntity(p_216988_, p_216989_, damageSource);
    }

    public void setHomeTarget(@Nullable BlockPos p_213726_1_) {
        this.homeTarget = p_213726_1_;
    }

    @Nullable
    private BlockPos getHomeTarget() {
        return this.homeTarget;
    }

    public void performRangedAttack(LivingEntity p_32141_, float p_32142_) {
        ItemStack weapon = this.getItemInHand(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
        ItemStack itemstack1 = this.getProjectile(weapon);
        AbstractArrow abstractarrow = this.getArrow(itemstack1, p_32142_, weapon);
        Item item2 = weapon.getItem();
        if (item2 instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weaponItem = (ProjectileWeaponItem)item2;
            abstractarrow = weaponItem.customArrow(abstractarrow, itemstack1, weapon);
        }
        double d0 = p_32141_.getX() - this.getX();
        double d1 = p_32141_.getY(0.3333333333333333) - abstractarrow.getY();
        double d2 = p_32141_.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Projectile.spawnProjectileUsingShoot((Projectile)abstractarrow, (ServerLevel)serverlevel, (ItemStack)itemstack1, (double)d0, (double)(d1 + d3 * (double)0.2f), (double)d2, (float)1.6f, (float)(13 - serverlevel.getDifficulty().getId() * 4));
        }
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack p_32156_, float p_32157_, @Nullable ItemStack p_346155_) {
        return ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)p_32156_, (float)p_32157_, (ItemStack)p_346155_);
    }

    public boolean canUseNonMeleeWeapon(ItemStack p_478227_) {
        return p_478227_.is(Items.BOW) || p_478227_.getItem() instanceof CrossbowItem;
    }

    public void performBoomerangAttack(LivingEntity p_82196_1_) {
        BoomerangEntity boomerang = new BoomerangEntity(this.level(), (LivingEntity)this, this.getOffhandItem().split(1));
        double d0 = p_82196_1_.getX() - this.getX();
        double d1 = p_82196_1_.getY(0.3333333333333333) - boomerang.getY();
        double d2 = p_82196_1_.getZ() - this.getZ();
        double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
        boomerang.shoot(d0, d1 + d3 * (double)0.2f, d2, 0.8f, 14 - this.level().getDifficulty().getId() * 4);
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)boomerang);
        this.level().broadcastEntityEvent((Entity)this, (byte)62);
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.entityData.get(IS_CHARGING_CROSSBOW);
    }

    public void setChargingCrossbow(boolean p_33302_) {
        this.entityData.set(IS_CHARGING_CROSSBOW, (Object)p_33302_);
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public class GetFoodGoal<T extends Hunter>
    extends Goal {
        private final T mob;

        /*
         * WARNING - Possible parameter corruption
         */
        public GetFoodGoal(T p_i50572_2_) {
            this.mob = p_i50572_2_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!this.mob.hasActiveRaid()) {
                List list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(16.0, 8.0, 16.0), ALLOWED_ITEMS);
                if (!list.isEmpty() && this.mob.hasLineOfSight((Entity)list.get(0))) {
                    return this.mob.getNavigation().moveTo((Entity)list.get(0), (double)1.1f);
                }
                return false;
            }
            return false;
        }

        public void tick() {
            Level level;
            List list;
            if (this.mob.getNavigation().getTargetPos().closerThan((Vec3i)this.mob.blockPosition(), 1.414) && !(list = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(4.0, 4.0, 4.0), ALLOWED_ITEMS)).isEmpty() && (level = this.mob.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ((Hunter)((Object)this.mob)).pickUpItem(serverLevel, (ItemEntity)list.get(0));
            }
        }
    }

    class MoveToGoal
    extends Goal {
        final Hunter hunter;
        final double stopDistance;
        final double speedModifier;

        MoveToGoal(Hunter p_i50459_2_, double p_i50459_3_, double p_i50459_5_) {
            this.hunter = p_i50459_2_;
            this.stopDistance = p_i50459_3_;
            this.speedModifier = p_i50459_5_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public void stop() {
            Hunter.this.navigation.stop();
        }

        public boolean canUse() {
            BlockPos blockpos = this.hunter.getHomeTarget();
            double distance = this.hunter.level().isBrightOutside() ? this.stopDistance : this.stopDistance / 1.5;
            return blockpos != null && this.isTooFarAway(blockpos, distance);
        }

        public void tick() {
            BlockPos blockpos = this.hunter.getHomeTarget();
            if (blockpos != null && Hunter.this.navigation.isDone()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vec3 vector3d = new Vec3((double)blockpos.getX() - this.hunter.getX(), (double)blockpos.getY() - this.hunter.getY(), (double)blockpos.getZ() - this.hunter.getZ()).normalize();
                    Vec3 vector3d1 = vector3d.scale(10.0).add(this.hunter.getX(), this.hunter.getY(), this.hunter.getZ());
                    Hunter.this.navigation.moveTo(vector3d1.x, vector3d1.y, vector3d1.z, this.speedModifier);
                } else {
                    Hunter.this.navigation.moveTo((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.closerThan((Vec3i)this.hunter.blockPosition(), p_220846_2_);
        }
    }
}

