/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.client.render.layer;

import baguchi.hunters_return.client.model.HunterModel;
import baguchi.hunters_return.client.render.state.HunterRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.object.skull.SkullModelBase;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Util;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.SkullBlock;
import org.joml.Quaternionfc;

public class CustomHunterHeadLayer<S extends HunterRenderState, M extends HunterModel<S>>
extends RenderLayer<S, M> {
    private static final float ITEM_SCALE = 0.625f;
    private static final float SKULL_SCALE = 1.1875f;
    private final CustomHeadLayer.Transforms transforms;
    private final Function<SkullBlock.Type, SkullModelBase> skullModels;
    private final PlayerSkinRenderCache playerSkinRenderCache;

    public CustomHunterHeadLayer(RenderLayerParent<S, M> renderer, EntityModelSet modelSet, PlayerSkinRenderCache playerSkinRenderCache) {
        this(renderer, modelSet, playerSkinRenderCache, CustomHeadLayer.Transforms.DEFAULT);
    }

    public CustomHunterHeadLayer(RenderLayerParent<S, M> renderer, EntityModelSet modelSet, PlayerSkinRenderCache playerSkinRenderCache, CustomHeadLayer.Transforms transforms) {
        super(renderer);
        this.transforms = transforms;
        this.skullModels = Util.memoize(type -> SkullBlockRenderer.createModel((EntityModelSet)modelSet, (SkullBlock.Type)type));
        this.playerSkinRenderCache = playerSkinRenderCache;
    }

    public void submit(PoseStack poseStack, SubmitNodeCollector submitNodeCollector, int lightCoords, S state, float yRot, float xRot) {
        if (!((HunterRenderState)((Object)state)).headItem.isEmpty() || ((HunterRenderState)((Object)state)).wornHeadType != null) {
            poseStack.pushPose();
            poseStack.scale(this.transforms.horizontalScale(), 1.0f, this.transforms.horizontalScale());
            HunterModel parentModel = (HunterModel)this.getParentModel();
            parentModel.translateToHead(parentModel.head, poseStack);
            if (((HunterRenderState)((Object)state)).wornHeadType != null) {
                poseStack.translate(0.0f, this.transforms.skullYOffset(), 0.0f);
                poseStack.scale(1.1875f, -1.1875f, -1.1875f);
                poseStack.translate(-0.5, 0.0, -0.5);
                SkullBlock.Type type = ((HunterRenderState)((Object)state)).wornHeadType;
                SkullModelBase skullModel = this.skullModels.apply(type);
                RenderType renderType = this.resolveSkullRenderType((LivingEntityRenderState)state, type);
                SkullBlockRenderer.submitSkull(null, (float)180.0f, (float)((HunterRenderState)((Object)state)).wornHeadAnimationPos, (PoseStack)poseStack, (SubmitNodeCollector)submitNodeCollector, (int)lightCoords, (SkullModelBase)skullModel, (RenderType)renderType, (int)((HunterRenderState)((Object)state)).outlineColor, null);
            } else {
                CustomHunterHeadLayer.translateToHead(poseStack, this.transforms);
                ((HunterRenderState)((Object)state)).headItem.submit(poseStack, submitNodeCollector, lightCoords, OverlayTexture.NO_OVERLAY, ((HunterRenderState)((Object)state)).outlineColor);
            }
            poseStack.popPose();
        }
    }

    private RenderType resolveSkullRenderType(LivingEntityRenderState state, SkullBlock.Type type) {
        ResolvableProfile profile;
        if (type == SkullBlock.Types.PLAYER && (profile = state.wornHeadProfile) != null) {
            return this.playerSkinRenderCache.getOrDefault(profile).renderType();
        }
        return SkullBlockRenderer.getSkullRenderType((SkullBlock.Type)type, null);
    }

    public static void translateToHead(PoseStack poseStack, CustomHeadLayer.Transforms transforms) {
        poseStack.translate(0.0f, -0.25f + transforms.yOffset(), 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        poseStack.scale(0.625f, -0.625f, -0.625f);
    }
}

