/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.api;

import baguchi.hunters_return.data.resources.registries.HunterVariants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class HunterVariant {
    public static final Codec<HunterVariant> DIRECT_CODEC = RecordCodecBuilder.create(p_332779_ -> p_332779_.group((App)Identifier.CODEC.fieldOf("texture").forGetter(p_335261_ -> p_335261_.texture), (App)Identifier.CODEC.optionalFieldOf("texture_old").forGetter(p_335261_ -> p_335261_.textureOld), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(HunterVariant::biomes)).apply((Applicative)p_332779_, HunterVariant::new));
    public static final Codec<Holder<HunterVariant>> CODEC = RegistryFileCodec.create(HunterVariants.HUNTER_VARIANT_KEY, DIRECT_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<HunterVariant>> STREAM_CODEC = ByteBufCodecs.holderRegistry(HunterVariants.HUNTER_VARIANT_KEY);
    private final Identifier texture;
    private final Identifier textureFull;
    private final Optional<Identifier> textureOld;
    private final Optional<Identifier> textureOldFull;
    private final HolderSet<Biome> biomes;

    public HunterVariant(Identifier p_332712_, Optional<Identifier> oldTexture, HolderSet<Biome> p_332717_) {
        this.texture = p_332712_;
        this.textureFull = HunterVariant.fullTextureId(p_332712_);
        this.textureOld = oldTexture;
        this.textureOldFull = oldTexture.isPresent() ? Optional.of(HunterVariant.fullTextureId(oldTexture.get())) : Optional.empty();
        this.biomes = p_332717_;
    }

    private static Identifier fullTextureId(Identifier p_336042_) {
        return p_336042_.withPath(p_335262_ -> "textures/" + p_335262_ + ".png");
    }

    public Identifier texture() {
        return this.textureFull;
    }

    public Optional<Identifier> textureOld() {
        return this.textureOldFull;
    }

    public HolderSet<Biome> biomes() {
        return this.biomes;
    }

    public boolean equals(Object p_332811_) {
        boolean bl;
        if (p_332811_ == this) {
            return true;
        }
        if (!(p_332811_ instanceof HunterVariant)) {
            bl = false;
        } else {
            HunterVariant hunterVariant = (HunterVariant)p_332811_;
            bl = Objects.equals(this.texture, hunterVariant.texture) && Objects.equals(this.biomes, hunterVariant.biomes);
        }
        return bl;
    }

    public int hashCode() {
        int i = 1;
        i = 31 * i + this.texture.hashCode();
        i = 31 * i + this.textureOld.hashCode();
        return 31 * i + this.biomes.hashCode();
    }
}

