/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.items;

import de.maxhenkel.easyvillagers.EasyVillagersMod;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.datacomponents.VillagerData;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.items.ClientVillagerItemUtils;
import de.maxhenkel.easyvillagers.items.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;

public class VillagerItem
extends Item {
    public VillagerItem(Item.Properties properties) {
        super(properties.stacksTo(1));
        DispenserBlock.registerBehavior((ItemLike)this, (source, stack) -> {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos blockpos = source.pos().relative(direction);
            ServerLevel world = source.level();
            EasyVillagerEntity villager = VillagerData.getOrCreate(stack).createEasyVillager((Level)world, stack);
            villager.snapTo((double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5, direction.toYRot(), 0.0f);
            world.addFreshEntity((Entity)villager);
            stack.shrink(1);
            return stack;
        });
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = world.getBlockState(blockpos);
        if (!blockstate.getCollisionShape((BlockGetter)world, blockpos).isEmpty()) {
            blockpos = blockpos.relative(direction);
        }
        EasyVillagerEntity villager = VillagerData.getOrCreate(itemstack).createEasyVillager(world, itemstack);
        villager.setPos((double)blockpos.getX() + 0.5, blockpos.getY(), (double)blockpos.getZ() + 0.5);
        if (world.addFreshEntity((Entity)villager)) {
            itemstack.shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public Component getName(ItemStack stack) {
        Component clientName;
        if (FMLEnvironment.getDist().isClient() && (clientName = ClientVillagerItemUtils.getClientName(stack)) != null) {
            return clientName;
        }
        return super.getName(stack);
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot equipmentSlot) {
        super.inventoryTick(stack, level, entity, equipmentSlot);
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!((Boolean)EasyVillagersMod.SERVER_CONFIG.villagerInventorySounds.get()).booleanValue()) {
            return;
        }
        VillagerBlockBase.playRandomVillagerSound(player, SoundEvents.VILLAGER_AMBIENT);
    }

    public static ItemStack createBabyVillager() {
        ItemStack babyVillager = new ItemStack((ItemLike)ModItems.VILLAGER.get());
        CompoundTag compound = new CompoundTag();
        compound.putInt("Age", -24000);
        VillagerData data = VillagerData.of(compound);
        babyVillager.set(ModItems.VILLAGER_DATA_COMPONENT, (Object)data);
        return babyVillager;
    }
}

