/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.tileentity.IronFarmTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.IronFarmRenderState;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import java.lang.ref.WeakReference;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.ZombieRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.golem.IronGolem;
import net.minecraft.world.entity.monster.zombie.Zombie;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class IronFarmRenderer
extends VillagerRendererBase<IronFarmTileentity, IronFarmRenderState> {
    private WeakReference<Zombie> zombieCache = new WeakReference<Object>(null);
    private WeakReference<ZombieRenderer> zombieRendererCache = new WeakReference<Object>(null);
    private WeakReference<IronGolem> ironGolemCache = new WeakReference<Object>(null);
    private WeakReference<IronGolemRenderer> ironGolemRendererCache = new WeakReference<Object>(null);

    public IronFarmRenderer(EntityModelSet entityModelSet) {
        super(entityModelSet);
    }

    public IronFarmRenderState createRenderState() {
        return new IronFarmRenderState();
    }

    public void extractRenderState(IronFarmTileentity ironFarm, IronFarmRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)ironFarm, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        state.apply(ironFarm);
        state.renderVillager = false;
        if (ironFarm.getVillagerEntity() != null) {
            state.renderVillager = true;
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.extractRenderState((Villager)ironFarm.getVillagerEntity(), state.villagerRenderState, partialTicks);
            state.villagerRenderState.lightCoords = IronFarmRenderer.getLightOrDefault(ironFarm, state);
        }
        state.renderIronGolem = false;
        if (ironFarm.getTimer() >= (long)IronFarmTileentity.getGolemSpawnTime() && ironFarm.getTimer() < (long)IronFarmTileentity.getGolemKillTime()) {
            state.renderIronGolem = true;
            state.ironGolemRenderState.hasRedOverlay = ironFarm.getTimer() % 20L < 10L;
            state.ironGolemRenderState.lightCoords = IronFarmRenderer.getLightOrDefault(ironFarm, state);
        }
        state.zombieRenderState.lightCoords = IronFarmRenderer.getLightOrDefault(ironFarm, state);
    }

    public void submit(IronFarmRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        IronGolemRenderer ironGolemRenderer;
        IronGolem ironGolem;
        ZombieRenderer zombieRenderer;
        stack.pushPose();
        Zombie zombie = (Zombie)this.zombieCache.get();
        if (zombie == null) {
            zombie = new Zombie((Level)IronFarmRenderer.minecraft.level);
            this.zombieCache = new WeakReference<Zombie>(zombie);
        }
        if ((zombieRenderer = (ZombieRenderer)this.zombieRendererCache.get()) == null) {
            zombieRenderer = new ZombieRenderer(IronFarmRenderer.createEntityRenderer());
            this.zombieRendererCache = new WeakReference<ZombieRenderer>(zombieRenderer);
        }
        if ((ironGolem = (IronGolem)this.ironGolemCache.get()) == null) {
            ironGolem = new IronGolem(EntityType.IRON_GOLEM, (Level)IronFarmRenderer.minecraft.level);
            this.ironGolemCache = new WeakReference<IronGolem>(ironGolem);
        }
        if ((ironGolemRenderer = (IronGolemRenderer)this.ironGolemRendererCache.get()) == null) {
            ironGolemRenderer = new IronGolemRenderer(IronFarmRenderer.createEntityRenderer());
            this.ironGolemRendererCache = new WeakReference<IronGolemRenderer>(ironGolemRenderer);
        }
        if (state.renderVillager) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.translate(-0.3125, 0.0, -0.3125);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            stack.scale(0.3f, 0.3f, 0.3f);
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.submit((LivingEntityRenderState)state.villagerRenderState, stack, collector, cameraRenderState);
            stack.popPose();
        }
        stack.pushPose();
        stack.translate(0.5, 0.0625, 0.5);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
        stack.translate(0.3125, 0.0, -0.3125);
        stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
        stack.scale(0.3f, 0.3f, 0.3f);
        zombieRenderer.submit((LivingEntityRenderState)state.zombieRenderState, stack, collector, cameraRenderState);
        stack.popPose();
        if (state.renderIronGolem) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.translate(0.0, 0.0, 0.1875);
            stack.scale(0.3f, 0.3f, 0.3f);
            ironGolemRenderer.submit((LivingEntityRenderState)state.ironGolemRenderState, stack, collector, cameraRenderState);
            stack.popPose();
        }
        stack.popPose();
    }
}

