/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.maxhenkel.easyvillagers.blocks.tileentity.FarmerTileentity;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.FarmerRenderState;
import de.maxhenkel.easyvillagers.blocks.tileentity.render.VillagerRendererBase;
import de.maxhenkel.easyvillagers.corelib.client.RenderUtils;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class FarmerRenderer
extends VillagerRendererBase<FarmerTileentity, FarmerRenderState> {
    private final BlockRenderDispatcher blockRenderer;

    public FarmerRenderer(EntityModelSet entityModelSet, BlockRenderDispatcher blockRenderer) {
        super(entityModelSet);
        this.blockRenderer = blockRenderer;
    }

    public FarmerRenderState createRenderState() {
        return new FarmerRenderState();
    }

    public void extractRenderState(FarmerTileentity farmer, FarmerRenderState state, float partialTicks, Vec3 pos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)farmer, (BlockEntityRenderState)state, partialTicks, pos, crumblingOverlay);
        state.apply(farmer);
        state.renderVillager = false;
        if (farmer.getVillagerEntity() != null) {
            state.renderVillager = true;
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.extractRenderState((Villager)farmer.getVillagerEntity(), state.villagerRenderState, partialTicks);
            state.villagerRenderState.lightCoords = FarmerRenderer.getLightOrDefault(farmer, state);
        }
        state.crop = farmer.getCrop();
    }

    public void submit(FarmerRenderState state, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraRenderState) {
        BlockState crop;
        stack.pushPose();
        if (state.renderVillager) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.translate(0.0, 0.0, -0.25);
            stack.scale(0.45f, 0.45f, 0.45f);
            VillagerRenderer villagerRenderer = this.getVillagerRenderer();
            villagerRenderer.submit((LivingEntityRenderState)state.villagerRenderState, stack, collector, cameraRenderState);
            stack.popPose();
        }
        if ((crop = state.crop) != null) {
            stack.pushPose();
            stack.translate(0.5, 0.0625, 0.5);
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-state.direction.toYRot()));
            stack.translate(0.0, 0.0, 0.125);
            stack.translate(-0.5, 0.0, -0.5);
            stack.scale(0.45f, 0.45f, 0.45f);
            stack.translate(0.6111111111111112, 0.0, 0.6111111111111112);
            if (FarmerRenderer.minecraft.level != null) {
                int color = minecraft.getBlockColors().getColor(crop, null, null, 0);
                collector.submitBlockModel(stack, RenderTypes.entityCutout((Identifier)TextureAtlas.LOCATION_BLOCKS), this.blockRenderer.getBlockModel(crop), RenderUtils.getRedFloat(color), RenderUtils.getGreenFloat(color), RenderUtils.getBlueFloat(color), state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            }
            stack.popPose();
        }
        stack.popPose();
    }
}

