/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.blocks.tileentity;

import de.maxhenkel.easyvillagers.blocks.InventoryViewerBlock;
import de.maxhenkel.easyvillagers.blocks.ModBlocks;
import de.maxhenkel.easyvillagers.blocks.VillagerBlockBase;
import de.maxhenkel.easyvillagers.blocks.tileentity.ModTileEntities;
import de.maxhenkel.easyvillagers.blocks.tileentity.VillagerTileentity;
import de.maxhenkel.easyvillagers.corelib.blockentity.IServerTickableBlockEntity;
import de.maxhenkel.easyvillagers.corelib.inventory.ItemListInventory;
import de.maxhenkel.easyvillagers.entity.EasyVillagerEntity;
import de.maxhenkel.easyvillagers.gui.VillagerArmorContainer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.transfer.EmptyResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.item.VanillaContainerWrapper;

public class InventoryViewerTileentity
extends VillagerTileentity
implements IServerTickableBlockEntity {
    public InventoryViewerTileentity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.INVENTORY_VIEWER.get(), ((InventoryViewerBlock)((Object)ModBlocks.INVENTORY_VIEWER.get())).defaultBlockState(), pos, state);
    }

    @Override
    public void tickServer() {
        if (this.hasVillager()) {
            VillagerBlockBase.playRandomVillagerSound(this.level, this.getBlockPos(), SoundEvents.VILLAGER_AMBIENT);
        }
    }

    @Nullable
    public Container getVillagerInventory() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v == null) {
            return null;
        }
        return new ItemListInventory((NonNullList<ItemStack>)v.getInventory().getItems(), this::setChanged);
    }

    @Nullable
    public Container getVillagerArmorInventory() {
        EasyVillagerEntity v = this.getVillagerEntity();
        if (v == null) {
            return null;
        }
        return new VillagerArmorContainer(v, this::setChanged);
    }

    public ResourceHandler<ItemResource> getItemHandler() {
        Container inv = this.getVillagerInventory();
        if (inv == null) {
            return EmptyResourceHandler.instance();
        }
        return VanillaContainerWrapper.of((Container)inv);
    }

    public void setChanged() {
        super.setChanged();
        this.saveVillagerEntity();
        if (this.level != null) {
            this.level.invalidateCapabilities(this.worldPosition);
        }
    }
}

