/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.GuiGraphicsHelper;
import com.supermartijn642.core.gui.widget.ContainerWidget;
import com.supermartijn642.core.gui.widget.MutableWidgetRenderContext;
import com.supermartijn642.core.gui.widget.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.common.NeoForge;

public class WidgetContainerScreen<T extends Widget, X extends BaseContainer>
extends AbstractContainerScreen<X> {
    private final MutableWidgetRenderContext widgetRenderContext = MutableWidgetRenderContext.create();
    protected final X container;
    protected final T widget;
    private boolean initialized = false;
    private final boolean drawSlots;
    private final boolean isPauseScreen;
    private boolean dragging = false;

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots, isPauseScreen);
    }

    public static <T extends Widget, X extends BaseContainer> WidgetContainerScreen<T, X> of(T widget, X container, boolean drawSlots) {
        return new WidgetContainerScreen<T, X>(widget, container, drawSlots);
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots, boolean isPauseScreen) {
        super(container, ((BaseContainer)((Object)container)).player.getInventory(), (Component)TextComponents.empty().get());
        this.widget = widget;
        this.container = container;
        this.drawSlots = drawSlots;
        this.isPauseScreen = isPauseScreen;
    }

    public WidgetContainerScreen(T widget, X container, boolean drawSlots) {
        this(widget, container, drawSlots, false);
    }

    public void init() {
        if (!this.initialized) {
            if (this.widget instanceof ContainerWidget) {
                ((ContainerWidget)this.widget).initialize(this.container);
            } else {
                this.widget.initialize();
            }
            this.initialized = true;
        }
        this.imageWidth = this.widget.width();
        this.imageHeight = this.widget.height();
        super.init();
    }

    public void onClose() {
        this.widget.discard();
        super.onClose();
    }

    protected void containerTick() {
        this.widget.update();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.widgetRenderContext.update(guiGraphics, partialTicks, this.font, this.minecraft);
        GuiGraphicsHelper helper = GuiGraphicsHelper.of(guiGraphics);
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int offsetMouseX = mouseX - offsetX;
        int offsetMouseY = mouseY - offsetY;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY);
        if (!this.dragging) {
            this.widget.setFocused(offsetMouseX >= 0 && offsetMouseX < this.widget.width() && offsetMouseY >= 0 && offsetMouseY < this.widget.height());
        }
        this.widget.renderBackground(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        if (this.drawSlots) {
            for (Slot slot : ((BaseContainer)((Object)this.container)).slots) {
                helper.submitDefaultSlot(slot.x - 1, slot.y - 1);
            }
        }
        this.widget.render(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        this.hoveredSlot = null;
        for (Slot slot : ((BaseContainer)((Object)this.container)).slots) {
            if (!slot.isActive()) continue;
            if (this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) {
                this.hoveredSlot = slot;
                helper.submitSprite(AbstractContainerScreen.SLOT_HIGHLIGHT_BACK_SPRITE, (float)(slot.x - 4), (float)(slot.y - 4), 24.0f, 24.0f);
            }
            this.renderSlot(guiGraphics, slot, mouseX, mouseY);
            if (this.hoveredSlot != slot) continue;
            helper.submitSprite(AbstractContainerScreen.SLOT_HIGHLIGHT_FRONT_SPRITE, (float)(slot.x - 4), (float)(slot.y - 4), 24.0f, 24.0f);
        }
        this.widget.renderForeground(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        NeoForge.EVENT_BUS.post((Event)new ContainerScreenEvent.Render.Foreground((AbstractContainerScreen)this, guiGraphics, mouseX, mouseY));
        guiGraphics.pose().popMatrix();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderCarriedItem(guiGraphics, mouseX, mouseY);
        this.renderSnapbackItem(guiGraphics);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)offsetX, (float)offsetY);
        this.widget.renderOverlay(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        this.widget.renderTooltips(this.widgetRenderContext, helper, offsetMouseX, offsetMouseY);
        guiGraphics.pose().popMatrix();
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        int mouseY;
        this.dragging = true;
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int mouseX = (int)event.x() - offsetX;
        return this.widget.mousePressed(mouseX, mouseY = (int)event.y() - offsetY, event.buttonInfo(), isDoubleClick, false) || super.mouseClicked(event, isDoubleClick);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        int mouseY;
        this.dragging = false;
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int mouseX = (int)event.x() - offsetX;
        return this.widget.mouseReleased(mouseX, mouseY = (int)event.y() - offsetY, event.buttonInfo(), false) || super.mouseReleased(event);
    }

    public boolean mouseDragged(MouseButtonEvent event, double deltaX, double deltaY) {
        int mouseY;
        int offsetX = (this.width - this.widget.width()) / 2;
        int offsetY = (this.height - this.widget.height()) / 2;
        int mouseX = (int)event.x() - offsetX;
        return this.widget.mouseDragged(mouseX, mouseY = (int)event.y() - offsetY, event.buttonInfo(), deltaX, deltaY, false) || super.mouseDragged(event, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int offsetY;
        int offsetX = (this.width - this.widget.width()) / 2;
        return this.widget.mouseScrolled((int)(mouseX -= (double)offsetX), (int)(mouseY -= (double)(offsetY = (this.height - this.widget.height()) / 2)), verticalAmount, false) || super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.widget.keyPressed(event, false)) {
            return true;
        }
        if (ClientUtils.getMinecraft().options.keyInventory.matches(event)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean keyReleased(KeyEvent event) {
        return this.widget.keyReleased(event, false) || super.keyReleased(event);
    }

    public boolean charTyped(CharacterEvent event) {
        return this.widget.charTyped((char)event.codepoint(), false) || super.charTyped(event);
    }

    public boolean isPauseScreen() {
        return this.isPauseScreen;
    }

    public Component getNarrationMessage() {
        Component message = this.widget.getNarrationMessage();
        return message == null ? TextComponents.empty().get() : message;
    }
}

