/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.data.tag.CustomTagEntry;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.ResourceAggregator;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class TagGenerator
extends ResourceGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final ResourceAggregator<TagBuilder<?>, TagBuilder<?>> AGGREGATOR = new ResourceAggregator<TagBuilder<?>, TagBuilder<?>>(){

        @Override
        public TagBuilder<?> initialData() {
            return null;
        }

        @Override
        public TagBuilder<?> combine(TagBuilder<?> data, TagBuilder<?> newData) {
            if (data != null) {
                data.addAll(newData);
                return data;
            }
            return newData;
        }

        @Override
        public void write(OutputStream stream, TagBuilder<?> tag) throws IOException {
            JsonObject json = new JsonObject();
            json.addProperty("replace", Boolean.valueOf(tag.replace));
            JsonArray entries = new JsonArray();
            tag.entries.stream().map(entry -> (JsonElement)TagEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, entry).getOrThrow()).forEach(arg_0 -> ((JsonArray)entries).add(arg_0));
            if (!entries.isEmpty() || tag.remove.isEmpty()) {
                json.add("values", (JsonElement)entries);
            }
            JsonArray removedEntries = new JsonArray();
            tag.remove.stream().map(entry -> (JsonElement)TagEntry.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, entry).getOrThrow()).forEach(arg_0 -> ((JsonArray)removedEntries).add(arg_0));
            if (!removedEntries.isEmpty()) {
                json.add("remove", (JsonElement)removedEntries);
            }
            try (OutputStreamWriter writer = new OutputStreamWriter(stream);){
                GSON.toJson((JsonElement)json, (Appendable)writer);
            }
        }
    };
    private final Map<Registries.Registry<?>, Map<Identifier, TagBuilder<?>>> tags = new HashMap();

    public TagGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    @Override
    public void save() {
        for (Map.Entry<Registries.Registry<?>, Map<Identifier, TagBuilder<?>>> registryEntry : this.tags.entrySet()) {
            String directoryName = TagGenerator.getTagDirectoryName(registryEntry.getKey());
            for (TagBuilder<?> tag : registryEntry.getValue().values()) {
                for (TagEntry entry : tag.entries) {
                    if (!entry.isTag() || !entry.isRequired()) continue;
                    Identifier reference = entry.getId();
                    if (registryEntry.getValue().containsKey(reference) || this.cache.doesResourceExist(ResourceType.DATA, reference.getNamespace(), directoryName, reference.getPath(), ".json")) continue;
                    throw new RuntimeException("Could not find tag reference '" + String.valueOf(reference) + "' in '" + String.valueOf(tag.identifier) + "'!");
                }
                Identifier identifier = tag.identifier;
                this.cache.saveResource(ResourceType.DATA, AGGREGATOR, tag, identifier.getNamespace(), directoryName, identifier.getPath(), ".json");
            }
        }
    }

    private static String getTagDirectoryName(Registries.Registry<?> registry) {
        return net.minecraft.core.registries.Registries.tagsDirPath((ResourceKey)registry.getVanillaRegistry().key());
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, Identifier identifier) {
        this.cache.trackToBeGeneratedResource(ResourceType.DATA, identifier.getNamespace(), TagGenerator.getTagDirectoryName(registry), identifier.getPath(), ".json");
        return this.tags.computeIfAbsent(registry, o -> new HashMap()).computeIfAbsent(identifier, identifier1 -> new TagBuilder(registry, (Identifier)identifier1));
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, TagKey<T> tagKey) {
        return this.tag(registry, tagKey.location());
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, String namespace, String identifier) {
        return this.tag(registry, Identifier.fromNamespaceAndPath((String)namespace, (String)identifier));
    }

    protected <T> TagBuilder<T> tag(Registries.Registry<T> registry, String identifier) {
        return this.tag(registry, this.modid, identifier);
    }

    protected TagBuilder<Block> blockTag(Identifier identifier) {
        return this.tag(Registries.BLOCKS, identifier);
    }

    protected TagBuilder<Block> blockTag(TagKey<Block> tagKey) {
        return this.tag(Registries.BLOCKS, tagKey);
    }

    protected TagBuilder<Block> blockTag(String namespace, String identifier) {
        return this.tag(Registries.BLOCKS, namespace, identifier);
    }

    protected TagBuilder<Block> blockTag(String identifier) {
        return this.tag(Registries.BLOCKS, identifier);
    }

    protected TagBuilder<Item> itemTag(Identifier identifier) {
        return this.tag(Registries.ITEMS, identifier);
    }

    protected TagBuilder<Item> itemTag(TagKey<Item> tagKey) {
        return this.tag(Registries.ITEMS, tagKey);
    }

    protected TagBuilder<Item> itemTag(String namespace, String identifier) {
        return this.tag(Registries.ITEMS, namespace, identifier);
    }

    protected TagBuilder<Item> itemTag(String identifier) {
        return this.tag(Registries.ITEMS, identifier);
    }

    protected TagBuilder<EntityType<?>> entityTag(Identifier identifier) {
        return this.tag(Registries.ENTITY_TYPES, identifier);
    }

    protected TagBuilder<EntityType<?>> entityTag(TagKey<EntityType<?>> tagKey) {
        return this.tag(Registries.ENTITY_TYPES, tagKey);
    }

    protected TagBuilder<EntityType<?>> entityTag(String namespace, String identifier) {
        return this.tag(Registries.ENTITY_TYPES, namespace, identifier);
    }

    protected TagBuilder<EntityType<?>> entityTag(String identifier) {
        return this.tag(Registries.ENTITY_TYPES, identifier);
    }

    protected TagBuilder<Block> blockMineableWithAxe() {
        return this.blockTag((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE);
    }

    protected TagBuilder<Block> blockMineableWithHoe() {
        return this.blockTag((TagKey<Block>)BlockTags.MINEABLE_WITH_HOE);
    }

    protected TagBuilder<Block> blockMineableWithPickaxe() {
        return this.blockTag((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE);
    }

    protected TagBuilder<Block> blockMineableWithShovel() {
        return this.blockTag((TagKey<Block>)BlockTags.MINEABLE_WITH_SHOVEL);
    }

    protected TagBuilder<Block> blockNeedsStoneTool() {
        return this.blockTag((TagKey<Block>)BlockTags.NEEDS_STONE_TOOL);
    }

    protected TagBuilder<Block> blockNeedsIronTool() {
        return this.blockTag((TagKey<Block>)BlockTags.NEEDS_IRON_TOOL);
    }

    protected TagBuilder<Block> blockNeedsDiamondTool() {
        return this.blockTag((TagKey<Block>)BlockTags.NEEDS_DIAMOND_TOOL);
    }

    @Override
    public String getName() {
        return this.modName + " Tag Generator";
    }

    protected static class TagBuilder<T> {
        private final Registries.Registry<T> registry;
        protected final Identifier identifier;
        private final Set<TagEntry> entries = new HashSet<TagEntry>();
        private final Set<TagEntry> remove = new HashSet<TagEntry>();
        private boolean replace;

        protected TagBuilder(Registries.Registry<T> registry, Identifier identifier) {
            this.registry = registry;
            this.identifier = identifier;
        }

        public TagBuilder<T> replace(boolean replace) {
            this.replace = replace;
            return this;
        }

        public TagBuilder<T> replace() {
            return this.replace(true);
        }

        public TagBuilder<T> add(T entry) {
            this.entries.add(new TagEntry(this.registry.getIdentifier(entry), false, true));
            return this;
        }

        public TagBuilder<T> add(Identifier entry) {
            if (!this.registry.hasIdentifier(entry)) {
                throw new RuntimeException("Could not find any object registered under '" + String.valueOf(entry) + "'!");
            }
            this.entries.add(new TagEntry(entry, false, true));
            return this;
        }

        public TagBuilder<T> add(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.add(Identifier.fromNamespaceAndPath((String)namespace, (String)identifier));
            return this;
        }

        public TagBuilder<T> add(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Entry identifier '" + entry + "' contains invalid characters!");
            }
            this.add(Identifier.parse((String)entry));
            return this;
        }

        public TagBuilder<T> addOptional(T entry) {
            this.entries.add(new TagEntry(this.registry.getIdentifier(entry), false, false));
            return this;
        }

        public TagBuilder<T> addOptional(Identifier entry) {
            this.entries.add(new TagEntry(entry, false, false));
            return this;
        }

        public TagBuilder<T> addOptional(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.addOptional(Identifier.fromNamespaceAndPath((String)namespace, (String)identifier));
            return this;
        }

        public TagBuilder<T> addOptional(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Identifier '" + entry + "' contains invalid characters!");
            }
            this.addOptional(Identifier.parse((String)entry));
            return this;
        }

        public TagBuilder<T> addOptional(CustomTagEntry entry) {
            this.entries.add(CustomTagEntry.createVanillaEntry(entry));
            return this;
        }

        public TagBuilder<T> addReference(Identifier tag) {
            if (this.identifier.equals((Object)tag)) {
                throw new IllegalArgumentException("Cannot add self reference to tag '" + String.valueOf(tag) + "'!");
            }
            this.entries.add(new TagEntry(tag, true, true));
            return this;
        }

        public TagBuilder<T> addReference(TagKey<T> tag) {
            return this.addReference(tag.location());
        }

        public TagBuilder<T> addReference(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.entries.add(new TagEntry(Identifier.fromNamespaceAndPath((String)namespace, (String)identifier), true, true));
            return this;
        }

        public TagBuilder<T> addReference(String tag) {
            if (!RegistryUtil.isValidIdentifier(tag)) {
                throw new IllegalArgumentException("Tag identifier '" + tag + "' contains invalid characters!");
            }
            this.entries.add(new TagEntry(Identifier.parse((String)tag), true, true));
            return this;
        }

        public TagBuilder<T> addOptionalReference(Identifier tag) {
            if (this.identifier.equals((Object)tag)) {
                throw new IllegalArgumentException("Cannot add self reference to tag '" + String.valueOf(tag) + "'!");
            }
            this.entries.add(new TagEntry(tag, true, false));
            return this;
        }

        public TagBuilder<T> addOptionalReference(TagKey<T> tag) {
            return this.addOptionalReference(tag.location());
        }

        public TagBuilder<T> addOptionalReference(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.addOptionalReference(Identifier.fromNamespaceAndPath((String)namespace, (String)identifier));
            return this;
        }

        public TagBuilder<T> addOptionalReference(String tag) {
            if (!RegistryUtil.isValidIdentifier(tag)) {
                throw new IllegalArgumentException("Tag identifier '" + tag + "' contains invalid characters!");
            }
            this.addOptionalReference(Identifier.parse((String)tag));
            return this;
        }

        public TagBuilder<T> remove(T entry) {
            this.remove.add(new TagEntry(this.registry.getIdentifier(entry), false, true));
            return this;
        }

        public TagBuilder<T> remove(Identifier entry) {
            if (!this.registry.hasIdentifier(entry)) {
                throw new RuntimeException("Could not find any object registered under '" + String.valueOf(entry) + "'!");
            }
            this.remove.add(new TagEntry(entry, false, true));
            return this;
        }

        public TagBuilder<T> remove(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.remove(Identifier.fromNamespaceAndPath((String)namespace, (String)identifier));
            return this;
        }

        public TagBuilder<T> remove(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Entry identifier '" + entry + "' contains invalid characters!");
            }
            this.remove(Identifier.parse((String)entry));
            return this;
        }

        public TagBuilder<T> removeOptional(T entry) {
            return this.removeOptional(this.registry.getIdentifier(entry));
        }

        public TagBuilder<T> removeOptional(Identifier entry) {
            this.remove.add(new TagEntry(entry, false, false));
            return this;
        }

        public TagBuilder<T> removeOptional(String namespace, String identifier) {
            if (!RegistryUtil.isValidNamespace(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
            }
            if (!RegistryUtil.isValidPath(identifier)) {
                throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
            }
            this.removeOptional(Identifier.fromNamespaceAndPath((String)namespace, (String)identifier));
            return this;
        }

        public TagBuilder<T> removeOptional(String entry) {
            if (!RegistryUtil.isValidIdentifier(entry)) {
                throw new IllegalArgumentException("Identifier '" + entry + "' contains invalid characters!");
            }
            this.removeOptional(Identifier.parse((String)entry));
            return this;
        }

        private void addAll(TagBuilder<T> other) {
            this.entries.addAll(other.entries);
            this.remove.addAll(other.remove);
        }
    }
}

