/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.google.common.collect.ImmutableMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.ResourceAggregator;
import com.supermartijn642.core.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.data.HashCache;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.ApiStatus;

public abstract class ResourceCache {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public abstract boolean doesResourceExist(ResourceType var1, String var2, String var3, String var4, String var5);

    public abstract void trackToBeGeneratedResource(ResourceType var1, String var2, String var3, String var4, String var5);

    public abstract void saveResource(ResourceType var1, byte[] var2, String var3, String var4, String var5, String var6);

    public abstract <T> void saveResource(ResourceType var1, ResourceAggregator<?, T> var2, T var3, String var4, String var5, String var6, String var7);

    public void saveJsonResource(ResourceType resourceType, JsonObject json, String namespace, String directory, String fileName) {
        byte[] bytes = GSON.toJson((JsonElement)json).getBytes(StandardCharsets.UTF_8);
        this.saveResource(resourceType, bytes, namespace, directory, fileName, fileName.endsWith(".json") ? "" : ".json");
    }

    public abstract Optional<InputStream> getExistingResource(ResourceType var1, String var2, String var3, String var4, String var5);

    @ApiStatus.Internal
    public static ResourceCache wrap(HashCache hashCache, ResourceManager clientResources, ResourceManager serverResources, Path outputDirectory, Path manualDirectory) {
        return new HashCacheWrapper(outputDirectory, manualDirectory, hashCache, clientResources, serverResources);
    }

    @ApiStatus.Internal
    public static class HashCacheWrapper
    extends ResourceCache {
        private final Map<Path, HashCode> presentFiles = new HashMap<Path, HashCode>();
        private final Map<Path, HashCode> writtenFiles = new HashMap<Path, HashCode>();
        private final Map<Path, Pair<ResourceAggregator<Object, Object>, Object>> aggregatedResources = new HashMap<Path, Pair<ResourceAggregator<Object, Object>, Object>>();
        private final Set<Path> toBeGenerated = new HashSet<Path>();
        private final Path outputDirectory;
        private final Path manualDirectory;
        private final HashCache cache;
        private final ResourceManager clientResources;
        private final ResourceManager serverResources;
        private boolean allowWrites = true;
        private int writes = 0;

        HashCacheWrapper(Path outputFolder, Path manualFolder, HashCache hashCache, ResourceManager clientResources, ResourceManager serverResources) {
            if (outputFolder == null) {
                throw new IllegalArgumentException("Output directory must not be null!");
            }
            this.outputDirectory = outputFolder;
            this.manualDirectory = manualFolder;
            this.cache = hashCache;
            this.clientResources = clientResources;
            this.serverResources = serverResources;
        }

        public void readHashCache() {
            Path cachePath = this.cache.getProviderCachePath("Core Lib Generators");
            this.cache.cachePaths.add(cachePath);
            HashCache.ProviderCache providerCache = HashCache.readCache((Path)this.outputDirectory, (Path)cachePath);
            this.cache.caches.put("Core Lib Generators", providerCache);
            this.cache.initialCount += providerCache.count();
            this.cache.caches.values().stream().flatMap(cache -> cache.data().entrySet().stream()).forEach(entry -> this.presentFiles.put(this.outputDirectory.relativize((Path)entry.getKey()), (HashCode)entry.getValue()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean existsInGeneratedFiles(Path path) {
            if (this.toBeGenerated.contains(path)) return true;
            if (this.aggregatedResources.containsKey(path)) return true;
            if (this.writtenFiles.containsKey(path)) return true;
            if (!this.cache.caches.entrySet().stream().filter(entry -> this.cache.cachesToWrite.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(cache -> cache.data().entrySet().stream()).map(Map.Entry::getKey).anyMatch(this.outputDirectory.resolve(path)::equals)) return false;
            return true;
        }

        private boolean existsInManualFiles(Path path) {
            return this.manualDirectory != null && Files.exists(this.manualDirectory.resolve(path), new LinkOption[0]);
        }

        private boolean existsInLoadedResources(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            Identifier location = Identifier.fromNamespaceAndPath((String)namespace, (String)(directory + "/" + fileName + extension));
            return (resourceType == ResourceType.ASSET ? this.clientResources.getResource(location) : this.serverResources.getResource(location)).isPresent();
        }

        private Path constructPath(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            return Paths.get(resourceType.getDirectoryName(), namespace, directory, fileName + extension);
        }

        @Override
        public boolean doesResourceExist(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            Path path = this.constructPath(resourceType, namespace, directory, fileName, extension);
            return this.existsInGeneratedFiles(path) || this.existsInManualFiles(path) || this.existsInLoadedResources(resourceType, namespace, directory, fileName, extension);
        }

        @Override
        public void trackToBeGeneratedResource(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            this.toBeGenerated.add(this.constructPath(resourceType, namespace, directory, fileName, extension));
        }

        @Override
        public Optional<InputStream> getExistingResource(ResourceType resourceType, String namespace, String directory, String fileName, String extension) {
            Identifier location = Identifier.fromNamespaceAndPath((String)namespace, (String)(directory + "/" + fileName + extension));
            return (resourceType == ResourceType.ASSET ? this.clientResources.getResource(location) : this.serverResources.getResource(location)).map(resource -> {
                try {
                    return resource.open();
                }
                catch (IOException iOException) {
                    return null;
                }
            });
        }

        @Override
        public void saveResource(ResourceType resourceType, byte[] data, String namespace, String directory, String fileName, String extension) {
            Path fullPath;
            Path path;
            block16: {
                block15: {
                    if (!this.allowWrites) {
                        throw new RuntimeException("Resources cannot be saved during this stage!");
                    }
                    path = this.constructPath(resourceType, namespace, directory, fileName, extension);
                    fullPath = this.outputDirectory.resolve(path);
                    if (this.writtenFiles.containsKey(path) || this.aggregatedResources.containsKey(path)) break block15;
                    if (!this.cache.caches.entrySet().stream().filter(entry -> this.cache.cachesToWrite.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(cache -> cache.data().entrySet().stream()).map(Map.Entry::getKey).anyMatch(fullPath::equals)) break block16;
                }
                throw new RuntimeException("Duplicate file '" + String.valueOf(path) + "'!");
            }
            if (this.existsInManualFiles(path)) {
                throw new RuntimeException("File '" + String.valueOf(path) + "' clashes with a manually created file!");
            }
            HashCode hashCode = Hashing.sha1().hashBytes(data);
            if (this.presentFiles.containsKey(path) && this.presentFiles.get(path).equals((Object)hashCode) && fullPath.toFile().exists()) {
                this.writtenFiles.put(path, hashCode);
                this.toBeGenerated.remove(path);
                return;
            }
            fullPath.toFile().getParentFile().mkdirs();
            try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                outputStream.write(data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.writtenFiles.put(path, hashCode);
            this.toBeGenerated.remove(path);
            ++this.writes;
        }

        @Override
        public <T> void saveResource(ResourceType resourceType, ResourceAggregator<?, T> aggregator, T data, String namespace, String directory, String fileName, String extension) {
            Path path;
            block9: {
                block8: {
                    if (!this.allowWrites) {
                        throw new RuntimeException("Resources cannot be saved during this stage!");
                    }
                    path = this.constructPath(resourceType, namespace, directory, fileName, extension);
                    Path fullPath = this.outputDirectory.resolve(path);
                    if (this.writtenFiles.containsKey(path)) break block8;
                    if (!this.cache.caches.entrySet().stream().filter(entry -> this.cache.cachesToWrite.contains(entry.getKey())).map(Map.Entry::getValue).flatMap(cache -> cache.data().entrySet().stream()).map(Map.Entry::getKey).anyMatch(fullPath::equals)) break block9;
                }
                throw new RuntimeException("Duplicate file '" + String.valueOf(path) + "'!");
            }
            if (this.existsInManualFiles(path)) {
                throw new RuntimeException("File '" + String.valueOf(path) + "' clashes with a manually created file!");
            }
            Pair<ResourceAggregator<Object, Object>, Object> oldEntry = this.aggregatedResources.get(path);
            if (oldEntry != null && oldEntry.left() != aggregator) {
                throw new RuntimeException("Incompatible aggregators for file '" + String.valueOf(path) + "': '" + String.valueOf(oldEntry.left().getClass()) + "' and '" + String.valueOf(aggregator.getClass()) + "'!");
            }
            Object oldData = oldEntry == null ? aggregator.initialData() : oldEntry.right();
            try {
                oldData = aggregator.combine(oldData, data);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to combine data for file '" + String.valueOf(path) + "'!", e);
            }
            this.aggregatedResources.put(path, Pair.of(aggregator, oldData));
        }

        public void allowWrites(boolean allow) {
            this.allowWrites = allow;
        }

        public void finish() {
            this.aggregatedResources.forEach((path, pair) -> {
                byte[] bytes;
                ResourceAggregator aggregator = (ResourceAggregator)pair.left();
                Object data = pair.right();
                try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
                    aggregator.write(stream, data);
                    bytes = stream.toByteArray();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                Path fullPath = this.outputDirectory.resolve((Path)path);
                HashCode hashCode = Hashing.sha1().hashBytes(bytes);
                if (this.presentFiles.containsKey(path) && this.presentFiles.get(path).equals((Object)hashCode) && fullPath.toFile().exists()) {
                    this.writtenFiles.put((Path)path, hashCode);
                    this.toBeGenerated.remove(path);
                    return;
                }
                fullPath.toFile().getParentFile().mkdirs();
                try (OutputStream outputStream = Files.newOutputStream(fullPath, new OpenOption[0]);){
                    outputStream.write(bytes);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.writtenFiles.put((Path)path, hashCode);
                this.toBeGenerated.remove(path);
                ++this.writes;
            });
            ImmutableMap.Builder builder = ImmutableMap.builder();
            this.writtenFiles.forEach((path, hashCode) -> builder.put((Object)this.outputDirectory.resolve((Path)path), hashCode));
            HashCache.ProviderCache cache = new HashCache.ProviderCache(this.cache.versionId, builder.build());
            this.cache.applyUpdate(new HashCache.UpdateResult("Core Lib Generators", cache, this.writes));
            this.cache.cachePaths.add(this.cache.getProviderCachePath("Core Lib Generators"));
            if (!this.toBeGenerated.isEmpty()) {
                throw new RuntimeException("Some tracked files did not get written: " + this.toBeGenerated.stream().map(Path::toString).map(s -> "'" + s + "'").collect(Collectors.joining(",")));
            }
        }
    }
}

