/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.registry.Registries;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.DependantName;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public class BaseBlock
extends Block {
    private static final ThreadLocal<DependantName<Block, Optional<ResourceKey<LootTable>>>> LAST_REMOVED_DROPS = new ThreadLocal();
    public static final DataComponentType<CompoundTag> TILE_DATA = DataComponentType.builder().persistent(CompoundTag.CODEC).build();
    private final boolean saveTileData;
    private final BlockProperties properties;
    private final DependantName<Block, Optional<ResourceKey<LootTable>>> vanillaDrops;
    private boolean resolvedDrops;
    private boolean resolvedRegistryDependencies;

    private BaseBlock(boolean saveTileData, BlockBehaviour.Properties properties, BlockProperties blockProperties) {
        super(BaseBlock.removeDescriptionAndDropsFromProperties(properties));
        this.saveTileData = saveTileData;
        this.properties = blockProperties;
        this.vanillaDrops = LAST_REMOVED_DROPS.get();
        LAST_REMOVED_DROPS.remove();
    }

    public BaseBlock(boolean saveTileData, BlockBehaviour.Properties properties) {
        this(saveTileData, properties, null);
    }

    public BaseBlock(boolean saveTileData, BlockProperties properties) {
        this(saveTileData, properties.toUnderlying(), properties);
    }

    private static BlockBehaviour.Properties removeDescriptionAndDropsFromProperties(BlockBehaviour.Properties properties) {
        LAST_REMOVED_DROPS.set((DependantName<Block, Optional<ResourceKey<LootTable>>>)properties.drops);
        return properties.overrideDescription("").noLootTable().setId(ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (Identifier)Identifier.fromNamespaceAndPath((String)"supermartijn642corelib", (String)"dummy")));
    }

    @ApiStatus.Internal
    public void resolveRegistryDependencies() {
        if (!this.resolvedDrops) {
            this.getLootTable();
        }
        if (!this.resolvedRegistryDependencies) {
            Identifier identifier = Registries.BLOCKS.getIdentifier(this);
            this.descriptionId = identifier.getNamespace() + ".block." + identifier.getPath();
            this.resolvedRegistryDependencies = true;
        }
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!this.saveTileData) {
            return;
        }
        if (!stack.has(TILE_DATA)) {
            return;
        }
        CompoundTag tag = (CompoundTag)stack.get(TILE_DATA);
        if (tag == null || tag.isEmpty()) {
            return;
        }
        BlockEntity entity = worldIn.getBlockEntity(pos);
        if (entity instanceof BaseBlockEntity) {
            ((BaseBlockEntity)entity).readData(TagValueInput.create((ProblemReporter)new ProblemReporter.ScopedCollector(entity.problemPath(), CoreLib.LOGGER), (HolderLookup.Provider)worldIn.registryAccess(), (CompoundTag)tag));
        }
    }

    public Optional<ResourceKey<LootTable>> getLootTable() {
        if (!this.resolvedDrops) {
            if (this.properties != null) {
                if (this.properties.noLootTable) {
                    this.drops = Optional.empty();
                } else if (this.properties.lootTable != null) {
                    Identifier identifier = Registries.BLOCKS.getIdentifier(this);
                    ResourceKey key = ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (Identifier)identifier);
                    this.drops = this.properties.lootTable.apply((ResourceKey<Block>)key);
                } else if (this.properties.lootTableBlock != null) {
                    Block block = this.properties.lootTableBlock.get();
                    if (block == null) {
                        CoreLib.LOGGER.warn("Received null block from BlockProperties#lootTableFrom's supplier for block '{}'!", (Object)Registries.BLOCKS.getIdentifier(this));
                        this.drops = Optional.empty();
                    } else {
                        this.drops = block.getLootTable();
                    }
                } else {
                    this.drops = Optional.of(ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.LOOT_TABLE, (Identifier)Registries.BLOCKS.getIdentifier(this).withPrefix("blocks/")));
                }
            } else {
                Identifier identifier = Registries.BLOCKS.getIdentifier(this);
                ResourceKey key = ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (Identifier)identifier);
                this.drops = (Optional)this.vanillaDrops.get(key);
            }
            this.resolvedDrops = true;
        }
        return this.drops;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        List items = super.getDrops(state, builder);
        if (!this.saveTileData) {
            return items;
        }
        BlockEntity entity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (!(entity instanceof BaseBlockEntity)) {
            return items;
        }
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)new ProblemReporter.ScopedCollector(entity.problemPath(), CoreLib.LOGGER), (HolderLookup.Provider)entity.getLevel().registryAccess());
        ((BaseBlockEntity)entity).writeItemStackData((ValueOutput)output);
        if (output.isEmpty()) {
            return items;
        }
        CompoundTag entityTag = output.buildResult();
        for (ItemStack stack : items) {
            if (!(stack.getItem() instanceof BlockItem) || ((BlockItem)stack.getItem()).getBlock() != this) continue;
            stack.set(TILE_DATA, (Object)entityTag);
        }
        return items;
    }

    protected ItemStack getCloneItemStack(LevelReader world, BlockPos pos, BlockState state, boolean includeData) {
        ItemStack stack = super.getCloneItemStack(world, pos, state, includeData);
        if (!this.saveTileData) {
            return stack;
        }
        BlockEntity entity = world.getBlockEntity(pos);
        if (!(entity instanceof BaseBlockEntity)) {
            return stack;
        }
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)new ProblemReporter.ScopedCollector(entity.problemPath(), CoreLib.LOGGER), (HolderLookup.Provider)world.registryAccess());
        ((BaseBlockEntity)entity).writeItemStackData((ValueOutput)output);
        if (output.isEmpty()) {
            return stack;
        }
        CompoundTag entityTag = output.buildResult();
        if (stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() == this) {
            stack.remove(DataComponents.BLOCK_ENTITY_DATA);
            stack.set(TILE_DATA, (Object)entityTag);
        }
        return stack;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return this.interact((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand, (Direction)hitResult.getDirection(), (Vec3)hitResult.getLocation()).interactionResult;
    }

    protected InteractionFeedback interact(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, Direction hitSide, Vec3 hitLocation) {
        return InteractionFeedback.PASS;
    }

    public void appendItemInformation(ItemStack stack, Consumer<Component> info, boolean advanced) {
    }

    public Item asItem() {
        return super.asItem();
    }

    public String getDescriptionId() {
        this.resolveRegistryDependencies();
        return super.getDescriptionId();
    }

    protected static enum InteractionFeedback {
        PASS((InteractionResult)InteractionResult.PASS),
        CONSUME((InteractionResult)InteractionResult.CONSUME),
        SUCCESS((InteractionResult)InteractionResult.SUCCESS);

        private final InteractionResult interactionResult;

        private InteractionFeedback(InteractionResult interactionResult) {
            this.interactionResult = interactionResult;
        }
    }
}

