/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.CoreSide;
import com.supermartijn642.core.gui.BaseContainer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtils {
    private static MinecraftServer server;

    static void initialize() {
        NeoForge.EVENT_BUS.addListener(e -> {
            server = e.getServer();
        });
        NeoForge.EVENT_BUS.addListener(e -> {
            server = null;
        });
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static Level getLevel(ResourceKey<Level> resourceKey) {
        MinecraftServer server = CommonUtils.getServer();
        return server == null ? null : server.getLevel(resourceKey);
    }

    public static RegistryAccess getRegistryAccess() {
        MinecraftServer server = CommonUtils.getServer();
        if (server == null && CommonUtils.getEnvironmentSide().isClient()) {
            Level level = ClientUtils.getWorld();
            return level == null ? null : level.registryAccess();
        }
        return server == null ? null : server.registryAccess();
    }

    public static CoreSide getEnvironmentSide() {
        return CoreSide.fromUnderlying(FMLEnvironment.getDist());
    }

    public static boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public static void openContainer(final BaseContainer container) {
        Player player = container.player;
        if (!(container.player instanceof ServerPlayer)) {
            return;
        }
        player.openMenu(new MenuProvider(){

            public Component getDisplayName() {
                return Component.empty();
            }

            public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
                container.setContainerId(windowId);
                return container;
            }
        }, data -> container.getContainerType().writeContainer(container, (FriendlyByteBuf)data));
    }

    public static void closeContainer(Player player) {
        player.closeContainer();
    }

    public static Logger getLogger(String modid) {
        return LoggerFactory.getLogger((String)modid);
    }
}

