/*
 * Decompiled with CFR 0.152.
 */
package com.cupboard.util;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.function.UnaryOperator;
import net.minecraft.IdentifierException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;

public class ResourceLocation
extends Identifier {
    public static Codec<ResourceLocation> CODEC = Codec.STRING.comapFlatMap(ResourceLocation::readRes, Identifier::toString).stable();
    public static StreamCodec<ByteBuf, ResourceLocation> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ResourceLocation::parse, Identifier::toString);
    public static SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable((String)"argument.id.invalid"));

    public ResourceLocation(String namespace, String path) {
        super(namespace, path);
    }

    static ResourceLocation createUntrusted(String string, String string2) {
        return new ResourceLocation(ResourceLocation.assertValidNamespace(string, string2), ResourceLocation.assertValidPath(string, string2));
    }

    public static ResourceLocation fromNamespaceAndPath(String string, String string2) {
        return ResourceLocation.createUntrusted(string, string2);
    }

    public static ResourceLocation parse(String string) {
        return ResourceLocation.bySeparator(string, ':');
    }

    public static ResourceLocation withDefaultNamespace(String string) {
        return new ResourceLocation("minecraft", ResourceLocation.assertValidPath("minecraft", string));
    }

    public static @Nullable ResourceLocation tryParse(String string) {
        return ResourceLocation.tryBySeparator(string, ':');
    }

    public static @Nullable ResourceLocation tryBuild(String string, String string2) {
        return ResourceLocation.isValidNamespace(string) && ResourceLocation.isValidPath(string2) ? new ResourceLocation(string, string2) : null;
    }

    public static ResourceLocation bySeparator(String string, char c) {
        int i = string.indexOf(c);
        if (i >= 0) {
            String string2 = string.substring(i + 1);
            if (i != 0) {
                String string3 = string.substring(0, i);
                return ResourceLocation.createUntrusted(string3, string2);
            }
            return ResourceLocation.withDefaultNamespace(string2);
        }
        return ResourceLocation.withDefaultNamespace(string);
    }

    public static @Nullable ResourceLocation tryBySeparator(String string, char c) {
        int i = string.indexOf(c);
        if (i >= 0) {
            String string2 = string.substring(i + 1);
            if (!ResourceLocation.isValidPath(string2)) {
                return null;
            }
            if (i != 0) {
                String string3 = string.substring(0, i);
                return ResourceLocation.isValidNamespace(string3) ? new ResourceLocation(string3, string2) : null;
            }
            return new ResourceLocation("minecraft", string2);
        }
        return ResourceLocation.isValidPath(string) ? new ResourceLocation("minecraft", string) : null;
    }

    public static DataResult<ResourceLocation> readRes(String string) {
        try {
            return DataResult.success((Object)((Object)ResourceLocation.parse(string)));
        }
        catch (IdentifierException var2) {
            IdentifierException ResourceLocationException = var2;
            return DataResult.error(() -> "Not a valid resource location: " + string + " " + ResourceLocationException.getMessage());
        }
    }

    static String readGreedy(StringReader stringReader) {
        int i = stringReader.getCursor();
        while (stringReader.canRead() && ResourceLocation.isAllowedInResourceLocation(stringReader.peek())) {
            stringReader.skip();
        }
        return stringReader.getString().substring(i, stringReader.getCursor());
    }

    public static ResourceLocation read(StringReader stringReader) throws CommandSyntaxException {
        int i = stringReader.getCursor();
        String string = ResourceLocation.readGreedy(stringReader);
        try {
            return ResourceLocation.parse(string);
        }
        catch (IdentifierException var4) {
            stringReader.setCursor(i);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)stringReader);
        }
    }

    public static ResourceLocation readNonEmpty(StringReader stringReader) throws CommandSyntaxException {
        int i = stringReader.getCursor();
        String string = ResourceLocation.readGreedy(stringReader);
        if (string.isEmpty()) {
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)stringReader);
        }
        try {
            return ResourceLocation.parse(string);
        }
        catch (IdentifierException var4) {
            stringReader.setCursor(i);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)stringReader);
        }
    }

    static boolean isAllowedInResourceLocation(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }

    public static boolean isValidPath(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (ResourceLocation.validPathChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNamespace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (ResourceLocation.validNamespaceChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static String assertValidNamespace(String string, String string2) {
        if (!ResourceLocation.isValidNamespace(string)) {
            throw new IdentifierException("Non [a-z0-9_.-] character in namespace of location: " + string + ":" + string2);
        }
        return string;
    }

    public static boolean validPathChar(char c) {
        return c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '/' || c == '.';
    }

    public static boolean validNamespaceChar(char c) {
        return c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.';
    }

    static String assertValidPath(String string, String string2) {
        if (!ResourceLocation.isValidPath(string2)) {
            throw new IdentifierException("Non [a-z0-9/._-] character in path of location: " + string + ":" + string2);
        }
        return string2;
    }

    public ResourceLocation withPath(String string) {
        return new ResourceLocation(string, string);
    }

    public ResourceLocation withPath(UnaryOperator<String> unaryOperator) {
        return this.withPath((String)unaryOperator.apply(this.getPath()));
    }

    public ResourceLocation withPrefix(String string) {
        return this.withPath(string + this.getPath());
    }

    public ResourceLocation withSuffix(String string) {
        return this.withPath(this.getPath() + string);
    }
}

