/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInsertBlockOverride;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;

public class InceptionInventoryHandler
implements ITrackedContentsItemResourceHandler {
    private final ITrackedContentsItemResourceHandler wrappedInventoryHandler;
    private final InventoryOrder inventoryOrder;
    private final SubBackpacksHandler subBackpacksHandler;
    private List<ITrackedContentsItemResourceHandler> handlers;
    private int[] baseIndex;
    private int totalSize;

    public InceptionInventoryHandler(ITrackedContentsItemResourceHandler wrappedInventoryHandler, InventoryOrder inventoryOrder, SubBackpacksHandler subBackpacksHandler) {
        this.wrappedInventoryHandler = wrappedInventoryHandler;
        this.inventoryOrder = inventoryOrder;
        this.subBackpacksHandler = subBackpacksHandler;
        subBackpacksHandler.addRefreshListener(sbs -> this.refreshHandlerDelegate());
        this.refreshHandlerDelegate();
    }

    private void refreshHandlerDelegate() {
        this.handlers = new ArrayList<ITrackedContentsItemResourceHandler>();
        if (this.inventoryOrder == InventoryOrder.MAIN_FIRST) {
            this.handlers.add(this.wrappedInventoryHandler);
        }
        this.subBackpacksHandler.getSubBackpacks().forEach(sbp -> this.handlers.add(sbp.getInventoryForInputOutput()));
        if (this.inventoryOrder == InventoryOrder.INCEPTED_FIRST) {
            this.handlers.add(this.wrappedInventoryHandler);
        }
        this.baseIndex = new int[this.handlers.size()];
        int index = 0;
        for (int i = 0; i < this.handlers.size(); ++i) {
            this.baseIndex[i] = index += this.handlers.get(i).size();
        }
        this.totalSize = index;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        int handlerIndex = this.getHandlerIndex(slot);
        this.getHandlerFromIndex(handlerIndex).setStackInSlot(this.getSlotFromIndex(slot, handlerIndex), stack);
    }

    public int size() {
        return this.totalSize;
    }

    public ItemResource getResource(int i) {
        int handlerIndex = this.getHandlerIndex(i);
        return (ItemResource)this.getHandlerFromIndex(handlerIndex).getResource(this.getSlotFromIndex(i, handlerIndex));
    }

    public long getAmountAsLong(int i) {
        int handlerIndex = this.getHandlerIndex(i);
        return this.getHandlerFromIndex(handlerIndex).getAmountAsLong(this.getSlotFromIndex(i, handlerIndex));
    }

    public ItemStack getStackInSlot(int slot) {
        int handlerIndex = this.getHandlerIndex(slot);
        return this.getHandlerFromIndex(handlerIndex).getStackInSlot(this.getSlotFromIndex(slot, handlerIndex));
    }

    public int insert(ItemResource resource, int amount, TransactionContext transaction) {
        ITrackedContentsItemResourceHandler handler;
        int r;
        int inserted = 0;
        Iterator<ITrackedContentsItemResourceHandler> iterator = this.handlers.iterator();
        while (iterator.hasNext() && (inserted += (r = (handler = iterator.next()).insert((Resource)resource, amount - inserted, transaction))) < amount) {
        }
        return inserted;
    }

    public int insert(int index, ItemResource resource, int amount, TransactionContext tx) {
        int handlerIndex = this.getHandlerIndex(index);
        return this.getHandlerFromIndex(handlerIndex).insert(this.getSlotFromIndex(index, handlerIndex), (Resource)resource, amount, tx);
    }

    public int extract(int index, ItemResource resource, int amount, TransactionContext tx) {
        int handlerIndex = this.getHandlerIndex(index);
        return this.getHandlerFromIndex(handlerIndex).extract(this.getSlotFromIndex(index, handlerIndex), (Resource)resource, amount, tx);
    }

    public long getCapacityAsLong(int index, ItemResource resource) {
        int handlerIndex = this.getHandlerIndex(index);
        return this.getHandlerFromIndex(handlerIndex).getCapacityAsLong(this.getSlotFromIndex(index, handlerIndex), (Resource)resource);
    }

    public boolean isValid(int index, ItemResource resource) {
        int handlerIndex = this.getHandlerIndex(index);
        return this.getHandlerFromIndex(handlerIndex).isValid(this.getSlotFromIndex(index, handlerIndex), (Resource)resource);
    }

    public Set<ItemStackKey> getTrackedStacks() {
        HashSet<ItemStackKey> ret = new HashSet<ItemStackKey>();
        this.handlers.forEach(h -> ret.addAll(h.getTrackedStacks()));
        return ret;
    }

    public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.handlers.forEach(h -> h.registerTrackingListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot));
    }

    public void unregisterStackKeyListeners() {
        this.handlers.forEach(ITrackedContentsItemResourceHandler::unregisterStackKeyListeners);
    }

    public boolean hasEmptySlots() {
        return this.handlers.stream().anyMatch(ITrackedContentsItemResourceHandler::hasEmptySlots);
    }

    public int getInternalSlotLimit(int slot) {
        int index = this.getHandlerIndex(slot);
        ITrackedContentsItemResourceHandler handler = this.getHandlerFromIndex(index);
        int localSlot = this.getSlotFromIndex(slot, index);
        return handler.getInternalSlotLimit(localSlot);
    }

    private int getHandlerIndex(int slot) {
        if (slot < 0) {
            return -1;
        }
        for (int i = 0; i < this.baseIndex.length; ++i) {
            if (slot - this.baseIndex[i] >= 0) continue;
            return i;
        }
        return -1;
    }

    private int getSlotFromIndex(int slot, int index) {
        if (index <= 0 || index >= this.baseIndex.length) {
            return slot;
        }
        return slot - this.baseIndex[index - 1];
    }

    private ITrackedContentsItemResourceHandler getHandlerFromIndex(int index) {
        if (index < 0 || index >= this.handlers.size()) {
            return this.handlers.getFirst();
        }
        return this.handlers.get(index);
    }

    public boolean isInsertBlocked() {
        return this.handlers.stream().allMatch(IInsertBlockOverride::isInsertBlocked);
    }
}

